# Copyright 2019 Google LLC All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set(agones_VERSION 0.0.0)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was agonesConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

#################################################################################### 

set(agones_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/agones/include)

set(AGONES_OWN_GRPC )
if (${AGONES_OWN_GRPC})
    set(ZLIB_ROOT )
    set(ZLIB_LIBRARIES )
    set(OPENSSL_ROOT_DIR )
endif()

include(CMakeFindDependencyMacro)
find_dependency(ZLIB)
find_dependency(Protobuf CONFIG)
find_dependency(gRPC CONFIG)
include("${CMAKE_CURRENT_LIST_DIR}/agonesTargets.cmake")

check_required_components(agones)
