package com.test.questionnairesdk.library

import android.util.Log
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.RelativeLayout
import androidx.appcompat.app.AppCompatActivity
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

public class AskribeSDK {
    companion object {
        private var ASKRIBE_KEY: String? = null

        var requestObject: QuestionnaireEmbedSessionDTO? = null
        var onExitCallback: (() -> Unit)? = null

        fun initialize(key: String) {
            ASKRIBE_KEY = key
        }

        fun showQuestionnaire(
            context: AppCompatActivity,
            initData: AskribeParams,
            onExit: (() -> Unit)? = null
        ) {
            requestObject = null
            requestObject = QuestionnaireEmbedSessionDTO()
            requestObject?.questionnaireId = initData.questionnaireId
            requestObject?.questionnaireTags = initData.questionnaireTags
            requestObject?.workspaceId = initData.workspaceId
            requestObject?.distributionType = initData.distributionType
            requestObject?.receiversEmailAddress = initData.receiversEmailAddress
            requestObject?.receiversPhoneNumber = initData.receiversPhoneNumber
            requestObject?.allContentVarsValues = initData.allContentVarsValues
            requestObject?.futureSessionId = initData.futureSessionId
            requestObject?.flowType = "QUESTIONNAIRE"
            requestObject?.isDryRun = false
            requestObject?.context = initData.context
            requestObject?.sessionStatus = "CREATED"

            onExitCallback = onExit

            requestObject?.let {
                getQuestionnaireConfig(context, it, onExit)
            }
        }

        fun getQuestionnaireConfig(
            context: AppCompatActivity,
            requestBody: QuestionnaireEmbedSessionDTO,
            onExit: (() -> Unit)?
        ) {

            RetrofitNetworking.apiService
                .getQuestionnaireEmbed(requestBody)
                .enqueue(object : Callback<QuestionResponse> {
                    override fun onFailure(call: Call<QuestionResponse>, t: Throwable) {
                        Log.e("Something", "something")
                    }

                    override fun onResponse(
                        call: Call<QuestionResponse>,
                        response: Response<QuestionResponse>
                    ) {
                        val result = response.body()
                        requestObject?.questionnaireId = result?.questionnareId
                        requestObject?.questionnaireTags = null

                        if (result?.displayType == DisplayType.FULL_SCREEN || result?.displayType == DisplayType.EMBED) {
                            val ll = RelativeLayout(context)

                            val layoutParams = RelativeLayout.LayoutParams(
                                ViewGroup.LayoutParams.MATCH_PARENT,
                                ViewGroup.LayoutParams.MATCH_PARENT
                            )

                            ll.layoutParams = layoutParams
                            ll.id = android.R.id.addToDictionary

                            context.supportFragmentManager.beginTransaction().add(
                                ll.id,
                                QuestionnaireWebviewFragment(), "q"
                            ).commit()
                            context.addContentView(
                                ll,
                                LinearLayout.LayoutParams(
                                    LinearLayout.LayoutParams.MATCH_PARENT,
                                    LinearLayout.LayoutParams.MATCH_PARENT
                                )
                            )
                            onExitCallback = {
                                onExit?.invoke()
                                (ll.parent as ViewGroup).removeView(ll)
                            }

                        } else if (result?.displayType == DisplayType.DIALOG ) {
                            val ll = RelativeLayout(context)

                            val layoutParams = RelativeLayout.LayoutParams(
                                600,
                                800
                            )
                            layoutParams.addRule(RelativeLayout.CENTER_IN_PARENT)
                            ll.layoutParams = layoutParams
                            ll.id = android.R.id.addToDictionary

                            val parent = RelativeLayout.LayoutParams(
                                600,
                                800
                            )
                            parent.addRule(RelativeLayout.CENTER_IN_PARENT,1)
                            parent.addRule(RelativeLayout.CENTER_HORIZONTAL,1)
                            context.addContentView(
                                ll,
                                parent
                            )

                            layoutParams.addRule(RelativeLayout.CENTER_IN_PARENT)
                            ll.requestLayout()

                            context.supportFragmentManager.beginTransaction().add(
                                ll.id,
                                QuestionnaireWebviewFragment(), "q"
                            ).commit()


                            onExitCallback = {
                                onExit?.invoke()
                                (ll.parent as ViewGroup).removeView(ll)
                            }

                        } else if (result?.displayType == DisplayType.BUBBLE || result?.displayType == DisplayType.POPUP) {
                            val ll = RelativeLayout(context)

                            val layoutParams = RelativeLayout.LayoutParams(
                                ViewGroup.LayoutParams.MATCH_PARENT,
                                ViewGroup.LayoutParams.MATCH_PARENT
                            )

                            ll.layoutParams = layoutParams
                            ll.id = android.R.id.addToDictionary
                            val parent = RelativeLayout.LayoutParams(
                                600,
                                800
                            )
                            parent.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM,1)
                            parent.addRule(RelativeLayout.ALIGN_PARENT_RIGHT,1)
                            context.addContentView(
                                ll,
                                parent
                            )
                            context.supportFragmentManager.beginTransaction().add(
                                ll.id,
                                QuestionnaireWebviewFragment(), "q"
                            ).commit()

                            onExitCallback = {
                                onExit?.invoke()
                                (ll.parent as ViewGroup).removeView(ll)
                            }

                        }

                    }
                })

        }


    }

}