package com.test.questionnairesdk.library

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class QuestionResponse(

    @field:JsonProperty("questionnareId")
    var questionnareId: String? = null,

    @field:JsonProperty("displayType")
    var displayType: DisplayType? = null,

    @field:JsonProperty("displayPosition")
    var displayPosition: DisplayPosition? = null,

    @field:JsonProperty("displayAfterTime")
    var displayAfterTime: Int? = null

)

enum class DisplayType(var displayType: String) {
    POPUP("POPUP"),
    BUBBLE("BUBBLE"),
    DIALOG("DIALOG"),
    EMBED("EMBED"),
    FULL_SCREEN("FULL_SCREEN");
}

enum class DisplayPosition(var displayPosition: String) {
    BOTTOM_LEFT("BOTTOM_LEFT"),
    BOTTOM_RIGHT("BOTTOM_RIGHT");
}