package com.test.questionnairesdk.library

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class QuestionnaireEmbedSessionDTO(

    @field:JsonProperty("consumerDetailsId")
    var consumerDetailsId: String? = null,

    @field:JsonProperty("orderId")
    var orderId: String? = null,

    @field:JsonProperty("consumerId")
    var consumerId: String? = null,

    @field:JsonProperty("workspaceId")
    var workspaceId: String? = null,

    @field:JsonProperty("sessionStatus")
    var sessionStatus: String? = null,

    @field:JsonProperty("context")
    var context: Map<String, VariableData>? = null,

    @field:JsonProperty("isDryRun")
    var isDryRun: Boolean? = null,

    @field:JsonProperty("storeId")
    var storeId: String? = null,

    @field:JsonProperty("flowType")
    var flowType: String? = null,

    @field:JsonProperty("allContentVarsValues")
    var allContentVarsValues: Map<String, ContentVarValueData?>? = null,

    @field:JsonProperty("questionnaireId")
    var questionnaireId: String? = null,

    @field:JsonProperty("questionnaireTags")
    var questionnaireTags: List<String?>? = null,

    @field:JsonProperty("receiversEmailAddress")
    var receiversEmailAddress: String? = null,

    @field:JsonProperty("receiversPhoneNumber")
    var receiversPhoneNumber: String? = null,

    @field:JsonProperty("futureSessionId")
    var futureSessionId: String? = null,

    @field:JsonProperty("distributionType")
    var distributionType: DistributionType? = null
)