package com.test.questionnairesdk.library

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class QuestionnaireSessionDTO(

    @field:JsonProperty("consumerDetailsId")
    val consumerDetailsId: String? = null,

    @field:JsonProperty("orderId")
    val orderId: String? = null,

    @field:JsonProperty("consumerId")
    val consumerId: String? = null,

    @field:JsonProperty("businessId")
    val businessId: String? = null,

    @field:JsonProperty("sessionStatus")
    val sessionStatus: String? = null,

    @field:JsonProperty("context")
    val context: Map<String, VariableData>? = null,

    @field:JsonProperty("isDryRun")
    val isDryRun: Boolean? = null,

    @field:JsonProperty("storeId")
    val storeId: String? = null,

    @field:JsonProperty("flowType")
    val flowType: String? = null,

    @field:JsonProperty("allContentVarsValues")
    var allContentVarsValues: Map<String, ContentVarValueData?>? = null

)