package com.test.questionnairesdk.library

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class VariableData(

    @field:JsonProperty("variableType")
    val variableType: VariableType? = null,

    @field:JsonProperty("stringsList")
    val stringsList: List<String>? = null,

    @field:JsonProperty("number")
    val number: Double? = null,

    @field:JsonProperty("string")
    val string: String? = null,

    @field:JsonProperty("numbersList")
    val numbersList: List<Double>? = null
)

enum class VariableType private constructor(internal var variableType: String) {
    DOUBLE("DOUBLE"),
    LIST_DOUBLE("LIST_DOUBLE"),
    STRING("STRING"),
    LIST_STRING("LIST_STRING")
}