//
//  ViewController.swift
//  QuestionnaireSDKiOS
//
//  Created by Priyam Agarwal on 31/10/20.
//  Copyright © 2020 Fashtag. All rights reserved.
//

import UIKit
import WebKit
import ReplayKit
import Photos
import ShowTime

let NativeBridge = "NativeBridge"

class ViewController: UIViewController {
	
	private let webView = WKWebView(frame: .zero)
	@IBOutlet weak var overlayWebview: WKWebView!
	@IBOutlet weak var stopButton: UIButton!
	@IBOutlet weak var annotateButton: UIButton!
	@IBAction func stopButtonClicked(_ sender: UIButton) {
		stopRecording()
		overlayWebview.isHidden = true
	}
	@IBAction func annotateButtonClicked(_ sender: UIButton) {
		overlayWebview.isHidden = !overlayWebview.isHidden
	}
	
	let recorder = RPScreenRecorder.shared()
	var videoOutputURL: URL? = nil
	var videoWriter: AVAssetWriter!
	var videoWriterInput: AVAssetWriterInput!
	private var isRecording = false
	
	
	var qData: QuestionnaireEmbedSessionDTO? = nil
	var questionResponse: QuestionResponse? = nil
	
	
	func showQuestionnaire(askribeParams: AskribeParams) {
		qData = QuestionnaireEmbedSessionDTO()
		qData?.questionnaireId = askribeParams.questionnaireId
		qData?.questionnaireTags = askribeParams.questionnaireTags
		qData?.workspaceId = askribeParams.workspaceId
		qData?.distributionType = askribeParams.distributionType
		qData?.receiversEmailAddress = askribeParams.receiversEmailAddress
		qData?.receiversPhoneNumber = askribeParams.receiversPhoneNumber
		qData?.allContentVarsValues = askribeParams.allContentVarsValues
		qData?.futureSessionId = askribeParams.futureSessionId
		qData?.flowType = "QUESTIONNAIRE"
		qData?.isDryRun = false
		qData?.context = askribeParams.context
		qData?.sessionStatus = "CREATED"
		
		
		let url = URL(string: "\(Constants.BACKEND_BASE_URL)consumer/app-embed-config")!
		var request = URLRequest(url: url)
		request.httpMethod = "POST"
		
		let jsonEncoder = JSONEncoder()
		guard let jsonData = try? jsonEncoder.encode(qData) else { return }
		let jsonString = String(data: jsonData, encoding: .utf8)
		
		request.httpBody = jsonString?.data(using: .utf8)

		request.addValue("application/json", forHTTPHeaderField: "Content-Type")
		let task = URLSession.shared.dataTask(with: request) { [self](data, response, error) in
			guard let data = data else { return }
			let jsonResponse = try? JSONSerialization.jsonObject(with: data, options: .mutableContainers) as? NSDictionary
			questionResponse = QuestionResponse()
			questionResponse?.displayAfterTime = jsonResponse?["displayAfterTime"] as? Int
			questionResponse?.displayPosition = jsonResponse?["displayPosition"] as? String
			questionResponse?.displayType = jsonResponse?["displayType"] as? String
			questionResponse?.questionnareId = jsonResponse?["questionnareId"] as? String
			
			let request = URLRequest(url: URL(string: "\(Constants.BASE_URL)/mobile-consumer")!)
			//TODO: Move to UI Thread
			DispatchQueue.main.async {
				webView.removeFromSuperview()
				webView.translatesAutoresizingMaskIntoConstraints = false
				view.backgroundColor = .red
				self.view.addSubview(self.webView)
				
				if (questionResponse?.displayType=="FULL_SCREEN"){
					NSLayoutConstraint.activate([
						self.webView.leftAnchor.constraint(equalTo: self.view.leftAnchor),
						self.webView.bottomAnchor.constraint(equalTo: self.view.bottomAnchor),
						self.webView.rightAnchor.constraint(equalTo: self.view.rightAnchor),
						self.webView.topAnchor.constraint(equalTo: self.view.topAnchor),
					])
				}else if (questionResponse?.displayType=="DIALOG"){
					NSLayoutConstraint.activate([
						self.webView.topAnchor.constraint(equalTo: self.view.topAnchor, constant: 100),
						self.webView.leftAnchor.constraint(equalTo: self.view.leftAnchor,constant: 30),
						self.webView.rightAnchor.constraint(equalTo: self.view.rightAnchor,constant: -30),
						self.webView.bottomAnchor.constraint(equalTo: self.view.bottomAnchor, constant: -100),
					])
				} else if (questionResponse?.displayType=="BUBBLE" || questionResponse?.displayType=="POPUP"){
					NSLayoutConstraint.activate([
						self.webView.heightAnchor.constraint(equalTo: self.view.heightAnchor, multiplier: 0.6),
						self.webView.bottomAnchor.constraint(equalTo: self.view.bottomAnchor,constant: -30),
						self.webView.rightAnchor.constraint(equalTo: self.view.rightAnchor,constant: -30),
						self.webView.widthAnchor.constraint(equalTo: self.view.widthAnchor, multiplier: 0.6),
					])
				} else if (questionResponse?.displayType=="BUBBLE" || questionResponse?.displayType=="POPUP"){
					// TO be set by the user
				}
				
				
				// For constant height use the below constraint and set your height constant and remove either top or bottom constraint
				//self.webView.heightAnchor.constraint(equalToConstant: 200.0),
				
				self.view.setNeedsLayout()
				
				webView.load(request)
			}
		}
		
		task.resume()
		
	}
	
	override func viewDidLoad() {
		super.viewDidLoad()
		
		
		let askribeParams = AskribeParams()
		
		askribeParams.questionnaireId = "61dce2b94801901e1b9c763b"
		askribeParams.workspaceId = "61d8257d480190135db7671a"
		askribeParams.distributionType = "APP_EMBED"
		
		showQuestionnaire(askribeParams: askribeParams)
		
		stopButton.isHidden = true
		annotateButton.isHidden = true
		overlayWebview.isHidden = true
		ShowTime.enabled = .never

		
//		self.overlayWebview.isOpaque = false
//		self.overlayWebview.backgroundColor = UIColor.clear
//		self.overlayWebview.scrollView.backgroundColor = UIColor.clear
//		let request = URLRequest(url: URL(string: "\(Constants.BASE_URL)/mobile-overlay")!)
//		overlayWebview.load(request)
		
		self.webView.configuration.allowsInlineMediaPlayback = true
		
		let contentController = self.webView.configuration.userContentController
		contentController.add(self, name: NativeBridge)
		
	}
	
	@objc func startRecording(){
		ShowTime.enabled = .always
		stopButton.isHidden = false
		annotateButton.isHidden = false
		guard recorder.isAvailable else {
			return
		}
		recorder.isMicrophoneEnabled = true
		
		recorder.startRecording{ [unowned self] (error) in
			guard error == nil else {return}
			self.isRecording = true
		}
	}
	
	func stopRecording(){
		ShowTime.enabled = .never

		stopButton.isHidden = true
		annotateButton.isHidden = true
		recorder.stopRecording{[unowned self] (preview, error) in
			guard preview != nil else { return }
			preview?.previewControllerDelegate = self
			//			self.present(preview!, animated: true, completion: nil)
			self.isRecording = false
		}
	}
	
	@objc func startrecording() {
		//Use ReplayKit to record the screen
		
		//Create the file path to write to
		let documentsPath = NSSearchPathForDirectoriesInDomains(.documentDirectory, .userDomainMask, true)[0] as NSString
		self.videoOutputURL = URL(fileURLWithPath: documentsPath.appendingPathComponent("MyVideo.mp4"))
		
		//Check the file does not already exist by deleting it if it does
		do {
			try FileManager.default.removeItem(at: videoOutputURL!)
		} catch {}
		
		
		do {
			try videoWriter = AVAssetWriter(outputURL: videoOutputURL!, fileType: AVFileType.mp4)
		} catch let writerError as NSError {
			print("Error opening video file", writerError);
			videoWriter = nil;
			return;
		}
		
		//Create the video settings
		let videoSettings: [String : Any] = [
			AVVideoCodecKey  : AVVideoCodecType.h264,
			AVVideoWidthKey  : 1920,  //Replace as you need
			AVVideoHeightKey : 1080   //Replace as you need
		]
		
		//Create the asset writer input object whihc is actually used to write out the video
		//with the video settings we have created
		videoWriterInput = AVAssetWriterInput(mediaType: AVMediaType.video, outputSettings: videoSettings);
		videoWriter.add(videoWriterInput);
		
		//Tell the screen recorder to start capturing and to call the handler when it has a
		//sample
		RPScreenRecorder.shared().startCapture(handler: { (cmSampleBuffer, rpSampleType, error) in
			
			guard error == nil else {
				//Handle error
				print("Error starting capture");
				return;
			}
			
			switch rpSampleType {
				case RPSampleBufferType.video:
					print("writing sample....");
					if self.videoWriter.status == AVAssetWriter.Status.unknown {
						
						if (( self.videoWriter?.startWriting ) != nil) {
							print("Starting writing");
							self.videoWriter.startWriting()
							self.videoWriter.startSession(atSourceTime:  CMSampleBufferGetPresentationTimeStamp(cmSampleBuffer))
						}
					}
					
					if self.videoWriter.status == AVAssetWriter.Status.writing {
						if (self.videoWriterInput.isReadyForMoreMediaData == true) {
							print("Writting a sample");
							if  self.videoWriterInput.append(cmSampleBuffer) == false {
								print(" we have a problem writing video")
							}
						}
					}
					
				default:
					print("not a video sample, so ignore");
			}
		} )
	}
	
	@objc func stoprecording() {
		//Stop Recording the screen
		RPScreenRecorder.shared().stopCapture( handler: { (error) in
			print("stopping recording");
		})
		
		self.videoWriterInput.markAsFinished();
		self.videoWriter.finishWriting {
			print("finished writing video");
			
			//Now save the video
			PHPhotoLibrary.shared().performChanges({
				PHAssetChangeRequest.creationRequestForAssetFromVideo(atFileURL: self.videoOutputURL!)
			}) { saved, error in
				if saved {
					let alertController = UIAlertController(title: "Your video was successfully saved", message: nil, preferredStyle: .alert)
					let defaultAction = UIAlertAction(title: "OK", style: .default, handler: nil)
					alertController.addAction(defaultAction)
					self.present(alertController, animated: true, completion: nil)
				}
				if error != nil {
					print("Video did not save for some reason", error.debugDescription);
					debugPrint(error?.localizedDescription ?? "error is nil");
				}
			}
		}
	}
	
}


extension ViewController: RPPreviewViewControllerDelegate {
	
}

extension ViewController: WKScriptMessageHandler{
	func userContentController(_ userContentController: WKUserContentController, didReceive message: WKScriptMessage) {
		
		
		if (message.name == NativeBridge){
			guard let dict = message.body as? [String : String] else {
				return
			}
			
			print(dict)
			switch dict["callback"] {
				case "mobileInitCallback":
					let jsonEncoder = JSONEncoder()
					guard let jsonData = try? jsonEncoder.encode(qData) else {
						return
					}
					
					guard let json = String(data: jsonData, encoding: String.Encoding.utf8) else {return}
					webView.evaluateJavaScript("window.mobileInitCallback(\(json))", completionHandler: nil)
				case "questionnaireConsumerFinished":
					webView.removeFromSuperview()
				case "startRecording":
					startRecording()
					print("start recording")
				default:
					print("Awesome")
			}
		}
		
	}
}

