import { useSelector } from '@fashtag/common';
import { DisplayPosition, DisplayType, } from '@fashtag/common/dist/models';
import { Dialog } from '@material-ui/core';
import React, { useEffect, useState } from 'react';
import { Consumer } from './consumer/Consumer';
export const ConsumerDisplayWrapper = (props) => {
    const { onExit, isChatStyleEnabled, chatSettings, customCSSProps } = props;
    const displayConfig = useSelector((store) => store.consumerStore.displayConfig);
    const [isToggledOn, toggle] = useState(false);
    const [hasBeenClosedOnce, setHasBeenClosedOnce] = useState(false);
    useEffect(() => {
        if (displayConfig.displayType &&
            [DisplayType.BUBBLE, DisplayType.SIDE_TAB, DisplayType.DIALOG].includes(displayConfig.displayType)) {
            const displayAfterTime = displayConfig.displayAfterTime;
            const webScrollTillPercentage = displayConfig.webScrollTillPercentage;
            const webURLMatchesString = displayConfig.webURLMatchesString;
            if (!displayAfterTime &&
                !webScrollTillPercentage &&
                !webURLMatchesString &&
                displayConfig.displayType === DisplayType.DIALOG) {
                toggle(true);
                return;
            }
            if (!hasBeenClosedOnce &&
                !isToggledOn &&
                (displayAfterTime || webScrollTillPercentage || webURLMatchesString)) {
                if (displayAfterTime) {
                    setTimeout(() => {
                        if (!isToggledOn && !hasBeenClosedOnce)
                            toggle(true);
                    }, displayAfterTime * 1000);
                }
                if (webURLMatchesString) {
                    if (window.location.href.includes(webURLMatchesString) &&
                        !isToggledOn &&
                        !hasBeenClosedOnce) {
                        toggle(true);
                    }
                }
                if (webScrollTillPercentage) {
                    setInterval(() => {
                        const scrollPercentage = (window.scrollY * 100) / window.innerHeight;
                        if (scrollPercentage >= webScrollTillPercentage &&
                            !isToggledOn &&
                            !hasBeenClosedOnce) {
                            toggle(true);
                        }
                    }, 2000);
                }
            }
        }
    }, [
        displayConfig.displayAfterTime,
        displayConfig.displayType,
        displayConfig.webScrollTillPercentage,
        displayConfig.webURLMatchesString,
        hasBeenClosedOnce,
        isToggledOn,
    ]);
    if (displayConfig.displayType === DisplayType.FULL_SCREEN) {
        return (React.createElement("div", { style: { width: '100vw', height: '100vh' } },
            React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })));
    }
    else if (displayConfig.displayType === DisplayType.EMBED) {
        return (React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
    }
    else if (displayConfig.displayType === DisplayType.POPUP) {
        return (React.createElement("div", { style: {
                width: 320,
                height: 480,
                padding: 4,
                borderRadius: 8,
                position: 'absolute',
                boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
            } },
            React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })));
    }
    else if (displayConfig.displayType === DisplayType.BUBBLE) {
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { style: {
                    display: 'flex',
                    backgroundColor: 'rgb(4, 69, 175)',
                    cursor: 'pointer',
                    border: 0,
                    textDecoration: 'none',
                    outline: 'none',
                    position: 'fixed',
                    zIndex: 2147483003,
                    bottom: 20,
                    right: displayConfig.displayPosition === DisplayPosition.BOTTOM_RIGHT
                        ? 20
                        : 'unset',
                    left: displayConfig.displayPosition === DisplayPosition.BOTTOM_LEFT
                        ? 20
                        : 'unset',
                    width: 60,
                    height: 60,
                    borderRadius: '50%',
                    background: '#3047EC',
                    boxShadow: '0 1px 6px 0 rgb(0 0 0 / 6%), 0 2px 32px 0 rgb(0 0 0 / 16%)',
                    lineHeight: '60px',
                    justifyContent: 'center',
                    color: 'white',
                    fontSize: 36,
                }, onClick: () => {
                    if (isToggledOn) {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }
                    else {
                        toggle(true);
                    }
                } }, isToggledOn ? 'x' : '^'),
            isToggledOn && (React.createElement("div", { style: {
                    width: 320,
                    height: 640,
                    padding: 4,
                    borderRadius: 8,
                    position: 'fixed',
                    boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
                    zIndex: 2147483003,
                    bottom: 90,
                    right: displayConfig.displayPosition === DisplayPosition.BOTTOM_RIGHT
                        ? 20
                        : 'unset',
                    left: displayConfig.displayPosition === DisplayPosition.BOTTOM_LEFT
                        ? 20
                        : 'unset',
                } },
                React.createElement(Consumer, { onExit: () => {
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })))));
    }
    else if (displayConfig.displayType === DisplayType.SIDE_TAB) {
        return (React.createElement(React.Fragment, null,
            !isToggledOn && (React.createElement("div", { style: {
                    position: 'fixed',
                    top: '50%',
                    right: '-60px',
                    transform: 'rotate(-90deg) translateY(-50%)',
                    transformOrigin: 'center center',
                    height: '48px',
                    display: 'flex',
                    alignItems: 'center',
                    padding: '0 16px',
                    borderRadius: '8px 8px 0 0',
                    color: 'white',
                    boxShadow: '0 2px 4px rgb(0 0 0 / 8%), 0 2px 12px rgb(0 0 0 / 6%)',
                    backgroundColor: 'rgb(4, 69, 175)',
                    cursor: 'pointer',
                    border: 0,
                    textDecoration: 'none',
                    outline: 'none',
                }, onClick: () => toggle(true) }, "Start Survey")),
            isToggledOn && (React.createElement("div", { style: {
                    width: 320,
                    height: 480,
                    padding: 4,
                    top: '50%',
                    right: 0,
                    borderRadius: 8,
                    position: 'fixed',
                    boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
                    transform: 'translateY(-50%)',
                } },
                React.createElement(Consumer, { onExit: () => {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })))));
    }
    else if (displayConfig.displayType === DisplayType.DIALOG) {
        return (React.createElement(React.Fragment, null,
            React.createElement(Dialog, { fullWidth: true, maxWidth: "lg", open: isToggledOn, onClose: () => {
                    setHasBeenClosedOnce(true);
                    toggle(false);
                    onExit === null || onExit === void 0 ? void 0 : onExit();
                } },
                React.createElement(Consumer, { onExit: () => {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }))));
    }
    return (React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
};
//# sourceMappingURL=ConsumerDisplayWrapper.js.map