import { useSelector } from '@fashtag/common';
import { DisplayStyle, DistributionType, FlowType, SessionStatus, } from '@fashtag/common/dist/models';
import React, { useEffect } from 'react';
import { ConsumerMode } from '../models/ConsumerModels';
import { Consumer } from './consumer/Consumer';
import { ConsumerDisplayWrapper } from './ConsumerDisplayWrapper';
export const ConsumerWebSDK = (props) => {
    const { initData, onExit } = props;
    const { initiateConsumer, displayConfig } = useSelector((store) => {
        return {
            initiateConsumer: store.consumerStore.initiateConsumer,
            displayConfig: store.consumerStore.displayConfig,
        };
    });
    useEffect(() => {
        var _a, _b;
        initiateConsumer({
            mode: ConsumerMode.SDK_CONSUMER,
            initData: Object.assign(Object.assign({}, initData), { sessionStatus: SessionStatus.CREATED, distributionType: (_a = initData.distributionType) !== null && _a !== void 0 ? _a : DistributionType.WEB_EMBED, context: (_b = initData.context) !== null && _b !== void 0 ? _b : {}, allContentVarsValues: {}, flowType: FlowType.QUESTIONNAIRE, isDryRun: false }),
        });
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [initData]);
    if (!initData.questionnaireId &&
        (!initData.questionnaireTags || initData.questionnaireTags.length === 0)) {
        throw new Error('Either questionnaire id or tags is required');
    }
    if (initData.distributionType === DistributionType.WEB_EMBED) {
        return (React.createElement(ConsumerDisplayWrapper, { onExit: onExit, isChatStyleEnabled: displayConfig.displayStyle === DisplayStyle.CHAT, chatSettings: displayConfig.chatDistributionSettings }));
    }
    else
        return (React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: displayConfig.displayStyle === DisplayStyle.CHAT, chatSettings: displayConfig.chatDistributionSettings }));
};
//# sourceMappingURL=ConsumerWebSDK.js.map