import { useSelector } from '@fashtag/common';
import React, { useEffect } from 'react';
import { Consumer } from './consumer/Consumer';
export const ConsumerWrapper = (props) => {
    const { consumerData, onExit, isChatStyleEnabled, chatSettings, customCSSProps = { isEditorOpen: false }, } = props;
    const initiateConsumer = useSelector((store) => {
        return store.consumerStore.initiateConsumer;
    });
    useEffect(() => {
        initiateConsumer(consumerData);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [consumerData]);
    return (React.createElement(Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
};
//# sourceMappingURL=ConsumerWrapper.js.map