import React, { useEffect, useRef, } from 'react';
import { useSelector } from '@fashtag/common';
import { ConsumerState } from '../../models/ConsumerModels';
import { VariableSelector } from './VariableSelector';
import { Avatar, Button } from '@material-ui/core';
import { ConsumerNode } from './ConsumerNode';
import { MuiPickersUtilsProvider } from '@material-ui/pickers';
import DateFnsUtils from '@date-io/date-fns';
import { configure, GlobalHotKeys } from 'react-hotkeys';
const keyMap = {
    MOVE_UP: 'up',
    SELECT_OPTION: [...'abcdefghijklmnopqrtuvwxyzABCDEFGHIJKLMNOPQRTUVWXYZ'],
    ENTER: 'enter',
    BACK: 'up',
    FORWARD: 'down',
    SKIP: ['s', 'S'],
};
export const Consumer = (props) => {
    var _a;
    const { onExit, isChatStyleEnabled, chatSettings, customCSSProps = { isEditorOpen: false }, } = props;
    const prevConsumerState = useRef();
    const { consumerState, startConsumer, keyMapHandler, existingElements, existingElementsAnswer, customCSSFromQuestion, } = useSelector((store) => {
        const { consumerStore } = store;
        return {
            consumerState: consumerStore.consumerState,
            startConsumer: consumerStore.getFirstQuestion,
            keyMapHandler: consumerStore.keyMapHandler,
            existingElements: consumerStore.existingElements,
            existingElementsAnswer: consumerStore.existingElementsAnswer,
            customCSSFromQuestion: consumerStore.customCSS,
        };
    });
    const styleElementRef = useRef(null);
    // adds the style sheet when the component mounts and removes it when it unmounts
    useEffect(() => {
        const styleElement = document.createElement('style');
        // need to update @types/react to make sure useRef returns MutableRefObject instead of RefObject
        styleElementRef.current =
            styleElement;
        document.head.appendChild(styleElement);
        return () => {
            document.head.removeChild(styleElement);
        };
    }, []);
    // custom css applied will be added the style tag created above
    // during dry run, it will be sent from parent as props
    // (because the user might be editing css. This also adds scoping to make sure that other parts of UI are not affected)
    // during actual run, it should be picked from store
    const customCSSApplied = (_a = customCSSProps.customCSS) !== null && _a !== void 0 ? _a : customCSSFromQuestion;
    useEffect(() => {
        const styleElement = styleElementRef.current;
        if (!styleElement)
            return;
        while (styleElement.firstChild) {
            styleElement.removeChild(styleElement.firstChild);
        }
        styleElement.appendChild(document.createTextNode(customCSSApplied));
    }, [customCSSApplied]);
    const isCSSEditorOpenRef = useRef(customCSSProps.isEditorOpen);
    useEffect(() => {
        isCSSEditorOpenRef.current = customCSSProps.isEditorOpen;
    }, [customCSSProps.isEditorOpen]);
    useEffect(() => {
        configure({
            ignoreEventsCondition: (event) => {
                if (event.key && event.target) {
                    const tagName = event.target.tagName.toLowerCase();
                    if (tagName === 'select') {
                        return true;
                    }
                    else if (tagName === 'input' || tagName === 'textarea') {
                        if (event.key.toLowerCase() === 'enter' ||
                            event.key.toLowerCase() === 'arrowdown' ||
                            event.key.toLowerCase() === 'arrowup') {
                            return isCSSEditorOpenRef.current;
                        }
                        else {
                            return true;
                        }
                    }
                }
                return false;
            },
        });
    }, []);
    useEffect(() => {
        if (prevConsumerState.current !== undefined &&
            prevConsumerState.current !== ConsumerState.NOT_RUNNING &&
            consumerState === ConsumerState.NOT_RUNNING) {
            onExit === null || onExit === void 0 ? void 0 : onExit();
        }
        prevConsumerState.current = consumerState;
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [consumerState]);
    if (consumerState === ConsumerState.NOT_RUNNING) {
        return null;
    }
    return (React.createElement(MuiPickersUtilsProvider, { utils: DateFnsUtils },
        React.createElement("div", { className: 'flex flex-col items-stretch flex-grow h-full w-full' },
            consumerState === ConsumerState.VARIABLE_SELECTION && (React.createElement("div", { className: 'flex flex-col flex-grow items-center overflow-hidden gap-4 bg-white' },
                React.createElement(VariableSelector, null),
                React.createElement("div", { className: 'flex justify-center p-4' },
                    React.createElement(Button, { variant: 'contained', onClick: startConsumer }, "Start")))),
            consumerState === ConsumerState.RUNNING &&
                isChatStyleEnabled &&
                existingElements.map((element, index) => (React.createElement(React.Fragment, null,
                    React.createElement(ConsumerNode, { key: element.nodeId, exit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: element }),
                    React.createElement("div", { key: element.nodeId, className: 'flex flex-col flex-grow items-stretch min-h-0 max-w-screen-lg transform ' +
                            '-translate-x-1/2 left-1/2 bg-white relative' }, existingElementsAnswer[index] && (React.createElement("div", { style: {
                            display: 'flex',
                            flexDirection: 'row-reverse',
                            padding: 14,
                            alignItems: 'center',
                            gap: 4,
                            fontWeight: 500,
                        } },
                        React.createElement(Avatar, null),
                        existingElementsAnswer[index])))))),
            consumerState === ConsumerState.RUNNING && (React.createElement(GlobalHotKeys, { keyMap: keyMap, allowChanges: true, handlers: keyMapHandler },
                React.createElement(ConsumerNode, { exit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings }))))));
};
//# sourceMappingURL=Consumer.js.map