import { AudioRecordingData, ImageRecordingData, VideoRecordingData } from '@fashtag/common';
import { ChatDistributionSettings, OptionType, QuestionResponseDTO } from '@fashtag/common/dist/models';
import React from 'react';
export interface ConsumerHandlers {
    onSCQOptionChanged: (value: string) => void;
    onRatingChange: (rating: number) => void;
    toggleMCQOption: (value: number) => void;
    setMCQOptions: (indices: number[]) => void;
    onTextChange: (text: string) => void;
    onAudioRecordingChanged: (dat: AudioRecordingData | null) => void;
    onVideoRecordingChanged: (dat: VideoRecordingData | null) => void;
    onImageRecordingChanged: (dat: ImageRecordingData | null) => void;
    onDateChanged: (dat: Date | null) => void;
    onTimeChanged: (dat: Date | null) => void;
    onFileChanged: (dat: File | null) => void;
    onRankingOptionSwapped: (from: number, to: number) => void;
    setMatrixOptions: (rowIndex: string, value: number, optionType: OptionType) => void;
}
interface ConsumerNodeProps {
    exit?: () => void;
    isChatStyleEnabled?: boolean;
    chatSettings?: ChatDistributionSettings;
    questionResponse?: QuestionResponseDTO | null;
}
export declare const ConsumerNode: React.MemoExoticComponent<(props: ConsumerNodeProps) => JSX.Element>;
export {};
