import { __awaiter } from "tslib";
import { useSelector, } from '@fashtag/common';
import { NodeType, QualitativeType, QuestionType, } from '@fashtag/common/dist/models';
import { Button } from '@material-ui/core';
import React, { useCallback, useEffect, useState } from 'react';
import { ConsumerForm } from './ConsumerForm';
import { ConsumerQuestion } from './ConsumerQuestion';
import { StylingClasses } from '../../custom-classes-utils/classes';
// eslint-disable-next-line react/display-name
export const ConsumerNode = React.memo((props) => {
    const { isChatStyleEnabled, chatSettings, questionResponse } = props;
    const [isValid, setValid] = useState(true);
    const { formData, isSkippable, isLoading, nodeContent, nextQuestion, skipQuestion, closeConsumer, isBackAllowed, feedBackResponseDTO, navigateBack, navigateForward, sessionId, isForwardAllowed, updateKeyMap, skipInvalid, } = useSelector((store) => {
        var _a;
        const { consumerStore } = store;
        const { isQuestionLoading, error, nextQuestion, skipQuestion, closeConsumer, formData, navigateBack, navigateForward, updateKeyMap, } = consumerStore;
        const question = questionResponse !== null && questionResponse !== void 0 ? questionResponse : consumerStore.question;
        return {
            nodeContent: question === null || question === void 0 ? void 0 : question.nodeContent,
            isLoading: isQuestionLoading,
            nextQuestion,
            skipQuestion,
            closeConsumer,
            error: error,
            formData: formData,
            isSkippable: (question === null || question === void 0 ? void 0 : question.isSkippable) || false,
            isBackAllowed: (question === null || question === void 0 ? void 0 : question.isBackAllowed) || false,
            isForwardAllowed: (question === null || question === void 0 ? void 0 : question.isForwardAllowed) || false,
            feedBackResponseDTO: question === null || question === void 0 ? void 0 : question.feedBackResponseDTO,
            sessionId: question === null || question === void 0 ? void 0 : question.sessionId,
            navigateBack: navigateBack,
            navigateForward: navigateForward,
            updateKeyMap,
            skipInvalid: ((_a = question === null || question === void 0 ? void 0 : question.nodeContent) === null || _a === void 0 ? void 0 : _a.nodeType) === NodeType.QUESTION &&
                question.nodeContent.questionType === QuestionType.TEXT &&
                !(question.nodeContent.qualitativeType === QualitativeType.UPLOAD),
        };
    });
    const handlers = useSelector((store) => {
        return {
            onAudioRecordingChanged: store.consumerStore.onAudioRecordingChanged,
            onDateChanged: store.consumerStore.onDateChanged,
            onImageRecordingChanged: store.consumerStore.onImageRecordingChanged,
            onRatingChange: store.consumerStore.onRatingChange,
            onSCQOptionChanged: store.consumerStore.onSCQOptionChanged,
            onTextChange: store.consumerStore.onTextChange,
            onTimeChanged: store.consumerStore.onTimeChanged,
            onVideoRecordingChanged: store.consumerStore.onVideoRecordingChanged,
            toggleMCQOption: store.consumerStore.toggleMCQOption,
            setMCQOptions: store.consumerStore.setMCQOptions,
            onFileChanged: store.consumerStore.onFileChanged,
            onRankingOptionSwapped: store.consumerStore.onRankingOptionSwapped,
            setMatrixOptions: store.consumerStore.setMatrixOptions,
        };
    });
    function onCloseConsumer() {
        closeConsumer();
    }
    const onNextQuestion = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        nextQuestion();
    }), [nextQuestion]);
    const onSkipQuestion = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        skipQuestion();
    }), [skipQuestion]);
    const formHandlers = useSelector((store) => {
        return {
            onFormQuestionsChange: store.consumerStore.onFormQuestionsChange,
            initializeFormQuestions: store.consumerStore.initializeFormQuestions,
        };
    });
    useEffect(() => {
        updateKeyMap({
            ENTER: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isValid) {
                    onNextQuestion();
                }
            },
            SKIP: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isSkippable && !skipInvalid) {
                    onSkipQuestion();
                }
            },
        });
    }, [
        isSkippable,
        isValid,
        onNextQuestion,
        onSkipQuestion,
        skipInvalid,
        updateKeyMap,
    ]);
    return (React.createElement("div", { className: 'flex flex-col flex-grow items-stretch min-h-0 max-w-screen-lg transform ' +
            '-translate-x-1/2 left-1/2 bg-white relative', style: {
            pointerEvents: questionResponse ? 'none' : 'unset',
            flexShrink: 0,
        } },
        React.createElement("div", { className: 'overflow-x-hidden overflow-y-auto flex-grow min-h-0 p-4', style: { height: '-webkit-fill-available' } },
            isLoading && React.createElement("span", null, "Loading..."),
            !isLoading &&
                nodeContent &&
                nodeContent.nodeType !== NodeType.FORM && (React.createElement(ConsumerQuestion, { isMandatory: !isSkippable, nodeContent: nodeContent, formData: formData, handlers: handlers, setValid: setValid, onNextQuestion: onNextQuestion, isLoading: isLoading, isBackAllowed: isBackAllowed, isForwardAllowed: isForwardAllowed, feedBackResponseDTO: feedBackResponseDTO, navigateBack: navigateBack, navigateForward: navigateForward, sessionId: sessionId, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: questionResponse })),
            !isLoading &&
                nodeContent &&
                nodeContent.nodeType === NodeType.FORM && (React.createElement(ConsumerForm, { nodeContent: nodeContent, formData: formData, onFormQuestionsChange: formHandlers.onFormQuestionsChange, initializeFormQuestions: formHandlers.initializeFormQuestions, setValid: setValid, isBackAllowed: isBackAllowed, isForwardAllowed: isForwardAllowed, feedBackResponseDTO: feedBackResponseDTO, navigateBack: navigateBack, navigateForward: navigateForward, sessionId: sessionId, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: questionResponse }))),
        React.createElement("div", { className: 'flex justify-center gap-4 p-4' },
            isSkippable && !questionResponse && (React.createElement(React.Fragment, null,
                React.createElement(Button, { classes: {
                        label: 'normal-case',
                        root: [
                            StylingClasses.general.btn,
                            StylingClasses.general.skipBtn,
                        ].join(' '),
                    }, variant: 'contained', onClick: onSkipQuestion, disabled: isLoading }, "Skip"),
                !isLoading && !skipInvalid && (React.createElement("div", { style: { marginTop: 4, fontWeight: 'normal', fontSize: 10 } }, "press S")))),
            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== NodeType.THANKS &&
                (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== NodeType.WELCOME &&
                !questionResponse && (React.createElement(React.Fragment, null,
                React.createElement(Button, { classes: {
                        label: 'normal-case',
                        root: [
                            StylingClasses.general.btn,
                            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) === NodeType.FORM
                                ? `${StylingClasses.form.formButton} ${StylingClasses.general.submitBtn}`
                                : StylingClasses.general.submitBtn,
                        ].join(' '),
                    }, variant: 'contained', onClick: onNextQuestion, disabled: isLoading || !isValid }, (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) === NodeType.FORM
                    ? nodeContent.actionText
                    : 'Submit'),
                !isLoading && isValid && (React.createElement("div", { style: { marginTop: 4, fontWeight: 'normal', fontSize: 10 } }, "press Enter \u21B5")))),
            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== NodeType.THANKS && !isChatStyleEnabled && (React.createElement(Button, { classes: {
                    label: 'normal-case',
                    root: [
                        StylingClasses.general.btn,
                        StylingClasses.general.exitBtn,
                    ].join(' '),
                }, variant: 'contained', onClick: onCloseConsumer, disabled: isLoading }, "Exit")))));
});
//# sourceMappingURL=ConsumerNode.js.map