import { useSelector } from '@fashtag/common';
import { VALID_EMAIL_REGEX, VALID_PHONE_REGEX, VALID_URL_REGEX, } from '@fashtag/common/dist/constants';
import { AllowedResponseType, NodeType, OptionType, QualitativeType, QuestionType, } from '@fashtag/common/dist/models';
import { Avatar, Button } from '@material-ui/core';
import { ArrowBackIos } from '@material-ui/icons';
import { toJS } from 'mobx';
import { Observer, useObserver } from 'mobx-react';
import React, { useEffect, useState } from 'react';
import { isResponseTypeAllowed } from '../../utils/consumerUtils';
import { ConsumerRatingQuestion } from './ConsumerRatingQuestion';
import { ConsumerSignatureQuestion } from './ConsumerSignatureQuestion';
import { ConsumerTextQuestion } from './ConsumerTextQuestion';
import { ConsumerUXQuestion } from './ConsumerUXQuestion';
import { getConsumerMCQOptions } from './getConsumerMCQOptions';
import { getConsumerRankingOptions } from './getConsumerRankingOptions';
import { getConsumerSCQOptions } from './getConsumerSCQOptions';
import { MatrixOptions } from './MatrixOptions';
import { getSubstitutedTextAndImage } from './utils';
import { getClassnamesForContent, getClassnamesForDescription, getClassnamesForWelThxBtn, } from '../../custom-classes-utils/classNameUtils';
import { StylingClasses } from '../../custom-classes-utils/classes';
export function ConsumerQuestion(props) {
    const { nodeContent, handlers, formItemData, setValid, isMandatory, formData, onNextQuestion, isLoading, isBackAllowed, isForwardAllowed, feedBackResponseDTO, navigateBack, navigateForward, sessionId, isChatStyleEnabled, chatSettings, questionResponse, } = props;
    const { onSCQOptionChanged, onRatingChange, toggleMCQOption, setMCQOptions, onRankingOptionSwapped, setMatrixOptions, } = handlers;
    const isForm = !onNextQuestion;
    const [openRowIndex, setOpenRowIndex] = useState(nodeContent.nodeType === NodeType.QUESTION &&
        nodeContent.questionType === QuestionType.MATRIX
        ? 0
        : null);
    const contentVarValues = useSelector((store) => {
        var _a, _b;
        return (_b = (_a = store.consumerStore.question) === null || _a === void 0 ? void 0 : _a.contentVarValues) !== null && _b !== void 0 ? _b : {};
    });
    const updateKeyMap = useSelector((store) => {
        return store.consumerStore.updateKeyMap;
    });
    const variables = useSelector((store) => {
        var _a, _b;
        return toJS((_b = (_a = store.consumerStore.questionnaireResponse.data) === null || _a === void 0 ? void 0 : _a.questionnare.variables) !== null && _b !== void 0 ? _b : []);
    });
    const isValid = useObserver(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
        if (nodeContent.nodeType === NodeType.QUESTION) {
            if (nodeContent.questionType === QuestionType.OPTIONS) {
                if (nodeContent.optionType === OptionType.SINGLE) {
                    return nodeContent.options
                        .map((it) => parseInt(it.index))
                        .includes(formData.scqOption);
                }
                else if (nodeContent.optionType === OptionType.MULTIPLE) {
                    let isValid = true;
                    if (nodeContent.minSelectionsAllowed) {
                        isValid =
                            formData.mcqOptions.length >= nodeContent.minSelectionsAllowed;
                    }
                    if (nodeContent.maxSelectionsAllowed) {
                        isValid =
                            isValid &&
                                formData.mcqOptions.length <= nodeContent.maxSelectionsAllowed;
                    }
                    return formData.mcqOptions.length > 0 && isValid;
                }
                else {
                    return true;
                }
            }
            if (nodeContent.questionType === QuestionType.MATRIX) {
                if (nodeContent.optionType === OptionType.SINGLE) {
                    return (nodeContent.rows.length ===
                        Object.keys(formData.matrixOptions).length &&
                        Object.values(formData.matrixOptions).every((item) => !!item));
                }
                else if (nodeContent.optionType === OptionType.MULTIPLE) {
                    return (nodeContent.rows.length ===
                        Object.keys(formData.matrixOptions).length &&
                        Object.values(formData.matrixOptions).every((item) => !!item && item.length > 0));
                }
                else {
                    return true;
                }
            }
            if (nodeContent.questionType === QuestionType.SIGNATURE) {
                if (((_a = formData.imageRecordingData) === null || _a === void 0 ? void 0 : _a.imageDataURL) ||
                    formData.fileUpload ||
                    formData.text) {
                    return true;
                }
                else {
                    return false;
                }
            }
            if (nodeContent.questionType === QuestionType.UX) {
                if (((_b = formData.imageRecordingData) === null || _b === void 0 ? void 0 : _b.imageDataURL) || ((_c = formData.videoRecordingData) === null || _c === void 0 ? void 0 : _c.videoUrl)) {
                    return true;
                }
                else {
                    return false;
                }
            }
            if (nodeContent.questionType === QuestionType.TEXT) {
                if (nodeContent.qualitativeType === QualitativeType.UPLOAD) {
                    if (formData.fileUpload) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
                if (nodeContent.qualitativeType === QualitativeType.NUMERIC &&
                    ((_d = nodeContent.noOfDigits) !== null && _d !== void 0 ? _d : 0) > 0) {
                    return nodeContent.noOfDigits === formData.text.length;
                }
                let isValid = false;
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.TEXT_RESPONSE)) {
                    if (formData.text) {
                        isValid = true;
                    }
                    switch (nodeContent.qualitativeType) {
                        case QualitativeType.EMAIL:
                            isValid = VALID_EMAIL_REGEX.test(formData.text.toLowerCase());
                            break;
                        case QualitativeType.PHONE:
                            isValid = VALID_PHONE_REGEX.test(formData.text.toLowerCase());
                            break;
                        case QualitativeType.URL:
                            isValid = VALID_URL_REGEX.test(formData.text.toLowerCase());
                            break;
                        default:
                            break;
                    }
                }
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.AUDIO_RESPONSE)) {
                    if (((_e = formData.audioRecordingData) === null || _e === void 0 ? void 0 : _e.audioBlob) || ((_f = formData.audioRecordingData) === null || _f === void 0 ? void 0 : _f.audioUrl)) {
                        isValid = true;
                    }
                }
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.VIDEO_RESPONSE)) {
                    if (((_g = formData.videoRecordingData) === null || _g === void 0 ? void 0 : _g.videoBlob) || ((_h = formData.videoRecordingData) === null || _h === void 0 ? void 0 : _h.videoUrl)) {
                        isValid = true;
                    }
                }
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.IMAGE_RESPONSE)) {
                    if (((_j = formData.imageRecordingData) === null || _j === void 0 ? void 0 : _j.imageBlob) || ((_k = formData.imageRecordingData) === null || _k === void 0 ? void 0 : _k.imageUrl)) {
                        isValid = true;
                    }
                }
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.DATE_RESPONSE)) {
                    if (formData.date) {
                        isValid = true;
                    }
                }
                if (isResponseTypeAllowed(nodeContent, AllowedResponseType.TIME_RESPONSE)) {
                    if (formData.time) {
                        isValid = true;
                    }
                }
                return isValid;
            }
            if (nodeContent.questionType === QuestionType.RATING) {
                return (formData.rating >= nodeContent.minRating &&
                    formData.rating <= nodeContent.maxRating);
            }
        }
        return true;
        // eslint-disable-next-line react-hooks/exhaustive-deps
    });
    useEffect(() => {
        if (!isForm) {
            updateKeyMap({
                BACK: (event) => {
                    if ((event === null || event === void 0 ? void 0 : event.key) && isBackAllowed) {
                        navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                    }
                },
                FORWARD: (event) => {
                    if ((event === null || event === void 0 ? void 0 : event.key) && isForwardAllowed) {
                        navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                    }
                },
            });
        }
    }, [
        isBackAllowed,
        isForm,
        isForwardAllowed,
        navigateBack,
        navigateForward,
        onNextQuestion,
        sessionId,
        updateKeyMap,
    ]);
    useEffect(() => {
        setValid(isValid);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [isValid]);
    const { text: substitutedText, imageUrl, videoUrl, } = getSubstitutedTextAndImage(nodeContent, contentVarValues, variables);
    return (React.createElement(Observer, null, () => {
        var _a, _b;
        return (React.createElement("div", { className: `flex flex-col items-stretch gap-4 ${formItemData ? StylingClasses.form.formItem : ''}`, style: { maxWidth: '80%' } },
            nodeContent.nodeType !== NodeType.QUESTIONNARE &&
                nodeContent.nodeType !== NodeType.ACTION &&
                nodeContent.nodeType !== NodeType.FORM &&
                (nodeContent.nodeType !== NodeType.QUESTION ||
                    nodeContent.questionType !== QuestionType.TEXT ||
                    !isResponseTypeAllowed(nodeContent, AllowedResponseType.TEXT_RESPONSE) ||
                    !(formItemData === null || formItemData === void 0 ? void 0 : formItemData.keepQuestionAsPlaceholder)) && (React.createElement("div", { className: 'font-bold', style: { display: 'flex' } },
                !isForm && isBackAllowed && !isChatStyleEnabled && (React.createElement(React.Fragment, null,
                    React.createElement(ArrowBackIos, { onClick: () => navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : ''), className: StylingClasses.general.back }),
                    React.createElement("span", { style: {
                            marginTop: 4,
                            marginLeft: -2,
                            fontWeight: 'normal',
                            fontSize: 10,
                        } }, "press Top \u2191"))),
                ' ',
                isChatStyleEnabled && (React.createElement("span", { style: { marginRight: 4 } }, (chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) ? (React.createElement("img", { src: (_a = chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) !== null && _a !== void 0 ? _a : '' })) : (React.createElement(Avatar, null)))),
                React.createElement("div", { style: {
                        backgroundColor: isChatStyleEnabled ? '#1982FC' : 'unset',
                        padding: isChatStyleEnabled ? 8 : 'unset',
                        borderRadius: 24,
                        borderBottomLeftRadius: 4,
                    }, className: getClassnamesForContent(nodeContent) },
                    substitutedText,
                    ' ',
                    isMandatory &&
                        nodeContent.nodeType !== NodeType.STATEMENT &&
                        nodeContent.nodeType !== NodeType.WELCOME &&
                        nodeContent.nodeType !== NodeType.THANKS &&
                        '*'),
                !isForm && isForwardAllowed && !isChatStyleEnabled && (React.createElement(React.Fragment, null,
                    React.createElement(ArrowBackIos, { onClick: () => navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : ''), style: { transform: 'rotate(180deg)' }, className: StylingClasses.general.forward }),
                    React.createElement("span", { style: {
                            marginTop: 4,
                            marginLeft: 2,
                            fontWeight: 'normal',
                            fontSize: 10,
                        } }, "press Down \u2193"))),
                ' ')),
            (nodeContent.nodeType === NodeType.WELCOME ||
                nodeContent.nodeType === NodeType.THANKS ||
                (nodeContent.nodeType === NodeType.QUESTION &&
                    (nodeContent.questionType === QuestionType.SIGNATURE ||
                        nodeContent.questionType === QuestionType.UX))) &&
                nodeContent.description && (React.createElement("div", { style: { fontSize: 14, color: '#777' }, className: getClassnamesForDescription(nodeContent) }, nodeContent.description)),
            imageUrl && React.createElement("img", { src: imageUrl, alt: 'question' }),
            videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true },
                React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")),
            (nodeContent.nodeType === NodeType.WELCOME ||
                nodeContent.nodeType === NodeType.THANKS) &&
                !questionResponse && (React.createElement("div", { style: {
                    display: 'flex',
                    alignSelf: isChatStyleEnabled ? 'flex-start' : 'center',
                } },
                React.createElement(Button, { classes: {
                        label: 'normal-case',
                        root: getClassnamesForWelThxBtn(nodeContent),
                    }, variant: 'contained', onClick: onNextQuestion, disabled: isLoading }, (_b = nodeContent.buttonLabel) !== null && _b !== void 0 ? _b : 'OK'),
                !isLoading && isValid && (React.createElement("div", { style: {
                        marginTop: 4,
                        marginLeft: 8,
                        fontWeight: 'normal',
                        fontSize: 10,
                    } }, "press Enter \u21B5")))),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.OPTIONS &&
                nodeContent.optionType === OptionType.SINGLE &&
                getConsumerSCQOptions(nodeContent, formData, onSCQOptionChanged, contentVarValues, variables, isForm, updateKeyMap),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.OPTIONS &&
                nodeContent.optionType === OptionType.MULTIPLE &&
                getConsumerMCQOptions(nodeContent, formData, toggleMCQOption, setMCQOptions, contentVarValues, variables, isForm, updateKeyMap),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.OPTIONS &&
                nodeContent.optionType === OptionType.RANKING &&
                getConsumerRankingOptions(nodeContent, formData, onRankingOptionSwapped, contentVarValues, variables, isForm),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.MATRIX &&
                MatrixOptions(nodeContent, formData, setMatrixOptions, contentVarValues, variables, openRowIndex, setOpenRowIndex),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.TEXT &&
                !questionResponse && (React.createElement(ConsumerTextQuestion, { formData: formData, formItemData: formItemData, nodeContent: nodeContent, isMandatory: isMandatory, handlers: handlers })),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.RATING && (React.createElement(ConsumerRatingQuestion, { formData: formData, nodeContent: nodeContent, onRatingChange: onRatingChange, isForm: isForm, updateKeyMap: updateKeyMap })),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.SIGNATURE && (React.createElement(ConsumerSignatureQuestion, { formData: formData, nodeContent: nodeContent, handlers: handlers })),
            nodeContent.nodeType === NodeType.QUESTION &&
                nodeContent.questionType === QuestionType.UX && (React.createElement(ConsumerUXQuestion, { formData: formData, nodeContent: nodeContent, handlers: handlers }))));
    }));
}
//# sourceMappingURL=ConsumerQuestion.js.map