import { RatingDisplayType, } from '@fashtag/common/dist/models';
import { OfflineBoltOutlined, OfflineBoltTwoTone, SentimentDissatisfied, SentimentDissatisfiedTwoTone, SentimentSatisfied, SentimentSatisfiedAlt, SentimentSatisfiedAltTwoTone, SentimentSatisfiedTwoTone, SentimentVeryDissatisfied, SentimentVeryDissatisfiedTwoTone, SentimentVerySatisfied, SentimentVerySatisfiedOutlined, SentimentVerySatisfiedTwoTone, StarBorder, StarOutlined, ThumbUpOutlined, ThumbUpTwoTone, } from '@material-ui/icons';
import React, { useCallback, useMemo } from 'react';
import { getClassnamesForOption } from '../../custom-classes-utils/classNameUtils';
export function ConsumerRatingQuestion(props) {
    const { formData, nodeContent, onRatingChange, isForm, updateKeyMap } = props;
    const steps = useMemo(() => {
        let rating = nodeContent.minRating;
        const steps = [];
        while (rating <= nodeContent.maxRating) {
            steps.push(rating);
            rating += nodeContent.stepSize;
        }
        return steps;
    }, [nodeContent]);
    const indexKeyboardShortcutBiMap = {};
    steps.forEach((option, index) => {
        const shortCut = index <= 26 && !isForm ? String.fromCharCode(65 + index) : '';
        indexKeyboardShortcutBiMap[option] = shortCut;
        indexKeyboardShortcutBiMap[shortCut] = option.toString();
        indexKeyboardShortcutBiMap[shortCut.toLowerCase()] = option.toString();
    });
    updateKeyMap({
        SELECT_OPTION: (event) => {
            if ((event === null || event === void 0 ? void 0 : event.key) && indexKeyboardShortcutBiMap[event.key]) {
                onRatingChange(parseInt(indexKeyboardShortcutBiMap[event.key]));
            }
        },
    });
    const optionClassName = getClassnamesForOption(nodeContent);
    const getRatingJSX = useCallback((step) => {
        switch (nodeContent.ratingDisplayType) {
            case RatingDisplayType.NUMERIC:
                return (React.createElement("span", { className: `${formData.rating === step
                        ? 'text-white bg-gray-600'
                        : 'text-black'} flex flex-col items-center justify-center border border-gray-600 rounded-md cursor-pointer ${optionClassName}`, style: {
                        width: 40,
                        height: 40,
                    }, onClick: () => onRatingChange(step) }, step));
            case RatingDisplayType.STARS:
                return formData.rating > -1 && formData.rating >= step ? (React.createElement(StarOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (React.createElement(StarBorder, { fontSize: "large", onClick: () => onRatingChange(step) }));
            case RatingDisplayType.LIGHTNING:
                return formData.rating > -1 && formData.rating >= step ? (React.createElement(OfflineBoltTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (React.createElement(OfflineBoltOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
            case RatingDisplayType.THUMBS_UP:
                return formData.rating > -1 && formData.rating >= step ? (React.createElement(ThumbUpTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (React.createElement(ThumbUpOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
            case RatingDisplayType.PEOPLE:
                if (formData.rating > -1 && formData.rating === step) {
                    switch (step) {
                        case 1:
                            return (React.createElement(SentimentVeryDissatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 2:
                            return (React.createElement(SentimentDissatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 3:
                            return (React.createElement(SentimentSatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 4:
                            return (React.createElement(SentimentSatisfiedAltTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 5:
                            return (React.createElement(SentimentVerySatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        default:
                            return (React.createElement(SentimentVerySatisfiedOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                    }
                }
                else {
                    switch (step) {
                        case 1:
                            return (React.createElement(SentimentVeryDissatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 2:
                            return (React.createElement(SentimentDissatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 3:
                            return (React.createElement(SentimentSatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 4:
                            return (React.createElement(SentimentSatisfiedAlt, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 5:
                            return (React.createElement(SentimentVerySatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        default:
                            return (React.createElement(SentimentVerySatisfiedOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                    }
                }
            default:
                return React.createElement(React.Fragment, null);
        }
    }, [
        formData.rating,
        nodeContent.ratingDisplayType,
        onRatingChange,
        optionClassName,
    ]);
    return (React.createElement("div", { className: "flex gap-4 flex-wrap", style: { alignItems: 'flex-end' } }, steps.map((step, index) => (React.createElement("div", { key: step },
        nodeContent.leftLabel && index === 0 && (React.createElement("div", null, nodeContent.leftLabel)),
        nodeContent.rightLabel && index === steps.length - 1 && (React.createElement("div", { style: { textAlign: 'end' } }, nodeContent.rightLabel)),
        getRatingJSX(step),
        indexKeyboardShortcutBiMap[step] && (React.createElement("div", { style: {
                paddingLeft: 4,
                paddingRight: 4,
                margin: 4,
                border: 'solid 2px black',
                borderRadius: 2,
                backgroundColor: 'rgb(119, 150, 254)',
                fontWeight: 500,
                height: 22,
            } }, indexKeyboardShortcutBiMap[step])))))));
}
//# sourceMappingURL=ConsumerRatingQuestion.js.map