import { SignatureAllowedResponseType, } from '@fashtag/common/dist/models';
import { Button, makeStyles, MenuItem, Select } from '@material-ui/core';
import { Cancel } from '@material-ui/icons';
import { useObserver } from 'mobx-react';
import React, { useState } from 'react';
// eslint-disable-next-line
// @ts-ignore
import { SketchField, Tools } from '@mayrestinpeace/react-sketch';
import './signature.css';
import { StylingClasses } from '../../custom-classes-utils/classes';
var FontFamily;
(function (FontFamily) {
    FontFamily["GREAT_VIBES"] = "Great Vibes";
    FontFamily["PARISIENNE"] = "Parisienne";
    FontFamily["SATISFY"] = "Satisfy";
    FontFamily["YELLOWTAIL"] = "Yellowtail";
})(FontFamily || (FontFamily = {}));
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export function ConsumerSignatureQuestion(props) {
    const classes = useClasses();
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let sketchRef = null;
    const [selectedFontFamily, setSelectedFontFamily] = useState(FontFamily.SATISFY);
    const { formData, nodeContent, handlers } = props;
    const [selectedResponseType, setSelectedResponseType] = useState(nodeContent.signatureAllowedResponseTypes[0]);
    const { fileUpload, imageRecordingData, text } = useObserver(() => {
        return Object.assign({}, formData);
    });
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    function onFileChanged(file) {
        handlers.onFileChanged(file);
    }
    return (React.createElement("div", { className: "flex gap-4 flex-wrap", style: { alignItems: 'flex-end' } },
        React.createElement("div", { style: {
                borderRadius: 12,
                width: 504,
                height: 240,
                maxWidth: '100%',
                backgroundColor: '#00000050',
            } },
            React.createElement("div", { style: { display: 'flex', justifyContent: 'center' } }, nodeContent.signatureAllowedResponseTypes.map((item) => (React.createElement("div", { key: item, onClick: () => {
                    onImageRecordingChanged({});
                    handlers.onTextChange('');
                    onFileChanged(null);
                    setSelectedResponseType(item);
                }, style: {
                    padding: 4,
                    cursor: 'pointer',
                    fontWeight: item === selectedResponseType ? 500 : 'inherit',
                    textDecoration: item === selectedResponseType ? 'underline' : 'none',
                } }, item)))),
            selectedResponseType === SignatureAllowedResponseType.DRAW && (React.createElement("div", { className: StylingClasses.signature.signatureDraw },
                React.createElement(SketchField, { tool: Tools.Pencil, lineColor: "black", lineWidth: 3, 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    ref: (c) => (sketchRef = c), 
                    // backgroundColor="#00000050"
                    height: 240, forceValue: true, onChange: () => onImageRecordingChanged({ imageDataURL: sketchRef.toDataURL() }) }),
                React.createElement(Button, { variant: "contained", className: StylingClasses.signature.signatureClearBtn, onClick: () => {
                        sketchRef.clear();
                        onImageRecordingChanged({});
                    } }, "Clear"))),
            selectedResponseType === SignatureAllowedResponseType.TYPE && (React.createElement("div", { className: StylingClasses.signature.signatureType },
                React.createElement(Select, { value: selectedFontFamily, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => setSelectedFontFamily(event.target.value) },
                    React.createElement(MenuItem, { value: FontFamily.SATISFY }, FontFamily.SATISFY),
                    React.createElement(MenuItem, { value: FontFamily.PARISIENNE }, FontFamily.PARISIENNE),
                    React.createElement(MenuItem, { value: FontFamily.GREAT_VIBES }, FontFamily.GREAT_VIBES),
                    React.createElement(MenuItem, { value: FontFamily.YELLOWTAIL }, FontFamily.YELLOWTAIL)),
                React.createElement("input", { type: "text", placeholder: "Type Here", value: text, style: {
                        outline: 'none',
                        width: '100%',
                        background: 'transparent',
                        border: 'none',
                        borderBottom: '1px solid black',
                        padding: 16,
                        textAlign: 'center',
                        fontSize: 32,
                        fontWeight: 400,
                        fontFamily: `'${selectedFontFamily}', cursive`,
                    }, onChange: (event) => handlers.onTextChange(event.target.value) }))),
            selectedResponseType === SignatureAllowedResponseType.UPLOAD && (React.createElement("div", { className: StylingClasses.signature.signatureUpload }, fileUpload ? (React.createElement(React.Fragment, null,
                React.createElement(Cancel, { onClick: () => onFileChanged(null) }),
                fileUpload.name)) : (React.createElement("input", { type: "file", autoComplete: "off", onChange: (event) => {
                    if (event.target &&
                        event.target.files &&
                        event.target.files.length > 0) {
                        onFileChanged(event.target.files[0]);
                    }
                } })))))));
}
//# sourceMappingURL=ConsumerSignatureQuestion.js.map