import { AudioRecorderComponent, ImageRecorderComponent, VideoRecorderComponent, } from '@fashtag/common';
import { AllowedResponseType, QualitativeType, TextResponseType, } from '@fashtag/common/dist/models';
import { makeStyles, TextField } from '@material-ui/core';
import { Cancel, Close } from '@material-ui/icons';
import { DatePicker, TimePicker } from '@material-ui/pickers';
import { useObserver } from 'mobx-react';
import React, { useCallback } from 'react';
// eslint-disable-next-line
// @ts-ignore
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';
import { getContent } from '../../utils/consumerUtils';
import './main.css';
import { StylingClasses } from '../../custom-classes-utils/classes';
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export function ConsumerTextQuestion(props) {
    var _a;
    const classes = useClasses();
    const { formData, formItemData, nodeContent, handlers, isMandatory } = props;
    const { audioRecordingData, videoRecordingData, imageRecordingData, date, time, } = useObserver(() => {
        return Object.assign({}, formData);
    });
    function onAudioRecordingChanged(data) {
        handlers.onAudioRecordingChanged(data);
    }
    function onVideoRecordingChanged(data) {
        handlers.onVideoRecordingChanged(data);
    }
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    function onDateChanged(date) {
        handlers.onDateChanged(date);
    }
    function onTimeChanged(time) {
        handlers.onTimeChanged(time);
    }
    function onFileChanged(file) {
        handlers.onFileChanged(file);
    }
    const getInputType = useCallback(() => {
        switch (nodeContent.qualitativeType) {
            case QualitativeType.EMAIL:
                return 'email';
            case QualitativeType.NUMERIC:
                return 'number';
            default:
                return 'text';
        }
    }, [nodeContent.qualitativeType]);
    if (nodeContent.qualitativeType === QualitativeType.UPLOAD) {
        return (React.createElement("div", { className: 'flex flex-col gap-4' },
            React.createElement("div", { style: {
                    border: '#EDEDED solid 1px',
                    padding: 8,
                    width: 320,
                    height: 120,
                    display: 'flex',
                    alignItems: 'center',
                } }, formData.fileUpload ? (React.createElement("div", { className: StylingClasses.upload.uploadedFile },
                React.createElement(Cancel, { onClick: () => onFileChanged(null) }),
                formData.fileUpload.name)) : (React.createElement("input", { type: "file", autoComplete: "off", className: StylingClasses.upload.uploadFile, onChange: (event) => {
                    if (event.target &&
                        event.target.files &&
                        event.target.files.length > 0) {
                        onFileChanged(event.target.files[0]);
                    }
                } })))));
    }
    else
        return (React.createElement("div", { className: 'flex flex-col gap-4' },
            nodeContent.qualitativeType === QualitativeType.NUMERIC &&
                ((_a = nodeContent.noOfDigits) !== null && _a !== void 0 ? _a : 0) > 0 && (React.createElement("div", { style: { fontSize: 14, color: '#777' } }, `Please enter your ${nodeContent.noOfDigits} digit response`)),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.TEXT_RESPONSE) &&
                nodeContent.qualitativeType !== QualitativeType.PHONE && (React.createElement(TextField, { autoFocus: true, type: getInputType(), multiline: nodeContent.qualitativeType === QualitativeType.NORMAL &&
                    nodeContent.textResponseType === TextResponseType.MULTI_LINE, className: `${StylingClasses.qualitative.textResponse} ${StylingClasses.question.response}`, variant: 'outlined', value: formData.text, placeholder: (formItemData === null || formItemData === void 0 ? void 0 : formItemData.keepQuestionAsPlaceholder) ? getContent(nodeContent) + (isMandatory ? ' *' : '')
                    : undefined, onChange: (event) => handlers.onTextChange(event.target.value) })),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.TEXT_RESPONSE) &&
                nodeContent.qualitativeType === QualitativeType.PHONE && (React.createElement(IntlTelInput, { autoFocus: true, preferredCountries: ['in'], className: `${StylingClasses.qualitative.textResponse} ${StylingClasses.question.response}`, customPlaceholder: () => 'Enter your number', containerClassName: "intl-tel-input", inputClassName: "form-control", separateDialCode: true, onPhoneNumberChange: (isValid, newNumber) => {
                    handlers.onTextChange(newNumber);
                }, formatOnInit: false, value: formData.text, style: {
                    width: 320,
                    color: '#000',
                    borderRadius: 4,
                    border: 'thin solid #ededed',
                    padding: '0 12px',
                } })),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.AUDIO_RESPONSE) && (React.createElement("div", { className: `self-start ${StylingClasses.qualitative.audioResponse}` },
                React.createElement(AudioRecorderComponent, { data: audioRecordingData, onChange: onAudioRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.VIDEO_RESPONSE) && (React.createElement("div", { className: `self-start ${StylingClasses.qualitative.videoResponse}` },
                React.createElement(VideoRecorderComponent, { data: videoRecordingData, onChange: onVideoRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.IMAGE_RESPONSE) && (React.createElement("div", { className: `self-start ${StylingClasses.qualitative.imageResponse}` },
                React.createElement(ImageRecorderComponent, { data: imageRecordingData, onChange: onImageRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.DATE_RESPONSE) && (React.createElement("div", { className: StylingClasses.qualitative.dateResponse },
                React.createElement("span", null, "Date"),
                React.createElement("div", { className: 'flex flex-row gap-1' },
                    React.createElement(DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                            classes: { input: classes.selectInput },
                        }, format: 'dd/MM/yyyy', value: date, onChange: onDateChanged }),
                    React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onDateChanged(null) },
                        React.createElement(Close, null))))),
            nodeContent.allowedResponseTypes.includes(AllowedResponseType.DATE_RESPONSE) && (React.createElement("div", { className: StylingClasses.qualitative.timeResponse },
                React.createElement("span", null, "Time"),
                React.createElement("div", { className: 'flex flex-row gap-1' },
                    React.createElement(TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                            classes: { input: classes.selectInput },
                        }, format: 'HH:mm', value: time, onChange: onTimeChanged }),
                    React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onTimeChanged(null) },
                        React.createElement(Close, null)))))));
}
//# sourceMappingURL=ConsumerTextQuestion.js.map