import { DrawingBoard, useSelector } from '@fashtag/common';
import { UserMediaRecordingType, UXQuestionType, } from '@fashtag/common/dist/models';
import { dataURL } from '@gripeless/pico';
import { Button } from '@material-ui/core';
import { BrushOutlined, Cancel } from '@material-ui/icons';
import { useObserver } from 'mobx-react';
import React, { useCallback, useRef, useState } from 'react';
import './signature.css';
import { UXAudioRecorderComponent } from './UXAudioRecorder';
import { UXFeedbackWithContext } from './UXFeedbackWithContext';
import { UXVideoDrawingBoard } from './UXVideoDrawingBoard';
import { UXVideoRecorderComponent } from './UXVideoRecorder';
import { StylingClasses } from '../../custom-classes-utils/classes';
export function ConsumerUXQuestion(props) {
    const { formData, nodeContent, handlers } = props;
    const previewRef = useRef(null);
    const [isPreviewVisible, setPreviewVisible] = useState(false);
    const [hasUserRecordingStarted, setHasUserRecordingStarted] = useState(false);
    const [isVideoAnnotateActive, setIsVideoAnnotateActive] = useState(false);
    const [isFeedbackWithContextEnabled, setFeedbackWithContextEnabled] = useState(false);
    const { onUXPathResponseChanged, onUXTextResponseChanged, onUXUserVideoResponseChanged, onUXUserImageResponseChanged, onAudioRecordingChanged, } = useSelector((store) => {
        return {
            onUXPathResponseChanged: store.consumerStore.onUXPathResponseChanged,
            onUXTextResponseChanged: store.consumerStore.onUXTextResponseChanged,
            onUXUserVideoResponseChanged: store.consumerStore.onUXUserVideoResponseChanged,
            onUXUserImageResponseChanged: store.consumerStore.onUXUserImageResponseChanged,
            onAudioRecordingChanged: store.consumerStore.onAudioRecordingChanged,
        };
    });
    const { imageRecordingData, videoRecordingData, uxTextResponse, uxUserVideoResponse, uxXPathResponse, uxUserImageResponse, audioRecordingData, } = useObserver(() => {
        return Object.assign({}, formData);
    });
    const startCapture = useCallback(() => {
        var _a;
        window['screenRecordingFinished'] = (data) => {
            handlers.onVideoRecordingChanged({
                videoExternalUrl: data,
                videoUrl: data,
            });
            setPreviewVisible(false);
        };
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const webkit = window['webkit'];
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const NativeBridge = window['NativeBridge'];
        if (NativeBridge && NativeBridge.startRecording) {
            NativeBridge.startRecording('');
            setPreviewVisible(true);
        }
        else if (webkit &&
            webkit.messageHandlers &&
            webkit.messageHandlers.NativeBridge &&
            webkit.messageHandlers.NativeBridge.postMessage) {
            webkit.messageHandlers.NativeBridge.postMessage({
                callback: 'startRecording',
            });
        }
        else {
            (_a = navigator.mediaDevices) === null || _a === void 0 ? void 0 : _a.getDisplayMedia({
                video: {
                    cursor: 'always',
                },
                audio: false,
            }).then((captureStream) => {
                try {
                    setPreviewVisible(true);
                    if (!previewRef.current)
                        return;
                    previewRef.current.srcObject = captureStream;
                    const mediaRecorder = new MediaRecorder(captureStream);
                    mediaRecorder.start();
                    const videoChunks = [];
                    mediaRecorder.addEventListener('dataavailable', (event) => {
                        videoChunks.push(event.data);
                    });
                    mediaRecorder.addEventListener('stop', (event) => {
                        const videoBlob = new Blob(videoChunks, {
                            type: 'video/webm',
                        });
                        const videoUrl = URL.createObjectURL(videoBlob);
                        handlers.onVideoRecordingChanged({ videoBlob, videoUrl });
                        setPreviewVisible(false);
                        setIsVideoAnnotateActive(false);
                    });
                    // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                    // @ts-ignore
                    captureStream.oninactive = () => {
                        var _a, _b;
                        if (mediaRecorder.state === 'recording') {
                            mediaRecorder.stop();
                        }
                        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                        // @ts-ignore
                        const tracks = (_b = (_a = previewRef.current) === null || _a === void 0 ? void 0 : _a.srcObject) === null || _b === void 0 ? void 0 : _b.getTracks();
                        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                        // @ts-ignore
                        tracks.forEach((track) => track.stop());
                        if (previewRef.current) {
                            previewRef.current.srcObject = null;
                        }
                        console.log('stopped');
                    };
                }
                catch (e) {
                    console.log('error');
                }
            }).catch((err) => console.error('Error: ' + err));
        }
    }, [handlers]);
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    if (nodeContent.uxQuestionType === UXQuestionType.FEEDBACK_WITH_CONTEXT) {
        return (React.createElement("div", { className: StylingClasses.ux.uxFeedbackContext },
            (imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL) && (React.createElement("div", { style: { width: '50%', position: 'relative' } },
                React.createElement(Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => {
                        onImageRecordingChanged({});
                        onUXTextResponseChanged(null);
                    } }),
                React.createElement("img", { src: imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL }))),
            React.createElement(Button, { className: `${StylingClasses.general.btn} ${StylingClasses.ux.uxFeedbackContextBtn}`, variant: "contained", onClick: () => {
                    setFeedbackWithContextEnabled(true);
                } }, "Feedback with context"),
            isFeedbackWithContextEnabled && (React.createElement(UXFeedbackWithContext, { formData: formData, nodeContent: nodeContent, handlers: handlers, setFeedbackWithContextEnabled: setFeedbackWithContextEnabled, onUXPathResponseChanged: onUXPathResponseChanged, takeScreenShot: (ignore) => {
                    if (ignore) {
                        dataURL(window, { ignore: [ignore] }).then((dataURL) => {
                            onImageRecordingChanged({ imageDataURL: dataURL.value });
                            setFeedbackWithContextEnabled(false);
                        });
                    }
                    else {
                        dataURL(window).then((dataURL) => {
                            onImageRecordingChanged({ imageDataURL: dataURL.value });
                            setFeedbackWithContextEnabled(false);
                        });
                    }
                } })),
            React.createElement("textarea", { value: uxTextResponse, className: `${StylingClasses.question.response} ${StylingClasses.ux.uxFeedbackTextResponse}`, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                } })));
    }
    else if (nodeContent.uxQuestionType === UXQuestionType.SCREEN_SHOT) {
        return (React.createElement("div", { className: StylingClasses.ux.uxScreenshot },
            (imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL) && (React.createElement("div", { style: { width: '50%', position: 'relative' } },
                React.createElement(Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => {
                        onImageRecordingChanged({});
                        onUXTextResponseChanged(null);
                    } }),
                React.createElement(DrawingBoard, { backgroundImage: imageRecordingData.imageDataURL, onImageRecordingChanged: onUXUserImageResponseChanged }))),
            React.createElement(Button, { variant: "contained", className: `${StylingClasses.general.btn} ${StylingClasses.ux.uxFeedbackContextBtn}`, onClick: () => {
                    dataURL(window).then((dataURL) => {
                        onImageRecordingChanged({ imageDataURL: dataURL.value });
                        setFeedbackWithContextEnabled(false);
                    });
                }, style: { marginTop: 8 } }, "Take Screenshot"),
            React.createElement("textarea", { value: uxTextResponse, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                }, className: `${StylingClasses.question.response} ${StylingClasses.ux.uxFeedbackTextResponse}` })));
    }
    else {
        return (React.createElement("div", { className: StylingClasses.ux.uxScreenRecord },
            (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl) && (React.createElement("div", { style: { width: '50%', position: 'relative' } },
                React.createElement(Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => handlers.onVideoRecordingChanged(null) }),
                React.createElement("video", { src: videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl, controls: true, preload: "auto" }))),
            isPreviewVisible && (React.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, preload: 'auto', autoPlay: true, muted: true })),
            React.createElement(Button, { variant: "contained", onClick: () => {
                    startCapture();
                }, className: `${StylingClasses.general.btn} ${StylingClasses.ux.uxFeedbackContextBtn}` }, "Record Screen"),
            nodeContent.userMediaRecordingType ===
                UserMediaRecordingType.AUDIO_VIDEO &&
                (isPreviewVisible || (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl)) && (React.createElement("div", { className: 'self-start' },
                React.createElement(UXVideoRecorderComponent, { data: uxUserVideoResponse, onChange: onUXUserVideoResponseChanged, setHasUserRecordingStarted: setHasUserRecordingStarted, screenRecordingData: videoRecordingData }))),
            nodeContent.userMediaRecordingType === UserMediaRecordingType.AUDIO &&
                (isPreviewVisible || (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl)) && (React.createElement("div", { className: 'self-start' },
                React.createElement(UXAudioRecorderComponent, { data: audioRecordingData, onChange: onAudioRecordingChanged, setHasUserRecordingStarted: setHasUserRecordingStarted, screenRecordingData: videoRecordingData }))),
            isVideoAnnotateActive && (React.createElement(UXVideoDrawingBoard, { onStopAnnotate: () => setIsVideoAnnotateActive(false) })),
            isPreviewVisible && !isVideoAnnotateActive && !window['NativeBridge'] && (React.createElement("div", { style: { position: 'fixed', top: 0, left: 0 } },
                React.createElement("div", { style: {
                        display: 'flex',
                        flexDirection: 'column',
                        alignItems: 'center',
                        background: '#333',
                        borderRadius: 4,
                        padding: 8,
                        color: '#CCC',
                    }, onClick: () => setIsVideoAnnotateActive(true) },
                    React.createElement(BrushOutlined, { htmlColor: "#CCC" }),
                    "Start Annotation"))),
            React.createElement("textarea", { value: uxTextResponse, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, className: `${StylingClasses.question.response} ${StylingClasses.ux.uxFeedbackTextResponse}`, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                } })));
    }
}
//# sourceMappingURL=ConsumerUXQuestion.js.map