import { OptionType, } from '@fashtag/common/dist/models';
import React, { useLayoutEffect, useRef, useState } from 'react';
import { Checkbox, FormControlLabel, List } from '@material-ui/core';
import { getSubstitutedTextAndImage } from './utils';
import KeyboardArrowDownIcon from '@material-ui/icons/KeyboardArrowDown';
import KeyboardArrowUpIcon from '@material-ui/icons/KeyboardArrowUp';
import { DarkTooltip } from './DarkTooltip';
import { StylingClasses } from '../../custom-classes-utils/classes';
export function MatrixOptions(nodeContent, formData, setMatrixOptions, contentVarValues, variables, openRowIndex, setOpenRowIndex) {
    const containerRef = useRef(null);
    const [containerWidth, setContainerWidth] = useState(null);
    useLayoutEffect(() => {
        if (!containerRef.current) {
            return;
        }
        const resizeListener = () => {
            var _a, _b;
            setContainerWidth((_b = (_a = containerRef.current) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : null);
        };
        resizeListener();
        window.addEventListener('resize', resizeListener);
        return () => {
            window.removeEventListener('resize', resizeListener);
        };
    }, []);
    return (React.createElement("div", { ref: containerRef }, (containerWidth !== null && containerWidth !== void 0 ? containerWidth : 0) < 768 ? (React.createElement(List, { dense: true, component: "div", role: "list", style: {
            display: 'flex',
            flexDirection: 'column',
            padding: 0,
        } }, nodeContent.rows.map((row, index) => {
        const value = parseInt(row.index);
        const key = `dry-run-option-${value}`;
        const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(row, contentVarValues, variables);
        return (React.createElement("div", { key: key },
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    background: '#AAA',
                    padding: 8,
                }, onClick: () => setOpenRowIndex(openRowIndex === index ? null : index) },
                React.createElement("span", { className: StylingClasses.matrix.matrixRowLabel }, text),
                openRowIndex === index ? (React.createElement(KeyboardArrowUpIcon, null)) : (React.createElement(KeyboardArrowDownIcon, null))),
            imageUrl && (React.createElement("div", null,
                React.createElement("img", { src: imageUrl, style: { width: 160 } }))),
            videoUrl && (React.createElement("video", { width: "160", height: "120", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")),
            openRowIndex === index &&
                (nodeContent.optionType === OptionType.MULTIPLE ? (nodeContent.cols.map((col) => {
                    const value = parseInt(col.index);
                    const key = `dry-run-option-${row}-${col}`;
                    const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(col, contentVarValues, variables);
                    const isChecked = formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index].includes(parseInt(col.index));
                    return (React.createElement("div", { key: key, style: { margin: 8 } },
                        React.createElement(FormControlLabel, { control: React.createElement(Checkbox, { className: StylingClasses.matrix.matrixCheckbox, checked: isChecked, tabIndex: -1, disableRipple: true, onChange: () => setMatrixOptions(row.index, value, OptionType.MULTIPLE) }), label: React.createElement("span", { className: StylingClasses.matrix.matrixColLabel }, text) }),
                        imageUrl && (React.createElement("div", null,
                            React.createElement("img", { src: imageUrl, style: { width: 160 } }))),
                        videoUrl && (React.createElement("video", { width: "160", height: "120", controls: true, style: {
                                margin: 'auto',
                                border: '1px solid white',
                            } },
                            React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                            "Your browser does not support the video tag."))));
                })) : (React.createElement("div", { style: {
                        display: 'flex',
                        flexDirection: 'column',
                        gap: 8,
                    } }, nodeContent.cols.map((option) => {
                    const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(option, contentVarValues, variables);
                    const isChecked = formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index][0] ===
                            parseInt(option.index);
                    return (React.createElement(React.Fragment, null,
                        React.createElement("div", { style: {
                                display: 'flex',
                                margin: 8,
                                alignItems: 'center',
                            }, key: option.index },
                            React.createElement("input", { className: StylingClasses.matrix.matrixCheckbox, type: "radio", value: "consumer_type_individuals", style: { marginRight: 4 }, checked: isChecked, onChange: () => {
                                    if (index < nodeContent.rows.length - 1) {
                                        setOpenRowIndex(index + 1);
                                    }
                                    setMatrixOptions(row.index, parseInt(option.index), OptionType.SINGLE);
                                } }),
                            React.createElement("label", { htmlFor: "consumer_type_individuals", className: StylingClasses.matrix.matrixColLabel }, text)),
                        imageUrl && (React.createElement("div", null,
                            React.createElement("img", { src: imageUrl, style: { width: 160 } }))),
                        videoUrl && (React.createElement("video", { width: "160", height: "120", controls: true, style: {
                                margin: 'auto',
                                border: '1px solid white',
                            } },
                            React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                            "Your browser does not support the video tag."))));
                })))),
            formData.matrixOptions[row.index] &&
                formData.matrixOptions[row.index].length > 0 &&
                openRowIndex !== index && (React.createElement("div", { style: { margin: 8 } },
                React.createElement("b", null, "Selected Answer:"),
                ' ',
                formData.matrixOptions[row.index]
                    .map((index) => {
                    const element = nodeContent.cols.find((item) => item.index === index.toString());
                    return element === null || element === void 0 ? void 0 : element.content;
                })
                    .join(', '))),
            React.createElement("div", { style: { height: 2, background: '#AAA', margin: 8 } })));
    }))) : (React.createElement("div", { style: {
            display: 'flex',
            flexDirection: 'column',
            gap: 16,
            fontSize: 16,
        } },
        React.createElement("div", { key: '-1', style: { display: 'flex', gap: 8 } },
            React.createElement("div", { style: { flexBasis: 0, flexGrow: 1, fontWeight: 500 } }),
            nodeContent.cols.map((col, colIndex) => {
                var _a;
                const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(col, contentVarValues, variables);
                return (React.createElement("div", { key: col.index, style: {
                        flexBasis: 0,
                        flexGrow: 1,
                        fontWeight: 500,
                        wordBreak: 'break-all',
                        maxWidth: `${parseInt((100 / (nodeContent.cols.length + 1)).toString())}%`,
                        textAlign: 'center',
                    } },
                    React.createElement(DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                            ? (_a = col.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "bottom", arrow: true },
                        React.createElement("div", { className: StylingClasses.matrix.matrixColLabel }, text)),
                    imageUrl && (React.createElement("div", null,
                        React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                    videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                        React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                        "Your browser does not support the video tag."))));
            })),
        nodeContent.rows.map((row, rIndex) => {
            var _a;
            const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(row, contentVarValues, variables);
            return (React.createElement("div", { key: row.index, style: {
                    display: 'flex',
                    alignItems: 'center',
                } },
                React.createElement("div", { style: {
                        flexBasis: 0,
                        flexGrow: 1,
                        fontWeight: 500,
                        wordBreak: 'break-all',
                        maxWidth: `${parseInt((100 / (nodeContent.cols.length + 1)).toString())}%`,
                    } },
                    React.createElement(DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                            ? (_a = row.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                        React.createElement("div", { className: StylingClasses.matrix.matrixRowLabel }, text)),
                    imageUrl && (React.createElement("div", null,
                        React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                    videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                        React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                        "Your browser does not support the video tag."))),
                nodeContent.cols.map((col, colIndex) => (React.createElement("div", { key: col.index, style: { flexBasis: 0, flexGrow: 1 } }, nodeContent.optionType === OptionType.SINGLE ? (React.createElement("input", { className: StylingClasses.matrix.matrixCheckbox, type: "radio", value: "consumer_type_individuals", style: {
                        alignSelf: 'center',
                        width: '100%',
                    }, checked: formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index][0] ===
                            parseInt(col.index), onChange: () => {
                        setMatrixOptions(row.index, parseInt(col.index), OptionType.SINGLE);
                    } })) : (React.createElement(Checkbox, { className: StylingClasses.matrix.matrixCheckbox, checked: formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index].includes(parseInt(col.index)), style: {
                        alignSelf: 'center',
                        width: '100%',
                    }, tabIndex: -1, disableRipple: true, onChange: () => setMatrixOptions(row.index, parseInt(col.index), OptionType.MULTIPLE) })))))));
        })))));
}
//# sourceMappingURL=MatrixOptions.js.map