import { useDragSortableItem } from '@fashtag/common';
import { DragIndicator } from '@material-ui/icons';
import React, { useRef } from 'react';
import { DarkTooltip } from './DarkTooltip';
export const RankingOptionElementSelector = (props) => {
    var _a;
    const optionRef = useRef(null);
    const handleRef = useRef(null);
    const { option, index, move, imageUrl, videoUrl, isOptionHoveringEnabled } = props;
    const isDraggingOver = useDragSortableItem(index, move, optionRef, handleRef, 'new-edit-node-option-sort');
    return (React.createElement("div", { className: `flex items-start ${isDraggingOver ? 'invisible' : 'visible'}`, ref: optionRef, style: { display: 'flex', alignItems: 'center' } },
        React.createElement("div", { style: { padding: '11px 7px', cursor: 'move' }, ref: handleRef },
            React.createElement(DragIndicator, null)),
        React.createElement("div", { className: 'min-w-0' },
            React.createElement(DarkTooltip, { title: isOptionHoveringEnabled ? (_a = option.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                React.createElement("div", null, option.content)),
            imageUrl && (React.createElement("div", null,
                React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")))));
};
//# sourceMappingURL=RankingOptionElement.js.map