import { Cancel } from '@material-ui/icons';
import React, { useEffect, useRef, useState } from 'react';
import ReactDOM from 'react-dom';
import domElementPath from '../../utils/domElementPath';
import './signature.css';
export function UXFeedbackWithContext(props) {
    const { takeScreenShot, setFeedbackWithContextEnabled, onUXPathResponseChanged, } = props;
    const overLayRef = useRef(null);
    const xPositionRef = useRef(null);
    const yPositionRef = useRef(null);
    const [x, setX] = useState(0);
    const [y, setY] = useState(0);
    const [width, setWidth] = useState(0);
    const [height, setHeight] = useState(0);
    const runAnimationFrameRef = useRef(true);
    useEffect(() => {
        runAnimationFrameRef.current = false;
    }, []);
    useEffect(() => {
        const bodyTag = document.body;
        const elem = document.createElement('div');
        elem.style.cssText =
            'position:fixed;width:0;height:0;z-index:999999;background:#000;top:0;left:0;pointer-events:none';
        bodyTag.appendChild(elem);
        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore
        overLayRef.current = elem;
        function onMouseMove(event) {
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            xPositionRef.current = event.pageX;
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            yPositionRef.current = event.pageY;
        }
        function evaluateHoveredElement() {
            if (xPositionRef.current && yPositionRef.current) {
                const elements = document.elementsFromPoint(xPositionRef.current, yPositionRef.current);
                if (elements.length > 1) {
                    const element = elements[1];
                    const domRect = element.getBoundingClientRect();
                    setX(domRect.x);
                    setY(domRect.y);
                    setWidth(domRect.width);
                    setHeight(domRect.height);
                }
            }
            if (runAnimationFrameRef) {
                requestAnimationFrame(evaluateHoveredElement);
            }
        }
        requestAnimationFrame(evaluateHoveredElement);
        document.addEventListener('mousemove', onMouseMove);
        return () => {
            document.removeEventListener('mousemove', onMouseMove);
        };
    }, []);
    useEffect(() => {
        const clickListener = (e) => {
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            if (e.target && e.target.id && e.target.id === 'fwc-header') {
                console.log('Ignore');
            }
            else if (e.target &&
                // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                // @ts-ignore
                e.target.id &&
                // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                // @ts-ignore
                e.target.id === 'fwc-header-cancel') {
                setFeedbackWithContextEnabled(false);
            }
            else {
                e.stopImmediatePropagation();
                takeScreenShot('#fwc-header');
                e.target && onUXPathResponseChanged(domElementPath(e.target));
            }
        };
        document.addEventListener('click', clickListener, true);
        return () => document.removeEventListener('click', clickListener, true);
    }, [onUXPathResponseChanged, setFeedbackWithContextEnabled, takeScreenShot]);
    // function onImageRecordingChanged(data: ImageRecordingData | null) {
    //   handlers.onImageRecordingChanged(data);
    // }
    return overLayRef.current ? (ReactDOM.createPortal(React.createElement(React.Fragment, null,
        React.createElement("div", { id: "fwc-header", style: {
                position: 'fixed',
                zIndex: 9999999,
                background: '#ff0',
                top: 0,
                left: '50%',
                padding: 24,
                pointerEvents: 'all',
                transform: 'translate(-50%, 0)',
            } },
            "Select an element on page ",
            React.createElement(Cancel, { id: "fwc-header-cancel" })),
        React.createElement("div", { style: {
                position: 'fixed',
                opacity: 0.4,
                zIndex: 999999,
                background: '#000',
                top: 0,
                left: 0,
                width: '100vw',
                height: y,
                pointerEvents: 'all',
            } }),
        React.createElement("div", { style: {
                position: 'fixed',
                opacity: 0.4,
                zIndex: 999999,
                background: '#000',
                top: y,
                left: 0,
                width: x,
                height: height,
                pointerEvents: 'all',
            } }),
        React.createElement("div", { style: {
                position: 'fixed',
                opacity: 0.4,
                zIndex: 999999,
                background: '#000',
                top: y,
                left: x + width,
                width: `calc(100vw - ${x}px - ${width}px)`,
                height: height,
                pointerEvents: 'all',
            } }),
        React.createElement("div", { style: {
                position: 'fixed',
                opacity: 0.4,
                zIndex: 999999,
                background: '#000',
                top: y + height,
                left: 0,
                width: '100vw',
                height: `calc(100vh - ${y}px - ${height}px)`,
                pointerEvents: 'all',
            } }),
        React.createElement("div", { style: {
                position: 'fixed',
                zIndex: 999999,
                top: Math.max(y - 4, 0),
                left: Math.max(x - 4, 0),
                width: width + 8,
                height: height + 8,
                border: '4px #ffd902 dashed',
                pointerEvents: 'none',
            } })), overLayRef.current)) : (React.createElement(React.Fragment, null));
}
//# sourceMappingURL=UXFeedbackWithContext.js.map