import { DrawingBoard } from '@fashtag/common';
import { BrushOutlined } from '@material-ui/icons';
import React from 'react';
import ReactDOM from 'react-dom';
import './signature.css';
export function UXVideoDrawingBoard(props) {
    const { onStopAnnotate } = props;
    return ReactDOM.createPortal(React.createElement("div", { style: { position: 'fixed', zIndex: 999999, top: 0, left: 0 } },
        React.createElement(DrawingBoard, null),
        onStopAnnotate && (React.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                right: 24,
                display: 'flex',
                flexDirection: 'column',
                alignItems: 'center',
                background: '#333',
                borderRadius: 4,
                padding: 8,
                color: '#CCC',
            }, onClick: () => onStopAnnotate === null || onStopAnnotate === void 0 ? void 0 : onStopAnnotate() },
            React.createElement(BrushOutlined, { htmlColor: "#CCC" }),
            React.createElement("div", null, "Stop Annotation")))), document.body);
}
//# sourceMappingURL=UXVideoDrawingBoard.js.map