import React, { useEffect } from 'react';
import { useSelector } from '@fashtag/common';
import { toJS } from 'mobx';
import { makeStyles } from '@material-ui/core/styles';
import { getVariablesUI } from './getVariablesUI';
const useClasses = makeStyles(() => {
    return {
        rowInput: {
            padding: '13.2px 14px',
        },
    };
});
export const VariableSelector = () => {
    var _a;
    const classes = useClasses();
    const { formContextVariables, formContentVariables, startConsumer, isLoading, questionnaireResponseDTO, } = useSelector((store) => {
        return {
            isLoading: store.consumerStore.questionnaireResponse.isLoading,
            questionnaireResponseDTO: store.consumerStore.questionnaireResponse.data,
            formContextVariables: toJS(store.consumerStore.contextVars),
            formContentVariables: toJS(store.consumerStore.contentVars),
            startConsumer: store.consumerStore.getFirstQuestion,
        };
    });
    const questionnaireVariables = (_a = questionnaireResponseDTO === null || questionnaireResponseDTO === void 0 ? void 0 : questionnaireResponseDTO.questionnare.variables) !== null && _a !== void 0 ? _a : [];
    const handlers = useSelector((store) => {
        return {
            changeContextVarValue: store.consumerStore.changeContextVarValue,
            changeContentVarValue: store.consumerStore.changeContentVarValue,
        };
    });
    useEffect(() => {
        if (!isLoading &&
            formContentVariables.length === 0 &&
            formContextVariables.length === 0) {
            startConsumer();
        }
    }, [
        formContentVariables.length,
        formContextVariables.length,
        isLoading,
        startConsumer,
    ]);
    return (React.createElement("div", { className: 'flex flex-col items-stretch self-stretch gap-4 flex-grow min-h-0 ' +
            'overflow-y-auto p-4' }, formContextVariables.length + formContentVariables.length > 0 && (React.createElement("div", { className: 'flex flex-col items-stretch gap-4' },
        React.createElement("span", { style: { fontSize: 16, fontWeight: 400 } }, "Variables"),
        getVariablesUI(formContextVariables, handlers.changeContextVarValue, classes, questionnaireVariables),
        getVariablesUI(formContentVariables, handlers.changeContentVarValue, classes, questionnaireVariables)))));
};
//# sourceMappingURL=VariableSelector.js.map