import { OptionDisplayType, } from '@fashtag/common/dist/models';
import React from 'react';
import { Checkbox, FormControlLabel, List, MenuItem } from '@material-ui/core';
import { getSubstitutedTextAndImage } from './utils';
import { Select } from '@material-ui/core';
import { DarkTooltip } from './DarkTooltip';
import { getClassnamesForOption } from '../../custom-classes-utils/classNameUtils';
export function getConsumerMCQOptions(nodeContent, formData, toggleMCQOption, setMCQOptions, contentVarValues, variables, isForm, updateKeyMap) {
    const indexKeyboardShortcutBiMap = {};
    nodeContent.options.forEach((option, index) => {
        const shortCut = index <= 26 && !isForm ? String.fromCharCode(65 + index) : '';
        indexKeyboardShortcutBiMap[option.index] = shortCut;
        indexKeyboardShortcutBiMap[shortCut] = option.index;
        indexKeyboardShortcutBiMap[shortCut.toLowerCase()] = option.index;
    });
    updateKeyMap({
        SELECT_OPTION: (event) => {
            if ((event === null || event === void 0 ? void 0 : event.key) && indexKeyboardShortcutBiMap[event.key]) {
                toggleMCQOption(parseInt(indexKeyboardShortcutBiMap[event.key]));
            }
        },
    });
    const optionClassName = getClassnamesForOption(nodeContent);
    return (React.createElement(React.Fragment, null,
        nodeContent.minSelectionsAllowed && (React.createElement("div", { style: { color: '#777' } },
            "Select minimum ",
            nodeContent.minSelectionsAllowed,
            " options")),
        nodeContent.maxSelectionsAllowed && (React.createElement("div", { style: { color: '#777' } },
            "Select maximum ",
            nodeContent.maxSelectionsAllowed,
            " options")),
        nodeContent.optionDisplayType === OptionDisplayType.VERTICAL ? (React.createElement(List, { dense: true, component: "div", role: "list", style: { display: 'flex', flexDirection: 'column', padding: 0 } }, nodeContent.options.map((option) => {
            var _a;
            const value = parseInt(option.index);
            const key = `dry-run-option-${value}`;
            const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(option, contentVarValues, variables);
            return (React.createElement(React.Fragment, null,
                React.createElement(DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                        ? (_a = option.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                    React.createElement("div", { style: { display: 'flex', alignItems: 'center' }, className: optionClassName },
                        indexKeyboardShortcutBiMap[option.index] && (React.createElement("div", { style: {
                                paddingLeft: 4,
                                paddingRight: 4,
                                margin: 4,
                                border: 'solid 2px black',
                                borderRadius: 2,
                                backgroundColor: 'rgb(119, 150, 254)',
                                fontWeight: 500,
                                height: 22,
                            } }, indexKeyboardShortcutBiMap[option.index])),
                        React.createElement(FormControlLabel, { key: key, control: React.createElement(Checkbox, { checked: formData.mcqOptions.indexOf(value) !== -1, tabIndex: -1, disableRipple: true, onChange: () => toggleMCQOption(value) }), label: text }))),
                imageUrl && (React.createElement("div", null,
                    React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                    React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                    "Your browser does not support the video tag."))));
        }))) : (React.createElement(Select, { inputProps: {
                selectInput: {
                    padding: '8px 16px',
                },
            }, style: { maxWidth: 768 }, variant: 'outlined', className: optionClassName, value: formData.mcqOptions, multiple: true, renderValue: (selected) => selected
                .map((item) => { var _a, _b; return (_b = (_a = nodeContent.options.find((option) => option.index === `${item}`)) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : ' csds'; })
                .join('; '), onChange: (event) => setMCQOptions(event.target.value), MenuProps: { getContentAnchorEl: null } }, nodeContent.options.map((item) => {
            const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(item, contentVarValues, variables);
            return (React.createElement(MenuItem, { value: parseInt(item.index), key: item.index },
                text,
                imageUrl && (React.createElement("div", null,
                    React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                    React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                    "Your browser does not support the video tag."))));
        })))));
}
//# sourceMappingURL=getConsumerMCQOptions.js.map