import React from 'react';
import { DndProvider } from 'react-dnd';
import HTML5Backend from 'react-dnd-html5-backend';
import { RankingOptionElementSelector } from './RankingOptionElement';
import { getSubstitutedTextAndImage } from './utils';
export function getConsumerRankingOptions(nodeContent, formData, onRankingOptionSwapped, contentVarValues, variables, isForm) {
    return (React.createElement(DndProvider, { backend: HTML5Backend }, (formData.rankingOptions === null || formData.rankingOptions.length === 0
        ? nodeContent.options
        : formData.rankingOptions).map((option, index) => {
        const value = parseInt(option.index);
        const key = `dry-run-option-${value}`;
        const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(option, contentVarValues, variables);
        return (React.createElement(RankingOptionElementSelector, { key: option.index, option: option, index: index, move: onRankingOptionSwapped, imageUrl: imageUrl, videoUrl: videoUrl, isOptionHoveringEnabled: nodeContent.isOptionHoveringEnabled }));
    })));
}
//# sourceMappingURL=getConsumerRankingOptions.js.map