import { OptionDisplayType, } from '@fashtag/common/dist/models';
import { FormControlLabel, MenuItem, Radio, RadioGroup, Select, } from '@material-ui/core';
import React from 'react';
import { getSubstitutedTextAndImage } from './utils';
import { DarkTooltip } from './DarkTooltip';
import { getClassnamesForOption } from '../../custom-classes-utils/classNameUtils';
export function getConsumerSCQOptions(nodeContent, formData, onSCQOptionChanged, contentVarValues, variables, isForm, updateKeyMap) {
    const indexKeyboardShortcutBiMap = {};
    nodeContent.options.forEach((option, index) => {
        const shortCut = index <= 26 && !isForm ? String.fromCharCode(65 + index) : '';
        indexKeyboardShortcutBiMap[option.index] = shortCut;
        indexKeyboardShortcutBiMap[shortCut] = option.index;
        indexKeyboardShortcutBiMap[shortCut.toLowerCase()] = option.index;
    });
    updateKeyMap({
        SELECT_OPTION: (event) => {
            if ((event === null || event === void 0 ? void 0 : event.key) && indexKeyboardShortcutBiMap[event.key]) {
                onSCQOptionChanged(indexKeyboardShortcutBiMap[event.key]);
            }
        },
    });
    const optionClassName = getClassnamesForOption(nodeContent);
    return (React.createElement(React.Fragment, null, nodeContent.optionDisplayType === OptionDisplayType.VERTICAL ? (React.createElement(RadioGroup, { value: formData.scqOption, onChange: (e, value) => onSCQOptionChanged(value) }, nodeContent.options.map((option, index) => {
        var _a;
        const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(option, contentVarValues, variables);
        return (React.createElement(React.Fragment, null,
            React.createElement(DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                    ? (_a = option.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                React.createElement("div", { style: { display: 'flex', alignItems: 'center' }, className: optionClassName },
                    indexKeyboardShortcutBiMap[option.index] && (React.createElement("div", { style: {
                            paddingLeft: 4,
                            paddingRight: 4,
                            margin: 4,
                            border: 'solid 2px black',
                            borderRadius: 2,
                            backgroundColor: 'rgb(119, 150, 254)',
                            fontWeight: 500,
                            height: 22,
                        } }, indexKeyboardShortcutBiMap[option.index])),
                    React.createElement(FormControlLabel, { value: parseInt(option.index), control: React.createElement(Radio, null), label: text, key: option.index }))),
            imageUrl && (React.createElement("div", null,
                React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag."))));
    }))) : (React.createElement(Select, { inputProps: {
            selectInput: {
                padding: '8px 16px',
            },
        }, style: { maxWidth: 768 }, variant: 'outlined', className: optionClassName, value: formData.scqOption, renderValue: (selected) => { var _a, _b; return (_b = (_a = nodeContent.options.find((option) => option.index === `${selected}`)) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : ''; }, onChange: (event) => onSCQOptionChanged(event.target.value) }, nodeContent.options.map((item) => {
        const { text, imageUrl, videoUrl } = getSubstitutedTextAndImage(item, contentVarValues, variables);
        return (React.createElement(MenuItem, { value: parseInt(item.index), key: item.index },
            text,
            imageUrl && (React.createElement("div", null,
                React.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (React.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                React.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag."))));
    })))));
}
//# sourceMappingURL=getConsumerSCQOptions.js.map