import { ContextVariableType, VariableType, } from '@fashtag/common/dist/models';
import { MenuItem, Select, TextField, Button } from '@material-ui/core';
import { DatePicker, DateTimePicker, TimePicker } from '@material-ui/pickers';
import React from 'react';
import { Add, Close } from '@material-ui/icons';
export function getVariablesUI(formContextVariables, changeHandler, classes, questionnaireVariables) {
    return formContextVariables.map((variable, index) => {
        var _a, _b;
        const varConfig = questionnaireVariables.find((it) => it.variableName === variable.name);
        if (!varConfig) {
            return null;
        }
        let strValue = '';
        let numValue = 0;
        let stringListValue = [];
        let numberListValue = [];
        if (variable.name) {
            switch (variable.variableType) {
                case VariableType.DOUBLE:
                    numValue = variable.number;
                    break;
                case VariableType.STRING:
                    strValue = variable.string;
                    break;
                case VariableType.LIST_STRING:
                    stringListValue = variable.stringsList;
                    break;
                case VariableType.LIST_DOUBLE:
                    numberListValue = variable.numbersList;
                    break;
            }
        }
        const options = (_b = (_a = varConfig.categoryValues) === null || _a === void 0 ? void 0 : _a.filter((it) => it)) !== null && _b !== void 0 ? _b : [];
        const hasOptions = options && options.length > 0;
        return (React.createElement("div", { key: variable.name, className: 'py-2 flex items-center gap-4 ' },
            React.createElement("span", { className: 'w-1/2' }, varConfig.displayVariableName),
            hasOptions && (React.createElement(Select, { variant: 'outlined', value: strValue, className: 'w-1/2', onChange: (e) => {
                    var _a;
                    const value = e.target.value;
                    changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.STRING,
                        string: value,
                    }, index);
                } }, options.map((option) => {
                return (React.createElement(MenuItem, { key: option, value: option }, option));
            }))),
            (varConfig.variableType === ContextVariableType.STRING ||
                varConfig.variableType === ContextVariableType.IMAGE ||
                varConfig.variableType === ContextVariableType.VIDEO) && (React.createElement(TextField, { variant: 'outlined', className: 'w-1/2', inputProps: { className: classes.rowInput }, type: 'text', value: strValue, onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.STRING,
                        string: e.target.value,
                    }, index);
                } })),
            (varConfig.variableType === ContextVariableType.INTEGER ||
                varConfig.variableType === ContextVariableType.REAL) && (React.createElement(TextField, { variant: 'outlined', className: 'w-1/2', inputProps: { className: classes.rowInput }, type: 'number', value: numValue, onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.DOUBLE,
                        number: parseFloat(e.target.value),
                    }, index);
                } })),
            varConfig.variableType === ContextVariableType.BOOLEAN && (React.createElement(Select, { variant: 'outlined', value: strValue, inputProps: { className: classes.rowInput }, className: 'w-1/2', onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.STRING,
                        string: e.target.value,
                    }, index);
                } },
                React.createElement(MenuItem, { value: 'true' }, "Yes"),
                React.createElement(MenuItem, { value: 'false' }, "No"))),
            varConfig.variableType === ContextVariableType.DATE && (React.createElement(DatePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'dd/MM/yyyy', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === ContextVariableType.TIME && (React.createElement(TimePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'HH:mm', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === ContextVariableType.DATE_TIME && (React.createElement(DateTimePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'dd/MM/yyyy HH:mm', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === ContextVariableType.LIST_STRING && (React.createElement(React.Fragment, null,
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                stringListValue.map((value, fieldIndex) => {
                    var _a;
                    return (React.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        React.createElement(TextField, { variant: 'outlined', inputProps: {
                                className: classes.rowInput,
                            }, value: (_a = stringListValue[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: VariableType.LIST_STRING,
                                    stringsList: stringListValue.map((it, index) => {
                                        if (index === fieldIndex) {
                                            return event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '');
                                        }
                                        return it;
                                    }),
                                }, index);
                            } }),
                        React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: VariableType.LIST_STRING,
                                    stringsList: stringListValue.filter((it, index) => index !== fieldIndex),
                                }, index);
                            } },
                            React.createElement(Close, null)),
                        fieldIndex !== stringListValue.length - 1 && (React.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                React.createElement(Button, { onClick: () => {
                        var _a;
                        changeHandler({
                            name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                            variableType: VariableType.LIST_STRING,
                            stringsList: [...stringListValue, ''],
                        }, index);
                    }, variant: 'contained' },
                    React.createElement(Add, null)),
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "]"))),
            (varConfig.variableType === ContextVariableType.LIST_INTEGER ||
                varConfig.variableType === ContextVariableType.LIST_REAL) && (React.createElement(React.Fragment, null,
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                numberListValue.map((value, fieldIndex) => {
                    var _a;
                    return (React.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        React.createElement(TextField, { variant: 'outlined', inputProps: {
                                className: classes.rowInput,
                            }, type: 'number', value: (_a = numberListValue[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: VariableType.LIST_DOUBLE,
                                    numbersList: numberListValue.map((it, index) => {
                                        if (index === fieldIndex) {
                                            return varConfig.variableType ===
                                                ContextVariableType.LIST_INTEGER
                                                ? parseInt(event.target.value)
                                                : parseFloat(event.target.value);
                                        }
                                        return it;
                                    }),
                                }, index);
                            } }),
                        React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: VariableType.LIST_DOUBLE,
                                    numbersList: numberListValue.filter((it, index) => index !== fieldIndex),
                                }, index);
                            } },
                            React.createElement(Close, null)),
                        fieldIndex !== numberListValue.length - 1 && (React.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                React.createElement(Button, { onClick: () => {
                        var _a;
                        changeHandler({
                            name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                            variableType: VariableType.LIST_DOUBLE,
                            numbersList: [...numberListValue, 0],
                        }, index);
                    }, variant: 'contained' },
                    React.createElement(Add, null)),
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "]")))));
    });
}
//# sourceMappingURL=getVariablesUI.js.map