import { NodeType, OptionDisplayType, OptionType, QualitativeType, QuestionType, RatingDisplayType, } from '@fashtag/common/dist/models';
import { StylingClasses } from './classes';
export function getClassnamesForContent(content) {
    const classes = [StylingClasses.general.title];
    switch (content.nodeType) {
        case NodeType.STATEMENT:
            classes.push(StylingClasses.statement.statement);
            break;
        case NodeType.QUESTION:
            classes.push(StylingClasses.question.question);
            switch (content.questionType) {
                case QuestionType.SIGNATURE:
                    classes.push(StylingClasses.signature.signatureTitle);
                    break;
                case QuestionType.RATING:
                    classes.push(StylingClasses.rating.ratingQuestion);
                    break;
                case QuestionType.OPTIONS:
                    switch (content.optionType) {
                        case OptionType.SINGLE:
                            classes.push(StylingClasses.options.scqQuestion);
                            break;
                        case OptionType.MULTIPLE:
                            classes.push(StylingClasses.options.mcqQuestion);
                            break;
                        case OptionType.RANKING:
                            classes.push(StylingClasses.options.rankingQuestion);
                            break;
                    }
                    break;
                case QuestionType.TEXT:
                    if (content.qualitativeType === QualitativeType.UPLOAD) {
                        classes.push(StylingClasses.upload.uploadTitle);
                    }
                    else {
                        classes.push(StylingClasses.qualitative.qualitativeQuestion);
                    }
                    break;
                case QuestionType.MATRIX:
                    classes.push(StylingClasses.matrix.matrixQuestion);
                    break;
                case QuestionType.UX:
                    classes.push(StylingClasses.ux.uxTitle);
                    break;
            }
            break;
        case NodeType.THANKS:
            classes.push(StylingClasses.thanksBlock.thanksTitle);
            break;
        case NodeType.WELCOME:
            classes.push(StylingClasses.welcomeBlock.welcomeTitle);
            break;
    }
    return classes.join(' ');
}
export function getClassnamesForDescription(content) {
    const classes = [StylingClasses.general.desc];
    if (content.nodeType === NodeType.WELCOME) {
        classes.push(StylingClasses.welcomeBlock.welcomeDesc);
    }
    if (content.nodeType === NodeType.THANKS) {
        classes.push(StylingClasses.thanksBlock.thanksDesc);
    }
    if (content.nodeType === NodeType.QUESTION) {
        if (content.questionType === QuestionType.SIGNATURE)
            classes.push(StylingClasses.signature.signatureDesc);
        else if (content.questionType === QuestionType.UX)
            classes.push(StylingClasses.ux.uxDesc);
    }
    return classes.join(' ');
}
export function getClassnamesForWelThxBtn(content) {
    const classes = [StylingClasses.general.btn];
    switch (content.nodeType) {
        case NodeType.WELCOME:
            classes.push(StylingClasses.welcomeBlock.welcomeBtn);
            break;
        case NodeType.THANKS:
            classes.push(StylingClasses.thanksBlock.thanksBtn);
            break;
    }
    return classes.join(' ');
}
export function getClassnamesForOption(content) {
    const classes = [];
    switch (content.questionType) {
        case QuestionType.OPTIONS:
            switch (content.optionType) {
                case OptionType.SINGLE:
                    if (content.optionDisplayType === OptionDisplayType.VERTICAL) {
                        classes.push(StylingClasses.options.scqOption);
                        classes.push(StylingClasses.question.option);
                    }
                    else {
                        classes.push(StylingClasses.options.scqDropdown);
                        classes.push(StylingClasses.question.dropdown);
                    }
                    break;
                case OptionType.MULTIPLE:
                    if (content.optionDisplayType === OptionDisplayType.VERTICAL) {
                        classes.push(StylingClasses.options.mcqOption);
                        classes.push(StylingClasses.question.option);
                    }
                    else {
                        classes.push(StylingClasses.options.mcqDropdown);
                        classes.push(StylingClasses.question.dropdown);
                    }
                    break;
                case OptionType.RANKING:
                    classes.push(StylingClasses.options.rankingOption);
                    classes.push(StylingClasses.question.option);
                    break;
            }
            break;
        case QuestionType.RATING:
            classes.push(StylingClasses.rating.ratingOption);
            classes.push(StylingClasses.question.option);
            switch (content.ratingDisplayType) {
                case RatingDisplayType.NUMERIC:
                    classes.push(StylingClasses.rating.ratingOptionNumber);
                    break;
                case RatingDisplayType.THUMBS_UP:
                    classes.push(StylingClasses.rating.ratingOptionThumbsUp);
                    break;
                case RatingDisplayType.PEOPLE:
                    classes.push(StylingClasses.rating.ratingOptionReaction);
                    break;
                case RatingDisplayType.LIGHTNING:
                    classes.push(StylingClasses.rating.ratingOptionLightning);
                    break;
                case RatingDisplayType.STARS:
                    classes.push(StylingClasses.rating.ratingOptionStars);
                    break;
            }
            break;
    }
    return classes.join(' ');
}
//# sourceMappingURL=classNameUtils.js.map