import React from 'react';
import { provideStore } from '@fashtag/common';
import { ConsumerRootStore } from './stores/ConsumerRootStore';
import { ConsumerWrapper } from './components/ConsumerWrapper';
import { ConsumerWebSDK, } from './components/ConsumerWebSDK';
import ReactDOM from 'react-dom';
import './tailwind/output.css';
const providedConsumerWrapper = provideStore(ConsumerRootStore, ConsumerWrapper);
export { providedConsumerWrapper as Consumer };
const ProvidedConsumerSDK = provideStore(ConsumerRootStore, ConsumerWebSDK);
export { ProvidedConsumerSDK as ConsumerWebSDK };
export function loadQuestionnaireWebSDK(container, data, onExit, apiKey) {
    ReactDOM.render(React.createElement(ProvidedConsumerSDK, { onExit: () => {
            onExit();
        }, initData: data, apiKey: apiKey }), container);
}
export function unloadQuestionnaireWebSDK(container) {
    ReactDOM.unmountComponentAtNode(container);
}
export * from './models/ConsumerModels';
//# sourceMappingURL=index.js.map