import { __awaiter } from "tslib";
import { http } from '@fashtag/common';
import { SessionStatus, } from '@fashtag/common/dist/models';
import { urls } from '../urls';
export class QuestionnaireConsumerService {
    // async getEditQuestionnaireData(
    //   businessId: string,
    //   questionnaireId: string,
    //   signal?: AbortSignal
    // ): Promise<QuestionnareResponseDTO> {
    //   const url = urls.getEditQuestionnaireData(businessId, questionnaireId);
    //   return http.get(url, { signal });
    // }
    navigateBack(sessionId, flowType) {
        return __awaiter(this, void 0, void 0, function* () {
            const url = urls.navigateBack(sessionId, flowType);
            return http.get(url);
        });
    }
    navigateForward(sessionId, flowType) {
        return __awaiter(this, void 0, void 0, function* () {
            const url = urls.navigateForward(sessionId, flowType);
            return http.get(url);
        });
    }
    startDryRun(input) {
        const url = urls.startDryRun();
        return http.post(url, input);
    }
    startUniverseQuestionnaire(input, flowType, qId) {
        const url = urls.startUniverseQuestionnaire(flowType, qId);
        return http.post(url, input);
    }
    startWebConsumer(consumerData) {
        const url = urls.startSDKConsumer();
        return http
            .post(url, {
            flowType: consumerData.flowType,
            questionnaireId: consumerData.questionnaireId,
            distributionType: consumerData.distributionType,
            isDryRun: false,
            sessionStatus: SessionStatus.CREATED,
            context: {},
            allContentVarsValues: {},
            futureSessionId: consumerData.futureSessionId,
        }, { parseJSON: false })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
    startSDKConsumer(consumerData) {
        const url = urls.startSDKConsumer();
        return http
            .post(url, consumerData.initData, {
            parseJSON: false,
        })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getDryRunNextQuestion(input) {
        const url = urls.getDryRunNextQuestion();
        return http
            .post(url, input, { parseJSON: false })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
    exitQuestionnaire(input) {
        const url = urls.exitQuestionnaire();
        return http.post(url, input, {
            parseJSON: false,
        });
    }
    getWebConsumerNextQuestion(input) {
        const url = urls.getWebConsumerNextQuestion();
        return http
            .post(url, input, { parseJSON: false })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getSDKConsumerNextQuestion(input) {
        const url = urls.getSDKConsumerNextQuestion();
        return http
            .post(url, input, { parseJSON: false })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getUniverseQuestionnaireNextQuestion(flowType, input) {
        const url = urls.getUniverseQuestionnaireNextQuestion(flowType);
        return http
            .post(url, input, { parseJSON: false })
            .then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: SessionStatus.COMPLETED,
                };
            }
        }));
    }
}
//# sourceMappingURL=QuestionnaireConsumerService.js.map