import { __awaiter, __decorate, __metadata, __rest } from "tslib";
/* eslint-disable no-empty */
import { applyNetworkResponse, constants, getDefaultNetworkResponse, isNotNullOrUndefined, } from '@fashtag/common';
import { ContextVariableType, DisplayStyle, DisplayType, DistributionType, FlowType, NodeRepresentation, NodeType, OptionType, PrePopulateAnswerType, QualitativeType, QuestionType, SessionStatus, VariableType, } from '@fashtag/common/dist/models';
import { action, computed, observable, reaction, runInAction, } from 'mobx';
import { ConsumerMode, ConsumerState, } from '..';
import { getAnswer, getAnswerForChat, getEmptyQuestionnaireConsumerData, getFormAnswer, getFormAnswerForChat, isVariableValid, } from '../utils/consumerUtils';
const { CONTEXT_VARIABLE_REGEX } = constants;
export class ConsumerStore {
    constructor(questionnaireConsumerService) {
        this.questionnaireConsumerService = questionnaireConsumerService;
        this.consumerState = ConsumerState.NOT_RUNNING;
        this.question = null;
        this.isQuestionLoading = false;
        this.error = null;
        this.formData = getEmptyQuestionnaireConsumerData();
        this.contextVars = [];
        this.contentVars = [];
        this.existingElements = [];
        this.existingElementsAnswer = [];
        this.displayConfig = {
            displayStyle: DisplayStyle.NORMAL,
            displayType: DisplayType.EMBED,
        };
        this.keyMapHandler = {};
        this.questionnaireResponse = getDefaultNetworkResponse();
        this.updateKeyMap = (newKeyMap) => {
            this.keyMapHandler = Object.assign(Object.assign({}, this.keyMapHandler), newKeyMap);
        };
        this.addToExistingElements = (element) => {
            this.existingElements = [
                ...this.existingElements,
                JSON.parse(JSON.stringify(element)),
            ];
        };
        this.addToExistingElementsAnswer = (string) => {
            this.existingElementsAnswer = [...this.existingElementsAnswer, string];
        };
        this.resetConsumer = () => {
            this.consumerState = ConsumerState.NOT_RUNNING;
            this.consumerData = undefined;
            this.question = null;
            this.isQuestionLoading = false;
            this.error = null;
            this.formData = getEmptyQuestionnaireConsumerData();
            this.contextVars = [];
            this.contentVars = [];
            console.log('called');
            this.displayConfig = {
                displayStyle: DisplayStyle.NORMAL,
                displayType: DisplayType.EMBED,
            };
        };
        this.initiateConsumer = (consumerData) => {
            this.resetConsumer();
            this.consumerData = Object.assign({}, consumerData);
            this.contextVars = [];
            this.contentVars = [];
            if (consumerData.mode !== ConsumerMode.DRY_RUN) {
                this.getFirstQuestion();
            }
            else {
                this.consumerState = ConsumerState.VARIABLE_SELECTION;
            }
            this.existingElements = [];
            this.existingElementsAnswer = [];
        };
        this.onNextQuestion = (question, isLoading, error) => {
            this.question = question;
            this.isQuestionLoading = isLoading;
            this.error = error;
        };
        this.setAnswersOnRevisit = (question) => {
            var _a, _b, _c, _d;
            if ((_a = question.feedBackResponseDTO) === null || _a === void 0 ? void 0 : _a.content) {
                if (question.feedBackResponseDTO.content.variableType ===
                    VariableType.DOUBLE) {
                    this.formData.scqOption = question.feedBackResponseDTO.content.number;
                    this.formData.rating = question.feedBackResponseDTO.content.number;
                }
                if (question.feedBackResponseDTO.content.variableType ===
                    VariableType.LIST_DOUBLE) {
                    this.formData.mcqOptions =
                        question.feedBackResponseDTO.content.numbersList;
                    if (question.nodeContent.nodeType === NodeType.QUESTION &&
                        question.nodeContent.questionType === QuestionType.OPTIONS) {
                        this.formData.rankingOptions =
                            question.feedBackResponseDTO.content.numbersList.map((rank) => {
                                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                                return question.nodeContent.options.find((option) => option.index === rank.toString());
                            });
                    }
                }
                if (question.feedBackResponseDTO.content.variableType ===
                    VariableType.STRING) {
                    this.formData.text = question.feedBackResponseDTO.content.string;
                }
            }
            if (question.feedBackResponseDTO.dateResponse) {
                this.formData.date = new Date(question.feedBackResponseDTO.dateResponse);
            }
            if (question.feedBackResponseDTO.timeResponse) {
                this.formData.time = new Date(question.feedBackResponseDTO.timeResponse);
            }
            if (question.feedBackResponseDTO.imageUrl) {
                this.formData.imageRecordingData = {
                    imageUrl: question.feedBackResponseDTO.imageUrl,
                };
            }
            if (question.feedBackResponseDTO.videoUrl) {
                this.formData.videoRecordingData = {
                    videoUrl: question.feedBackResponseDTO.videoUrl,
                    videoExternalUrl: question.feedBackResponseDTO.videoUrl,
                };
            }
            if (question.feedBackResponseDTO.url) {
                this.formData.audioRecordingData = {
                    audioUrl: question.feedBackResponseDTO.url,
                };
            }
            if (question.nodeContent.nodeType === NodeType.QUESTION &&
                question.nodeContent.questionType === QuestionType.TEXT &&
                question.nodeContent.qualitativeType === QualitativeType.UPLOAD) {
                fetch((_b = question.feedBackResponseDTO.url) !== null && _b !== void 0 ? _b : '')
                    .then((e) => {
                    return e.blob();
                })
                    .then((blob) => {
                    this.formData.fileUpload = new File([blob], 'returned');
                });
            }
            if (question.feedBackResponseDTO.matrixResponse) {
                let record = {};
                if (question.nodeContent.nodeType === NodeType.QUESTION &&
                    question.nodeContent.questionType === QuestionType.MATRIX &&
                    question.nodeContent.optionType === OptionType.SINGLE) {
                    Object.keys((_c = question.feedBackResponseDTO.matrixResponse) !== null && _c !== void 0 ? _c : {}).forEach((key) => {
                        var _a;
                        const variableData = (_a = question.feedBackResponseDTO.matrixResponse) === null || _a === void 0 ? void 0 : _a[key];
                        if (variableData &&
                            variableData.variableType === VariableType.DOUBLE) {
                            record = Object.assign(Object.assign({}, record), { [key]: [variableData.number] });
                        }
                    });
                }
                else {
                    Object.keys((_d = question.feedBackResponseDTO.matrixResponse) !== null && _d !== void 0 ? _d : {}).forEach((key) => {
                        var _a;
                        const variableData = (_a = question.feedBackResponseDTO.matrixResponse) === null || _a === void 0 ? void 0 : _a[key];
                        if (variableData &&
                            variableData.variableType === VariableType.LIST_DOUBLE) {
                            record = Object.assign(Object.assign({}, record), { [key]: variableData.numbersList });
                        }
                    });
                }
                this.formData.matrixOptions = record;
            }
            if (question.feedBackResponseDTO.responseMetadata) {
                const responseMetadata = question.feedBackResponseDTO.responseMetadata;
                if (responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxUserImageResponse']) {
                    this.formData.uxUserImageResponse = {
                        imageUrl: responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxUserImageResponse'],
                    };
                }
                if (responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxTextResponse']) {
                    this.formData.uxTextResponse = responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxTextResponse'];
                }
                if (responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxUserVideoResponse']) {
                    this.formData.uxUserVideoResponse = {
                        videoUrl: responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxUserVideoResponse'],
                    };
                }
                if (responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxXPathResponse']) {
                    this.formData.uxXPathResponse = responseMetadata === null || responseMetadata === void 0 ? void 0 : responseMetadata['uxXPathResponse'];
                }
            }
        };
        this.navigateBack = (sessionId) => {
            const consumerData = this.consumerData;
            if (!consumerData)
                return;
            let flowType = FlowType.QUESTIONNAIRE;
            switch (consumerData.mode) {
                case ConsumerMode.DRY_RUN:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.UNIVERSE:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.WEB_CONSUMER:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.SDK_CONSUMER:
                    flowType = consumerData.initData.flowType;
                    break;
            }
            this.onNextQuestion(this.question, true, null);
            this.questionnaireConsumerService
                .navigateBack(sessionId, flowType)
                .then((question) => {
                this.prefillResponses(question);
            })
                .catch((error) => {
                this.formData = getEmptyQuestionnaireConsumerData();
                this.onNextQuestion(null, false, error);
            });
        };
        this.prefillResponses = (question) => {
            if (question.sessionStatus === SessionStatus.COMPLETED) {
                return;
            }
            this.formData = getEmptyQuestionnaireConsumerData();
            if (question.nodeContent.nodeType === NodeType.FORM) {
                // TODO: Extract as common fn
                const formQuestions = [];
                const formItems = question.nodeContent.formItems;
                formItems.forEach((formItem, index) => {
                    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
                    const formItemResponse = getEmptyQuestionnaireConsumerData();
                    if (!formItemResponse) {
                        return;
                    }
                    const response = (_b = (_a = question.feedBackResponseDTO) === null || _a === void 0 ? void 0 : _a.formResponseDTOHashMap) === null || _b === void 0 ? void 0 : _b[(_c = formItem.id) !== null && _c !== void 0 ? _c : ''];
                    if (response) {
                        if (((_d = response.answer) === null || _d === void 0 ? void 0 : _d.variableType) === VariableType.DOUBLE) {
                            formItemResponse.scqOption = (_e = response.answer) === null || _e === void 0 ? void 0 : _e.number;
                            formItemResponse.rating = (_f = response.answer) === null || _f === void 0 ? void 0 : _f.number;
                        }
                        if (((_g = response.answer) === null || _g === void 0 ? void 0 : _g.variableType) === VariableType.LIST_DOUBLE) {
                            formItemResponse.mcqOptions = (_h = response.answer) === null || _h === void 0 ? void 0 : _h.numbersList;
                            if (question.nodeContent.nodeType === NodeType.QUESTION &&
                                question.nodeContent.questionType === QuestionType.OPTIONS) {
                                formItemResponse.rankingOptions = (_j = response.answer) === null || _j === void 0 ? void 0 : _j.numbersList.map((rank) => {
                                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                                    return question.nodeContent.options.find((option) => option.index === rank.toString());
                                });
                            }
                        }
                        if (((_k = response.answer) === null || _k === void 0 ? void 0 : _k.variableType) === VariableType.STRING) {
                            formItemResponse.text = (_l = response.answer) === null || _l === void 0 ? void 0 : _l.string;
                        }
                    }
                    if (response === null || response === void 0 ? void 0 : response.dateResponse) {
                        formItemResponse.date = new Date(response === null || response === void 0 ? void 0 : response.dateResponse);
                    }
                    if (response === null || response === void 0 ? void 0 : response.timeResponse) {
                        formItemResponse.time = new Date(response === null || response === void 0 ? void 0 : response.timeResponse);
                    }
                    if (response === null || response === void 0 ? void 0 : response.imageUrl) {
                        formItemResponse.imageRecordingData = {
                            imageUrl: response === null || response === void 0 ? void 0 : response.imageUrl,
                        };
                    }
                    if (response === null || response === void 0 ? void 0 : response.videoUrl) {
                        formItemResponse.videoRecordingData = {
                            videoUrl: response === null || response === void 0 ? void 0 : response.videoUrl,
                            videoExternalUrl: response === null || response === void 0 ? void 0 : response.videoUrl,
                        };
                    }
                    if (response === null || response === void 0 ? void 0 : response.url) {
                        formItemResponse.audioRecordingData = {
                            audioUrl: response === null || response === void 0 ? void 0 : response.url,
                        };
                    }
                    if (formItem.nodeContent.nodeType === NodeType.QUESTION &&
                        formItem.nodeContent.questionType === QuestionType.TEXT &&
                        formItem.nodeContent.qualitativeType === QualitativeType.UPLOAD) {
                        fetch((_m = response === null || response === void 0 ? void 0 : response.url) !== null && _m !== void 0 ? _m : '')
                            .then((e) => {
                            return e.blob();
                        })
                            .then((blob) => {
                            formItemResponse.fileUpload = new File([blob], 'returned');
                        });
                    }
                    if (response === null || response === void 0 ? void 0 : response.matrixResponse) {
                        let record = {};
                        if (formItem.nodeContent.nodeType === NodeType.QUESTION &&
                            formItem.nodeContent.questionType === QuestionType.MATRIX &&
                            formItem.nodeContent.optionType === OptionType.SINGLE) {
                            Object.keys((_o = response === null || response === void 0 ? void 0 : response.matrixResponse) !== null && _o !== void 0 ? _o : {}).forEach((key) => {
                                var _a;
                                const variableData = (_a = response === null || response === void 0 ? void 0 : response.matrixResponse) === null || _a === void 0 ? void 0 : _a[key];
                                if (variableData &&
                                    variableData.variableType === VariableType.DOUBLE) {
                                    record = Object.assign(Object.assign({}, record), { [key]: [variableData.number] });
                                }
                            });
                        }
                        else {
                            Object.keys((_p = response === null || response === void 0 ? void 0 : response.matrixResponse) !== null && _p !== void 0 ? _p : {}).forEach((key) => {
                                var _a;
                                const variableData = (_a = response === null || response === void 0 ? void 0 : response.matrixResponse) === null || _a === void 0 ? void 0 : _a[key];
                                if (variableData &&
                                    variableData.variableType === VariableType.LIST_DOUBLE) {
                                    record = Object.assign(Object.assign({}, record), { [key]: variableData.numbersList });
                                }
                            });
                        }
                        formItemResponse.matrixOptions = record;
                    }
                    formQuestions.push(formItemResponse);
                });
                this.formData.formQuestions = formQuestions;
            }
            else {
                if (question.feedBackResponseDTO) {
                    this.setAnswersOnRevisit(question);
                }
            }
            this.onNextQuestion(question, false, null);
        };
        this.navigateForward = (sessionId) => {
            const consumerData = this.consumerData;
            if (!consumerData)
                return;
            let flowType = FlowType.QUESTIONNAIRE;
            switch (consumerData.mode) {
                case ConsumerMode.DRY_RUN:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.UNIVERSE:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.WEB_CONSUMER:
                    flowType = consumerData.flowType;
                    break;
                case ConsumerMode.SDK_CONSUMER:
                    flowType = consumerData.initData.flowType;
                    break;
            }
            this.onNextQuestion(this.question, true, null);
            this.questionnaireConsumerService
                .navigateForward(sessionId, flowType)
                .then((question) => {
                this.prefillResponses(question);
            })
                .catch((error) => {
                this.formData = getEmptyQuestionnaireConsumerData();
                this.onNextQuestion(null, false, error);
            });
        };
        this.getFirstQuestion = () => {
            this.consumerState = ConsumerState.RUNNING;
            const consumerData = this.consumerData;
            if (!consumerData)
                return Promise.reject('unknown error');
            let nextQuestionPromise;
            switch (consumerData.mode) {
                case ConsumerMode.DRY_RUN:
                    nextQuestionPromise = this.startDryRun(consumerData);
                    break;
                case ConsumerMode.UNIVERSE:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.startUniverseQuestionnaire({
                            flowType: consumerData.flowType,
                            storeAssociateId: consumerData.storeAssociateId,
                            storeId: consumerData.storeId,
                            workspaceId: consumerData.workspaceId,
                        }, consumerData.flowType, consumerData.questionnaireId);
                    break;
                case ConsumerMode.WEB_CONSUMER:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.startWebConsumer(Object.assign({ distributionType: DistributionType.WEB_EMBED }, consumerData));
                    break;
                case ConsumerMode.SDK_CONSUMER:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.startSDKConsumer(consumerData);
                    break;
            }
            return this.applyNextQuestionPromise(nextQuestionPromise).then((question) => {
                var _a;
                if (question.questionnareId &&
                    consumerData.mode === ConsumerMode.WEB_CONSUMER) {
                    consumerData.questionnaireId = question.questionnareId;
                }
                if (question === null || question === void 0 ? void 0 : question.prepopulatedAnswer) {
                    this.formData.text = question.prepopulatedAnswer;
                }
                else if (((_a = question === null || question === void 0 ? void 0 : question.nodeContent) === null || _a === void 0 ? void 0 : _a.nodeType) === NodeType.FORM) {
                    question.nodeContent.formItems.forEach((formItem, index) => {
                        var _a, _b, _c, _d, _e;
                        if (formItem.nodeContent.nodeType === NodeType.QUESTION && ((_a = question.formPrepopulatedAnswer) === null || _a === void 0 ? void 0 : _a[(_b = formItem.id) !== null && _b !== void 0 ? _b : '']) && ((_c = this.formData.formQuestions) === null || _c === void 0 ? void 0 : _c[index])) {
                            this.formData.formQuestions[index].text = (_d = question.formPrepopulatedAnswer) === null || _d === void 0 ? void 0 : _d[(_e = formItem.id) !== null && _e !== void 0 ? _e : ''];
                        }
                    });
                }
            });
        };
        this.getNextQuestion = (isSkip = false) => __awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const question = this.question;
            const consumerData = this.consumerData;
            if (!consumerData || !question) {
                return Promise.reject('unknown error');
            }
            this.isQuestionLoading = true;
            const answer = isSkip
                ? undefined
                : yield getAnswer(this.formData, question.nodeContent);
            const formAnswer = isSkip
                ? undefined
                : yield getFormAnswer(this.formData, question.nodeContent);
            const answerForChat = isSkip
                ? undefined
                : yield getAnswerForChat(this.formData, question.nodeContent);
            const formAnswerForChat = isSkip
                ? undefined
                : yield getFormAnswerForChat(this.formData, question.nodeContent);
            let nextQuestionPromise;
            switch (consumerData.mode) {
                case ConsumerMode.DRY_RUN:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.getDryRunNextQuestion(Object.assign(Object.assign({ currentQuestionNodeId: question.nodeId }, answer), { formResponseDTOHashMap: formAnswer, flowType: consumerData.flowType, feedBackSessionId: question.sessionId, questionnareId: (_a = consumerData.questionnaireId) !== null && _a !== void 0 ? _a : '', isSkipped: isSkip }));
                    break;
                case ConsumerMode.UNIVERSE:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.getUniverseQuestionnaireNextQuestion(consumerData.flowType, Object.assign(Object.assign({ currentQuestionNodeId: question.nodeId }, answer), { formResponseDTOHashMap: formAnswer, flowType: consumerData.flowType, feedBackSessionId: question.sessionId, questionnareId: consumerData.questionnaireId, isSkipped: isSkip }));
                    break;
                case ConsumerMode.WEB_CONSUMER:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.getWebConsumerNextQuestion(Object.assign(Object.assign({ currentQuestionNodeId: question.nodeId }, answer), { formResponseDTOHashMap: formAnswer, flowType: consumerData.flowType, feedBackSessionId: question.sessionId, questionnareId: (_b = consumerData.questionnaireId) !== null && _b !== void 0 ? _b : '', isSkipped: isSkip }));
                    break;
                case ConsumerMode.SDK_CONSUMER:
                    nextQuestionPromise =
                        this.questionnaireConsumerService.getSDKConsumerNextQuestion(Object.assign(Object.assign({ currentQuestionNodeId: question.nodeId }, answer), { formResponseDTOHashMap: formAnswer, flowType: FlowType.QUESTIONNAIRE, feedBackSessionId: question.sessionId, questionnareId: question.questionnareId, isSkipped: isSkip }));
                    break;
            }
            if (this.question) {
                this.existingElements.push(this.question);
                if (this.question.nodeContent.nodeType === NodeType.FORM) {
                    this.existingElementsAnswer.push(formAnswerForChat !== null && formAnswerForChat !== void 0 ? formAnswerForChat : '');
                }
                else {
                    this.existingElementsAnswer.push(answerForChat !== null && answerForChat !== void 0 ? answerForChat : '');
                }
            }
            return this.applyNextQuestionPromise(nextQuestionPromise).then((question) => {
                var _a;
                if (question === null || question === void 0 ? void 0 : question.prepopulatedAnswer) {
                    this.formData.text = question.prepopulatedAnswer;
                }
                else if (((_a = question === null || question === void 0 ? void 0 : question.nodeContent) === null || _a === void 0 ? void 0 : _a.nodeType) === NodeType.FORM) {
                    question.nodeContent.formItems.forEach((formItem, index) => {
                        var _a, _b, _c, _d, _e;
                        if (formItem.nodeContent.nodeType === NodeType.QUESTION && ((_a = question.formPrepopulatedAnswer) === null || _a === void 0 ? void 0 : _a[(_b = formItem.id) !== null && _b !== void 0 ? _b : '']) && ((_c = this.formData.formQuestions) === null || _c === void 0 ? void 0 : _c[index])) {
                            this.formData.formQuestions[index].text = (_d = question.formPrepopulatedAnswer) === null || _d === void 0 ? void 0 : _d[(_e = formItem.id) !== null && _e !== void 0 ? _e : ''];
                        }
                    });
                }
                this.prefillResponses(question);
            });
        });
        this.skipQuestion = () => {
            return this.getNextQuestion(true);
        };
        this.nextQuestion = () => {
            return this.getNextQuestion(false);
        };
        this.closeConsumer = (finishedSuccessfully = false) => {
            var _a, _b, _c;
            const question = this.question;
            const consumerData = this.consumerData;
            if (finishedSuccessfully) {
                this.consumerState = ConsumerState.NOT_RUNNING;
                this.consumerData = undefined;
                this.isQuestionLoading = false;
                this.question = null;
                this.error = null;
                return;
            }
            this.isQuestionLoading = true;
            this.questionnaireConsumerService
                .exitQuestionnaire({
                currentQuestionNodeId: (_a = question === null || question === void 0 ? void 0 : question.nodeId) !== null && _a !== void 0 ? _a : 'INVALID',
                formResponseDTOHashMap: undefined,
                flowType: FlowType.QUESTIONNAIRE,
                feedBackSessionId: (_b = question === null || question === void 0 ? void 0 : question.sessionId) !== null && _b !== void 0 ? _b : 'INVALID',
                questionnareId: (_c = question === null || question === void 0 ? void 0 : question.questionnareId) !== null && _c !== void 0 ? _c : 'INVALID',
                isSkipped: false,
            })
                // Why ????
                .then(() => {
                this.consumerState = ConsumerState.NOT_RUNNING;
                this.consumerData = undefined;
                this.isQuestionLoading = false;
                this.question = null;
                this.error = null;
            })
                .catch(() => {
                this.consumerState = ConsumerState.NOT_RUNNING;
                this.consumerData = undefined;
                this.isQuestionLoading = false;
                this.question = null;
                this.error = null;
            });
        };
        this.onSCQOptionChanged = (value) => {
            var _a;
            this.formData.scqOption = parseInt(value);
            if (((_a = this.question) === null || _a === void 0 ? void 0 : _a.nodeContent.nodeType) === NodeType.QUESTION &&
                this.question.nodeContent.questionType === QuestionType.OPTIONS &&
                this.question.nodeContent.optionType === OptionType.SINGLE &&
                this.question.nodeContent.isPassthroughAllowed) {
                this.nextQuestion();
            }
        };
        this.toggleMCQOption = (value) => {
            const mcqOptions = this.formData.mcqOptions;
            const index = mcqOptions.indexOf(value);
            if (index === -1)
                mcqOptions.push(value);
            else
                mcqOptions.splice(index, 1);
        };
        this.setMCQOptions = (indices) => {
            this.formData.mcqOptions = indices;
        };
        this.setMatrixOptions = (rowIndex, value, optionType) => {
            var _a, _b;
            if (optionType === OptionType.SINGLE) {
                this.formData.matrixOptions = Object.assign(Object.assign({}, this.formData.matrixOptions), { [rowIndex]: [value] });
                if ((_a = this.question) === null || _a === void 0 ? void 0 : _a.nodeContent.isPassthroughAllowed) {
                    let numRows = 0;
                    if (((_b = this.question) === null || _b === void 0 ? void 0 : _b.nodeContent.nodeType) === NodeType.QUESTION &&
                        this.question.nodeContent.questionType === QuestionType.MATRIX) {
                        numRows = this.question.nodeContent.rows.length;
                    }
                    if (Object.keys(this.formData.matrixOptions).length === numRows) {
                        this.nextQuestion();
                    }
                }
            }
            else if (optionType === OptionType.MULTIPLE) {
                if (!this.formData.matrixOptions[rowIndex]) {
                    this.formData.matrixOptions = Object.assign(Object.assign({}, this.formData.matrixOptions), { [rowIndex]: [] });
                }
                const index = this.formData.matrixOptions[rowIndex].indexOf(value);
                if (index === -1)
                    this.formData.matrixOptions[rowIndex].push(value);
                else
                    this.formData.matrixOptions[rowIndex].splice(index, 1);
            }
        };
        this.onRankingOptionSwapped = (from, to) => {
            var _a, _b, _c, _d, _e, _f, _g;
            if (((_a = this.question) === null || _a === void 0 ? void 0 : _a.nodeContent.nodeType) === NodeType.QUESTION &&
                ((_b = this.question) === null || _b === void 0 ? void 0 : _b.nodeContent.questionType) === QuestionType.OPTIONS &&
                ((_c = this.question) === null || _c === void 0 ? void 0 : _c.nodeContent.optionType) === OptionType.RANKING) {
                (_e = (_d = this.question) === null || _d === void 0 ? void 0 : _d.nodeContent) === null || _e === void 0 ? void 0 : _e.options.splice(to, 0, (_g = (_f = this.question) === null || _f === void 0 ? void 0 : _f.nodeContent) === null || _g === void 0 ? void 0 : _g.options.splice(from, 1)[0]);
            }
        };
        this.onTextChange = (text) => {
            var _a, _b;
            if ((_a = this.question) === null || _a === void 0 ? void 0 : _a.nodeContent.isPassthroughAllowed) {
                if (this.question.nodeContent.nodeType === NodeType.QUESTION &&
                    this.question.nodeContent.questionType === QuestionType.TEXT &&
                    this.question.nodeContent.qualitativeType === QualitativeType.PHONE &&
                    text.length === 10 &&
                    this.formData.text !== text) {
                    this.formData.text = text;
                    this.nextQuestion();
                }
                if (this.question.nodeContent.nodeType === NodeType.QUESTION &&
                    this.question.nodeContent.questionType === QuestionType.TEXT &&
                    this.question.nodeContent.qualitativeType === QualitativeType.NUMERIC &&
                    ((_b = this.question.nodeContent.noOfDigits) !== null && _b !== void 0 ? _b : 0) > 0 &&
                    text.length === this.question.nodeContent.noOfDigits) {
                    this.formData.text = text;
                    this.nextQuestion();
                }
            }
            this.formData.text = text;
        };
        this.onRatingChange = (rating) => {
            var _a;
            this.formData.rating = rating;
            if (((_a = this.question) === null || _a === void 0 ? void 0 : _a.nodeContent.nodeType) === NodeType.QUESTION &&
                this.question.nodeContent.questionType === QuestionType.RATING &&
                this.question.nodeContent.isPassthroughAllowed) {
                this.nextQuestion();
            }
        };
        this.onAudioRecordingChanged = (data) => {
            this.formData.audioRecordingData = data;
        };
        this.onFileChanged = (file) => {
            this.formData.fileUpload = file;
        };
        this.onVideoRecordingChanged = (data) => {
            this.formData.videoRecordingData = data;
        };
        this.onImageRecordingChanged = (data) => {
            this.formData.imageRecordingData = data;
        };
        this.onDateChanged = (date) => {
            this.formData.date = date;
        };
        this.onUXPathResponseChanged = (data) => {
            this.formData.uxXPathResponse = data !== null && data !== void 0 ? data : '';
        };
        this.onUXTextResponseChanged = (data) => {
            this.formData.uxTextResponse = data !== null && data !== void 0 ? data : '';
        };
        this.onUXUserVideoResponseChanged = (data) => {
            this.formData.uxUserVideoResponse = data;
        };
        this.onUXUserImageResponseChanged = (data) => {
            this.formData.uxUserImageResponse = data;
        };
        this.onTimeChanged = (date) => {
            this.formData.time = date;
        };
        this.onFormQuestionsChange = (questions) => {
            this.formData.formQuestions = questions;
        };
        this.initializeFormQuestions = (formItems) => {
            this.formData.formQuestions = formItems.map((formItem) => {
                if (formItem.nodeContent.nodeType === NodeType.QUESTION &&
                    formItem.nodeContent.questionType === QuestionType.OPTIONS &&
                    formItem.nodeContent.optionType === OptionType.RANKING) {
                    return getEmptyQuestionnaireConsumerData(formItem.nodeContent.options);
                }
                return getEmptyQuestionnaireConsumerData();
            });
        };
        this.getVarConfig = (name) => {
            var _a, _b;
            const variables = (_b = (_a = this.questionnaireResponse.data) === null || _a === void 0 ? void 0 : _a.questionnare.variables) !== null && _b !== void 0 ? _b : [];
            const variableConfig = variables.find((it) => it.variableName === name);
            if (!variableConfig) {
                return undefined;
            }
            const type = variableConfig.variableType;
            switch (type) {
                case ContextVariableType.STRING:
                    return {
                        name: name,
                        variableType: VariableType.STRING,
                        string: '',
                    };
                case ContextVariableType.INTEGER:
                    return {
                        name: name,
                        variableType: VariableType.DOUBLE,
                        number: 0,
                    };
                case ContextVariableType.REAL:
                    return {
                        name: name,
                        variableType: VariableType.DOUBLE,
                        number: 0,
                    };
                case ContextVariableType.BOOLEAN:
                    return {
                        name: name,
                        variableType: VariableType.STRING,
                        string: 'true',
                    };
                case ContextVariableType.DATE:
                    return {
                        name: name,
                        variableType: VariableType.DOUBLE,
                        number: 0,
                    };
                case ContextVariableType.TIME:
                    return {
                        name: name,
                        variableType: VariableType.DOUBLE,
                        number: 0,
                    };
                case ContextVariableType.DATE_TIME:
                    return {
                        name: name,
                        variableType: VariableType.DOUBLE,
                        number: 0,
                    };
                case ContextVariableType.IMAGE:
                    return {
                        name: name,
                        variableType: VariableType.STRING,
                        string: '',
                    };
                case ContextVariableType.VIDEO:
                    return {
                        name: name,
                        variableType: VariableType.STRING,
                        string: '',
                    };
                case ContextVariableType.LIST_STRING:
                    return {
                        name: name,
                        variableType: VariableType.LIST_STRING,
                        stringsList: [],
                    };
                case ContextVariableType.LIST_INTEGER:
                    return {
                        name: name,
                        variableType: VariableType.LIST_DOUBLE,
                        numbersList: [],
                    };
                case ContextVariableType.LIST_REAL:
                    return {
                        name: name,
                        variableType: VariableType.LIST_DOUBLE,
                        numbersList: [],
                    };
                case ContextVariableType.CATEGORY:
                    return {
                        name: name,
                        variableType: VariableType.STRING,
                        string: '',
                    };
            }
            return undefined;
        };
        this.changeContextVarValue = (config, index) => {
            this.contextVars[index] = config;
        };
        this.changeContentVarValue = (config, index) => {
            this.contentVars[index] = config;
        };
        this.abortControllers = new Map();
        this.reactionDisposers = [];
        this.addReactions();
    }
    get customCSS() {
        var _a, _b;
        return (_b = (_a = this.question) === null || _a === void 0 ? void 0 : _a.customCSS) !== null && _b !== void 0 ? _b : '';
    }
    get isRunning() {
        return this.consumerState !== ConsumerState.NOT_RUNNING;
    }
    applyNextQuestionPromise(nextQuestionPromise) {
        return __awaiter(this, void 0, void 0, function* () {
            this.onNextQuestion(this.question, true, null);
            try {
                const nextQuestion = yield nextQuestionPromise;
                if (nextQuestion.sessionStatus === SessionStatus.COMPLETED) {
                    this.closeConsumer(true);
                    return nextQuestion;
                }
                this.formData = getEmptyQuestionnaireConsumerData();
                this.onNextQuestion(nextQuestion, false, null);
                runInAction(() => {
                    if (nextQuestion.displayStyle) {
                        this.displayConfig = {
                            displayPosition: nextQuestion.displayPosition,
                            displayAfterTime: nextQuestion.displayAfterTime,
                            webURLMatchesString: nextQuestion.webURLMatchesString,
                            webScrollTillPercentage: nextQuestion.webScrollTillPercentage,
                            displayStyle: nextQuestion.displayStyle,
                            chatDistributionSettings: nextQuestion.chatDistributionSettings,
                            displayType: nextQuestion.displayType,
                        };
                    }
                });
                return nextQuestion;
            }
            catch (e) {
                this.formData = getEmptyQuestionnaireConsumerData();
                this.onNextQuestion(null, false, e);
                return Promise.reject(e);
            }
        });
    }
    startDryRun(consumerData) {
        var _a;
        const context = this.contextVars
            .filter(isVariableValid)
            .reduce((acc, curr) => {
            const { name } = curr, value = __rest(curr, ["name"]);
            acc[name.replace(/^\$/, '')] = value;
            return acc;
        }, {});
        const allContentVarsValues = this.contentVars.reduce((acc, it) => {
            var _a, _b, _c;
            if (it.name) {
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                const itAny = it;
                acc[it.name] = {
                    value: itAny.string || ((_a = itAny.number) === null || _a === void 0 ? void 0 : _a.toString()) || ((_b = itAny.stringsList) === null || _b === void 0 ? void 0 : _b.join(', ')) || ((_c = itAny.numbersList) === null || _c === void 0 ? void 0 : _c.map((it) => it.toString()).join(', ')) ||
                        '',
                    trackId: '',
                    tagName: '',
                };
            }
            return acc;
        }, {});
        return this.questionnaireConsumerService.startDryRun({
            allContentVarsValues: allContentVarsValues,
            workspaceId: consumerData.workspaceId,
            context,
            flowType: consumerData.flowType,
            questionnareId: (_a = consumerData.questionnaireId) !== null && _a !== void 0 ? _a : '',
        });
    }
    addReactions() {
        this.addQuestionnaireReaction();
        const contentVarsDisposer = reaction(() => this.questionnaireResponse.data, (data) => {
            var _a;
            const nodes = (_a = data === null || data === void 0 ? void 0 : data.nodes) !== null && _a !== void 0 ? _a : [];
            const contentVarNames = new Set();
            nodes.forEach((it) => {
                return it.nodeContent.contentVars.forEach((variable) => contentVarNames.add(variable));
            });
            this.contentVars = Array.from(contentVarNames)
                .map((name) => this.getVarConfig(name))
                .filter(isNotNullOrUndefined);
        }, { fireImmediately: true });
        this.reactionDisposers.push(contentVarsDisposer);
        const contextVarsDisposer = reaction(() => this.questionnaireResponse.data, (data) => {
            var _a;
            const conditionalNodes = (_a = data === null || data === void 0 ? void 0 : data.nodes.filter((node) => node.nodeRepresentation === NodeRepresentation.NODE &&
                node.nodeContent.nodeType === NodeType.CONDITIONAL)) !== null && _a !== void 0 ? _a : [];
            const contextVarNames = new Set();
            conditionalNodes.forEach((it) => {
                const nodeContent = it.nodeContent;
                const match = nodeContent.content.match(CONTEXT_VARIABLE_REGEX);
                match === null || match === void 0 ? void 0 : match.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
            });
            data === null || data === void 0 ? void 0 : data.nodes.forEach((it) => {
                var _a, _b, _c, _d, _e;
                const nodeContent = it.nodeContent;
                // This gives qualitative prepopulate answer values
                if (nodeContent.nodeType === NodeType.QUESTION &&
                    nodeContent.questionType === QuestionType.TEXT &&
                    nodeContent.prePopulateAnswerType === PrePopulateAnswerType.VARIABLE) {
                    if ((_a = nodeContent.prePopulateAnswerValue) === null || _a === void 0 ? void 0 : _a.startsWith('_')) {
                    }
                    else {
                        contextVarNames.add(nodeContent.prePopulateAnswerValue);
                    }
                }
                // This gives form qualitative prepopulate answer values
                if (nodeContent.nodeType === NodeType.FORM) {
                    nodeContent.formItems.forEach((formItem) => {
                        var _a;
                        if (formItem.nodeContent.nodeType === NodeType.QUESTION &&
                            formItem.nodeContent.questionType === QuestionType.TEXT &&
                            formItem.nodeContent.prePopulateAnswerType ===
                                PrePopulateAnswerType.VARIABLE) {
                            if ((_a = formItem.nodeContent.prePopulateAnswerValue) === null || _a === void 0 ? void 0 : _a.startsWith('_')) {
                            }
                            else {
                                contextVarNames.add(formItem.nodeContent.prePopulateAnswerValue);
                            }
                        }
                    });
                }
                // Adding Node Display Logic Vars
                const nodeDisplayLogicMatches = (_c = (_b = nodeContent.displayLogic) === null || _b === void 0 ? void 0 : _b.match(CONTEXT_VARIABLE_REGEX)) !== null && _c !== void 0 ? _c : [];
                nodeDisplayLogicMatches === null || nodeDisplayLogicMatches === void 0 ? void 0 : nodeDisplayLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                const nodeSkipLogicMatches = (_e = (_d = nodeContent.skipLogic) === null || _d === void 0 ? void 0 : _d.match(CONTEXT_VARIABLE_REGEX)) !== null && _e !== void 0 ? _e : [];
                nodeSkipLogicMatches === null || nodeSkipLogicMatches === void 0 ? void 0 : nodeSkipLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                // This gives option display logic
                if (nodeContent.nodeType === NodeType.QUESTION &&
                    nodeContent.questionType === QuestionType.OPTIONS) {
                    nodeContent.options.forEach((option) => {
                        var _a, _b, _c, _d;
                        const optionDisplayLogicMatches = (_b = (_a = option.displayLogic) === null || _a === void 0 ? void 0 : _a.match(CONTEXT_VARIABLE_REGEX)) !== null && _b !== void 0 ? _b : [];
                        optionDisplayLogicMatches === null || optionDisplayLogicMatches === void 0 ? void 0 : optionDisplayLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                        const optionSkipLogicMatches = (_d = (_c = option.skipLogic) === null || _c === void 0 ? void 0 : _c.match(CONTEXT_VARIABLE_REGEX)) !== null && _d !== void 0 ? _d : [];
                        optionSkipLogicMatches === null || optionSkipLogicMatches === void 0 ? void 0 : optionSkipLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                    });
                }
                // This gives form item display logic
                if (nodeContent.nodeType === NodeType.FORM) {
                    nodeContent.formItems.forEach((formItem) => {
                        var _a, _b, _c, _d;
                        const formItemDisplayLogicMatches = (_b = (_a = formItem.nodeContent.displayLogic) === null || _a === void 0 ? void 0 : _a.match(CONTEXT_VARIABLE_REGEX)) !== null && _b !== void 0 ? _b : [];
                        formItemDisplayLogicMatches === null || formItemDisplayLogicMatches === void 0 ? void 0 : formItemDisplayLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                        const formItemSkipLogicMatches = (_d = (_c = formItem.nodeContent.skipLogic) === null || _c === void 0 ? void 0 : _c.match(CONTEXT_VARIABLE_REGEX)) !== null && _d !== void 0 ? _d : [];
                        formItemSkipLogicMatches === null || formItemSkipLogicMatches === void 0 ? void 0 : formItemSkipLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                        // This gives form item option display logic
                        if (formItem.nodeContent.nodeType === NodeType.QUESTION &&
                            formItem.nodeContent.questionType === QuestionType.OPTIONS) {
                            formItem.nodeContent.options.forEach((option) => {
                                var _a, _b, _c, _d;
                                const optionDisplayLogicMatches = (_b = (_a = option.displayLogic) === null || _a === void 0 ? void 0 : _a.match(CONTEXT_VARIABLE_REGEX)) !== null && _b !== void 0 ? _b : [];
                                optionDisplayLogicMatches === null || optionDisplayLogicMatches === void 0 ? void 0 : optionDisplayLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                                const optionSkipLogicMatches = (_d = (_c = option.skipLogic) === null || _c === void 0 ? void 0 : _c.match(CONTEXT_VARIABLE_REGEX)) !== null && _d !== void 0 ? _d : [];
                                optionSkipLogicMatches === null || optionSkipLogicMatches === void 0 ? void 0 : optionSkipLogicMatches.forEach((variable) => contextVarNames.add(variable.replace('$', '')));
                            });
                        }
                    });
                }
            });
            this.contextVars = Array.from(contextVarNames)
                .map((name) => this.getVarConfig(name))
                .filter(isNotNullOrUndefined);
        }, { fireImmediately: true });
        this.reactionDisposers.push(contextVarsDisposer);
    }
    addQuestionnaireReaction() {
        const questionnaireDisposer = reaction(() => {
            var _a;
            return ((_a = this.consumerData) === null || _a === void 0 ? void 0 : _a.mode) === ConsumerMode.DRY_RUN
                ? this.consumerData.questionnaireId
                : undefined;
        }, () => {
            var _a;
            const CONTROLLER_NAME = 'questionnaire';
            const prevController = this.abortControllers.get(CONTROLLER_NAME);
            if (prevController) {
                prevController.abort();
                this.abortControllers.delete(CONTROLLER_NAME);
            }
            if (((_a = this.consumerData) === null || _a === void 0 ? void 0 : _a.mode) !== ConsumerMode.DRY_RUN) {
                applyNetworkResponse(this.questionnaireResponse, false, null, null);
                return;
            }
            if (this.consumerData.questionnaireDTO) {
                applyNetworkResponse(this.questionnaireResponse, false, this.consumerData.questionnaireDTO, null);
                return;
            }
            // This is not used anywhere
            // const abortController = new AbortController();
            // applyNetworkResponseForPromise(
            //   this.questionnaireResponse,
            //   this.questionnaireConsumerService.getEditQuestionnaireData(
            //     '',
            //     this.consumerData.questionnaireId ?? '',
            //     abortController.signal
            //   )
            // );
            // this.abortControllers.set(CONTROLLER_NAME, abortController);
        }, { fireImmediately: true });
        this.reactionDisposers.push(questionnaireDisposer);
    }
    destructor() {
        this.abortControllers.forEach((ctrl) => ctrl.abort());
        this.reactionDisposers.forEach((dispose) => dispose());
    }
}
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "consumerState", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "consumerData", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "question", void 0);
__decorate([
    computed,
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [])
], ConsumerStore.prototype, "customCSS", null);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "isQuestionLoading", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "error", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "formData", void 0);
__decorate([
    observable,
    __metadata("design:type", Array)
], ConsumerStore.prototype, "contextVars", void 0);
__decorate([
    observable,
    __metadata("design:type", Array)
], ConsumerStore.prototype, "contentVars", void 0);
__decorate([
    observable,
    __metadata("design:type", Array)
], ConsumerStore.prototype, "existingElements", void 0);
__decorate([
    observable,
    __metadata("design:type", Array)
], ConsumerStore.prototype, "existingElementsAnswer", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "displayConfig", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "keyMapHandler", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "questionnaireResponse", void 0);
__decorate([
    computed,
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [])
], ConsumerStore.prototype, "isRunning", null);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "updateKeyMap", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "addToExistingElements", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "addToExistingElementsAnswer", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "resetConsumer", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "initiateConsumer", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onNextQuestion", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "setAnswersOnRevisit", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "navigateBack", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "navigateForward", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "getFirstQuestion", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "getNextQuestion", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "skipQuestion", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "nextQuestion", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "closeConsumer", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onSCQOptionChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "toggleMCQOption", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "setMCQOptions", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "setMatrixOptions", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onRankingOptionSwapped", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onTextChange", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onRatingChange", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onAudioRecordingChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onFileChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onVideoRecordingChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onImageRecordingChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onDateChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onUXPathResponseChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onUXTextResponseChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onUXUserVideoResponseChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onUXUserImageResponseChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onTimeChanged", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "onFormQuestionsChange", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "initializeFormQuestions", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "getVarConfig", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "changeContextVarValue", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], ConsumerStore.prototype, "changeContentVarValue", void 0);
//# sourceMappingURL=ConsumerStore.js.map