import { AllowedResponseType, ContentNodeContent, ContextVariable, FormResponseDTO, NodeContent, TextQuestionNodeContent, Option, SignatureNodeContent, SignatureAllowedResponseType } from '@fashtag/common/dist/models';
import { AnswerObject, ConsumerValidVarConfig, ConsumerVarConfig, QuestionnaireConsumerFormData } from '../models/ConsumerModels';
export declare function getContentForEdit(nodeContent: {
    content?: string;
    imageUrl?: string;
    videoUrl?: string;
}, variables: ContextVariable[]): {
    text: string;
    imageConfig: {
        imageUrl: string | undefined;
        imageVariable: string;
        videoVariable: string;
        videoUrl: string | undefined;
    };
};
export declare function getEmptyQuestionnaireConsumerData(rankingOption?: Option[]): QuestionnaireConsumerFormData;
export declare function isResponseTypeAllowed(nodeContent: TextQuestionNodeContent, type: AllowedResponseType): boolean;
export declare function isSignatureResponseTypeAllowed(nodeContent: SignatureNodeContent, type: SignatureAllowedResponseType): boolean;
export declare function getAnswerForChat(questionnaireConsumerFormData: QuestionnaireConsumerFormData, nodeContent: NodeContent): Promise<string>;
export declare function getFormAnswerForChat(questionnaireConsumerFormData: QuestionnaireConsumerFormData, nodeContent: NodeContent): Promise<string>;
export declare function getAnswer(questionnaireConsumerFormData: QuestionnaireConsumerFormData, nodeContent: NodeContent): Promise<AnswerObject | undefined>;
export declare function getFormAnswer(questionnaireConsumerFormData: QuestionnaireConsumerFormData, nodeContent: NodeContent): Promise<Record<string, FormResponseDTO> | undefined>;
export declare function isVariableValid(config: ConsumerVarConfig): config is ConsumerValidVarConfig;
export declare function getContent(nodeContent: ContentNodeContent): string;
