"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerDisplayWrapper = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const react_1 = tslib_1.__importStar(require("react"));
const Consumer_1 = require("./consumer/Consumer");
exports.ConsumerDisplayWrapper = (props) => {
    const { onExit, isChatStyleEnabled, chatSettings, customCSSProps } = props;
    const displayConfig = common_1.useSelector((store) => store.consumerStore.displayConfig);
    const [isToggledOn, toggle] = react_1.useState(false);
    const [hasBeenClosedOnce, setHasBeenClosedOnce] = react_1.useState(false);
    react_1.useEffect(() => {
        if (displayConfig.displayType &&
            [models_1.DisplayType.BUBBLE, models_1.DisplayType.SIDE_TAB, models_1.DisplayType.DIALOG].includes(displayConfig.displayType)) {
            const displayAfterTime = displayConfig.displayAfterTime;
            const webScrollTillPercentage = displayConfig.webScrollTillPercentage;
            const webURLMatchesString = displayConfig.webURLMatchesString;
            if (!displayAfterTime &&
                !webScrollTillPercentage &&
                !webURLMatchesString &&
                displayConfig.displayType === models_1.DisplayType.DIALOG) {
                toggle(true);
                return;
            }
            if (!hasBeenClosedOnce &&
                !isToggledOn &&
                (displayAfterTime || webScrollTillPercentage || webURLMatchesString)) {
                if (displayAfterTime) {
                    setTimeout(() => {
                        if (!isToggledOn && !hasBeenClosedOnce)
                            toggle(true);
                    }, displayAfterTime * 1000);
                }
                if (webURLMatchesString) {
                    if (window.location.href.includes(webURLMatchesString) &&
                        !isToggledOn &&
                        !hasBeenClosedOnce) {
                        toggle(true);
                    }
                }
                if (webScrollTillPercentage) {
                    setInterval(() => {
                        const scrollPercentage = (window.scrollY * 100) / window.innerHeight;
                        if (scrollPercentage >= webScrollTillPercentage &&
                            !isToggledOn &&
                            !hasBeenClosedOnce) {
                            toggle(true);
                        }
                    }, 2000);
                }
            }
        }
    }, [
        displayConfig.displayAfterTime,
        displayConfig.displayType,
        displayConfig.webScrollTillPercentage,
        displayConfig.webURLMatchesString,
        hasBeenClosedOnce,
        isToggledOn,
    ]);
    if (displayConfig.displayType === models_1.DisplayType.FULL_SCREEN) {
        return (react_1.default.createElement("div", { style: { width: '100vw', height: '100vh' } },
            react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })));
    }
    else if (displayConfig.displayType === models_1.DisplayType.EMBED) {
        return (react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
    }
    else if (displayConfig.displayType === models_1.DisplayType.POPUP) {
        return (react_1.default.createElement("div", { style: {
                width: 320,
                height: 480,
                padding: 4,
                borderRadius: 8,
                position: 'absolute',
                boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
            } },
            react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })));
    }
    else if (displayConfig.displayType === models_1.DisplayType.BUBBLE) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    backgroundColor: 'rgb(4, 69, 175)',
                    cursor: 'pointer',
                    border: 0,
                    textDecoration: 'none',
                    outline: 'none',
                    position: 'fixed',
                    zIndex: 2147483003,
                    bottom: 20,
                    right: displayConfig.displayPosition === models_1.DisplayPosition.BOTTOM_RIGHT
                        ? 20
                        : 'unset',
                    left: displayConfig.displayPosition === models_1.DisplayPosition.BOTTOM_LEFT
                        ? 20
                        : 'unset',
                    width: 60,
                    height: 60,
                    borderRadius: '50%',
                    background: '#3047EC',
                    boxShadow: '0 1px 6px 0 rgb(0 0 0 / 6%), 0 2px 32px 0 rgb(0 0 0 / 16%)',
                    lineHeight: '60px',
                    justifyContent: 'center',
                    color: 'white',
                    fontSize: 36,
                }, onClick: () => {
                    if (isToggledOn) {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }
                    else {
                        toggle(true);
                    }
                } }, isToggledOn ? 'x' : '^'),
            isToggledOn && (react_1.default.createElement("div", { style: {
                    width: 320,
                    height: 640,
                    padding: 4,
                    borderRadius: 8,
                    position: 'fixed',
                    boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
                    zIndex: 2147483003,
                    bottom: 90,
                    right: displayConfig.displayPosition === models_1.DisplayPosition.BOTTOM_RIGHT
                        ? 20
                        : 'unset',
                    left: displayConfig.displayPosition === models_1.DisplayPosition.BOTTOM_LEFT
                        ? 20
                        : 'unset',
                } },
                react_1.default.createElement(Consumer_1.Consumer, { onExit: () => {
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })))));
    }
    else if (displayConfig.displayType === models_1.DisplayType.SIDE_TAB) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            !isToggledOn && (react_1.default.createElement("div", { style: {
                    position: 'fixed',
                    top: '50%',
                    right: '-60px',
                    transform: 'rotate(-90deg) translateY(-50%)',
                    transformOrigin: 'center center',
                    height: '48px',
                    display: 'flex',
                    alignItems: 'center',
                    padding: '0 16px',
                    borderRadius: '8px 8px 0 0',
                    color: 'white',
                    boxShadow: '0 2px 4px rgb(0 0 0 / 8%), 0 2px 12px rgb(0 0 0 / 6%)',
                    backgroundColor: 'rgb(4, 69, 175)',
                    cursor: 'pointer',
                    border: 0,
                    textDecoration: 'none',
                    outline: 'none',
                }, onClick: () => toggle(true) }, "Start Survey")),
            isToggledOn && (react_1.default.createElement("div", { style: {
                    width: 320,
                    height: 480,
                    padding: 4,
                    top: '50%',
                    right: 0,
                    borderRadius: 8,
                    position: 'fixed',
                    boxShadow: 'rgba(0, 0, 0, 0.35) 0px 5px 15px',
                    transform: 'translateY(-50%)',
                } },
                react_1.default.createElement(Consumer_1.Consumer, { onExit: () => {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps })))));
    }
    else if (displayConfig.displayType === models_1.DisplayType.DIALOG) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(core_1.Dialog, { fullWidth: true, maxWidth: "lg", open: isToggledOn, onClose: () => {
                    setHasBeenClosedOnce(true);
                    toggle(false);
                    onExit === null || onExit === void 0 ? void 0 : onExit();
                } },
                react_1.default.createElement(Consumer_1.Consumer, { onExit: () => {
                        setHasBeenClosedOnce(true);
                        toggle(false);
                        onExit === null || onExit === void 0 ? void 0 : onExit();
                    }, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }))));
    }
    return (react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
};
//# sourceMappingURL=ConsumerDisplayWrapper.js.map