"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerWebSDK = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const react_1 = tslib_1.__importStar(require("react"));
const ConsumerModels_1 = require("../models/ConsumerModels");
const Consumer_1 = require("./consumer/Consumer");
const ConsumerDisplayWrapper_1 = require("./ConsumerDisplayWrapper");
exports.ConsumerWebSDK = (props) => {
    const { initData, onExit } = props;
    const { initiateConsumer, displayConfig } = common_1.useSelector((store) => {
        return {
            initiateConsumer: store.consumerStore.initiateConsumer,
            displayConfig: store.consumerStore.displayConfig,
        };
    });
    react_1.useEffect(() => {
        var _a, _b;
        initiateConsumer({
            mode: ConsumerModels_1.ConsumerMode.SDK_CONSUMER,
            initData: Object.assign(Object.assign({}, initData), { sessionStatus: models_1.SessionStatus.CREATED, distributionType: (_a = initData.distributionType) !== null && _a !== void 0 ? _a : models_1.DistributionType.WEB_EMBED, context: (_b = initData.context) !== null && _b !== void 0 ? _b : {}, allContentVarsValues: {}, flowType: models_1.FlowType.QUESTIONNAIRE, isDryRun: false }),
        });
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [initData]);
    if (!initData.questionnaireId &&
        (!initData.questionnaireTags || initData.questionnaireTags.length === 0)) {
        throw new Error('Either questionnaire id or tags is required');
    }
    if (initData.distributionType === models_1.DistributionType.WEB_EMBED) {
        return (react_1.default.createElement(ConsumerDisplayWrapper_1.ConsumerDisplayWrapper, { onExit: onExit, isChatStyleEnabled: displayConfig.displayStyle === models_1.DisplayStyle.CHAT, chatSettings: displayConfig.chatDistributionSettings }));
    }
    else
        return (react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: displayConfig.displayStyle === models_1.DisplayStyle.CHAT, chatSettings: displayConfig.chatDistributionSettings }));
};
//# sourceMappingURL=ConsumerWebSDK.js.map