"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerWrapper = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const react_1 = tslib_1.__importStar(require("react"));
const Consumer_1 = require("./consumer/Consumer");
exports.ConsumerWrapper = (props) => {
    const { consumerData, onExit, isChatStyleEnabled, chatSettings, customCSSProps = { isEditorOpen: false }, } = props;
    const initiateConsumer = common_1.useSelector((store) => {
        return store.consumerStore.initiateConsumer;
    });
    react_1.useEffect(() => {
        initiateConsumer(consumerData);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [consumerData]);
    return (react_1.default.createElement(Consumer_1.Consumer, { onExit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, customCSSProps: customCSSProps }));
};
//# sourceMappingURL=ConsumerWrapper.js.map