"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Consumer = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const common_1 = require("@fashtag/common");
const ConsumerModels_1 = require("../../models/ConsumerModels");
const VariableSelector_1 = require("./VariableSelector");
const core_1 = require("@material-ui/core");
const ConsumerNode_1 = require("./ConsumerNode");
const pickers_1 = require("@material-ui/pickers");
const date_fns_1 = tslib_1.__importDefault(require("@date-io/date-fns"));
const react_hotkeys_1 = require("react-hotkeys");
const keyMap = {
    MOVE_UP: 'up',
    SELECT_OPTION: [...'abcdefghijklmnopqrtuvwxyzABCDEFGHIJKLMNOPQRTUVWXYZ'],
    ENTER: 'enter',
    BACK: 'up',
    FORWARD: 'down',
    SKIP: ['s', 'S'],
};
exports.Consumer = (props) => {
    var _a;
    const { onExit, isChatStyleEnabled, chatSettings, customCSSProps = { isEditorOpen: false }, } = props;
    const prevConsumerState = react_1.useRef();
    const { consumerState, startConsumer, keyMapHandler, existingElements, existingElementsAnswer, customCSSFromQuestion, } = common_1.useSelector((store) => {
        const { consumerStore } = store;
        return {
            consumerState: consumerStore.consumerState,
            startConsumer: consumerStore.getFirstQuestion,
            keyMapHandler: consumerStore.keyMapHandler,
            existingElements: consumerStore.existingElements,
            existingElementsAnswer: consumerStore.existingElementsAnswer,
            customCSSFromQuestion: consumerStore.customCSS,
        };
    });
    const styleElementRef = react_1.useRef(null);
    // adds the style sheet when the component mounts and removes it when it unmounts
    react_1.useEffect(() => {
        const styleElement = document.createElement('style');
        // need to update @types/react to make sure useRef returns MutableRefObject instead of RefObject
        styleElementRef.current =
            styleElement;
        document.head.appendChild(styleElement);
        return () => {
            document.head.removeChild(styleElement);
        };
    }, []);
    // custom css applied will be added the style tag created above
    // during dry run, it will be sent from parent as props
    // (because the user might be editing css. This also adds scoping to make sure that other parts of UI are not affected)
    // during actual run, it should be picked from store
    const customCSSApplied = (_a = customCSSProps.customCSS) !== null && _a !== void 0 ? _a : customCSSFromQuestion;
    react_1.useEffect(() => {
        const styleElement = styleElementRef.current;
        if (!styleElement)
            return;
        while (styleElement.firstChild) {
            styleElement.removeChild(styleElement.firstChild);
        }
        styleElement.appendChild(document.createTextNode(customCSSApplied));
    }, [customCSSApplied]);
    const isCSSEditorOpenRef = react_1.useRef(customCSSProps.isEditorOpen);
    react_1.useEffect(() => {
        isCSSEditorOpenRef.current = customCSSProps.isEditorOpen;
    }, [customCSSProps.isEditorOpen]);
    react_1.useEffect(() => {
        react_hotkeys_1.configure({
            ignoreEventsCondition: (event) => {
                if (event.key && event.target) {
                    const tagName = event.target.tagName.toLowerCase();
                    if (tagName === 'select') {
                        return true;
                    }
                    else if (tagName === 'input' || tagName === 'textarea') {
                        if (event.key.toLowerCase() === 'enter' ||
                            event.key.toLowerCase() === 'arrowdown' ||
                            event.key.toLowerCase() === 'arrowup') {
                            return isCSSEditorOpenRef.current;
                        }
                        else {
                            return true;
                        }
                    }
                }
                return false;
            },
        });
    }, []);
    react_1.useEffect(() => {
        if (prevConsumerState.current !== undefined &&
            prevConsumerState.current !== ConsumerModels_1.ConsumerState.NOT_RUNNING &&
            consumerState === ConsumerModels_1.ConsumerState.NOT_RUNNING) {
            onExit === null || onExit === void 0 ? void 0 : onExit();
        }
        prevConsumerState.current = consumerState;
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [consumerState]);
    if (consumerState === ConsumerModels_1.ConsumerState.NOT_RUNNING) {
        return null;
    }
    return (react_1.default.createElement(pickers_1.MuiPickersUtilsProvider, { utils: date_fns_1.default },
        react_1.default.createElement("div", { className: 'flex flex-col items-stretch flex-grow h-full w-full' },
            consumerState === ConsumerModels_1.ConsumerState.VARIABLE_SELECTION && (react_1.default.createElement("div", { className: 'flex flex-col flex-grow items-center overflow-hidden gap-4 bg-white' },
                react_1.default.createElement(VariableSelector_1.VariableSelector, null),
                react_1.default.createElement("div", { className: 'flex justify-center p-4' },
                    react_1.default.createElement(core_1.Button, { variant: 'contained', onClick: startConsumer }, "Start")))),
            consumerState === ConsumerModels_1.ConsumerState.RUNNING &&
                isChatStyleEnabled &&
                existingElements.map((element, index) => (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(ConsumerNode_1.ConsumerNode, { key: element.nodeId, exit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: element }),
                    react_1.default.createElement("div", { key: element.nodeId, className: 'flex flex-col flex-grow items-stretch min-h-0 max-w-screen-lg transform ' +
                            '-translate-x-1/2 left-1/2 bg-white relative' }, existingElementsAnswer[index] && (react_1.default.createElement("div", { style: {
                            display: 'flex',
                            flexDirection: 'row-reverse',
                            padding: 14,
                            alignItems: 'center',
                            gap: 4,
                            fontWeight: 500,
                        } },
                        react_1.default.createElement(core_1.Avatar, null),
                        existingElementsAnswer[index])))))),
            consumerState === ConsumerModels_1.ConsumerState.RUNNING && (react_1.default.createElement(react_hotkeys_1.GlobalHotKeys, { keyMap: keyMap, allowChanges: true, handlers: keyMapHandler },
                react_1.default.createElement(ConsumerNode_1.ConsumerNode, { exit: onExit, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings }))))));
};
//# sourceMappingURL=Consumer.js.map