"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerForm = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const icons_1 = require("@material-ui/icons");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
const ConsumerQuestion_1 = require("./ConsumerQuestion");
const core_1 = require("@material-ui/core");
const classes_1 = require("../../custom-classes-utils/classes");
function getItemHandlers(formQuestions, onFormQuestionsChange) {
    return {
        onSCQOptionChanged(index, value) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { scqOption: parseInt(value) });
            onFormQuestionsChange(newFormQuestions);
        },
        toggleMCQOption(index, value) {
            if (!formQuestions) {
                return;
            }
            const mcqOptions = [...formQuestions[index].mcqOptions];
            const optionIndex = mcqOptions.indexOf(value);
            if (optionIndex === -1) {
                mcqOptions.push(value);
            }
            else {
                mcqOptions.splice(optionIndex, 1);
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { mcqOptions });
            onFormQuestionsChange(newFormQuestions);
        },
        setMCQOptions(index, value) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { mcqOptions: value });
            onFormQuestionsChange(newFormQuestions);
        },
        setMatrixOptions(index, rowIndex, value, optionType) {
            if (!formQuestions) {
                return;
            }
            if (optionType === models_1.OptionType.SINGLE) {
                let matrixOptions = Object.assign({}, formQuestions[index].matrixOptions);
                matrixOptions = Object.assign(Object.assign({}, matrixOptions), { [rowIndex]: [value] });
                const newFormQuestions = [...formQuestions];
                newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { matrixOptions });
                onFormQuestionsChange(newFormQuestions);
            }
            else if (optionType === models_1.OptionType.MULTIPLE) {
                let matrixOptions = Object.assign({}, formQuestions[index].matrixOptions);
                if (!matrixOptions[rowIndex]) {
                    matrixOptions = Object.assign(Object.assign({}, matrixOptions), { [rowIndex]: [] });
                }
                const i = matrixOptions[rowIndex].indexOf(value);
                if (i === -1)
                    matrixOptions[rowIndex].push(value);
                else
                    matrixOptions[rowIndex].splice(i, 1);
                const newFormQuestions = [...formQuestions];
                newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { matrixOptions });
                onFormQuestionsChange(newFormQuestions);
            }
        },
        onRankingOptionSwapped(index, from, to) {
            if (!formQuestions) {
                return;
            }
            const rankingOptions = [...formQuestions[index].rankingOptions];
            rankingOptions.splice(to, 0, rankingOptions.splice(from, 1)[0]);
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { rankingOptions });
            onFormQuestionsChange(newFormQuestions);
        },
        onTextChange(index, text) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { text });
            onFormQuestionsChange(newFormQuestions);
        },
        onRatingChange(index, rating) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { rating });
            onFormQuestionsChange(newFormQuestions);
        },
        onAudioRecordingChanged(index, audioRecordingData) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { audioRecordingData });
            onFormQuestionsChange(newFormQuestions);
        },
        onVideoRecordingChanged(index, videoRecordingData) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { videoRecordingData });
            onFormQuestionsChange(newFormQuestions);
        },
        onFileChanged(index, fileUpload) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { fileUpload });
            onFormQuestionsChange(newFormQuestions);
        },
        onImageRecordingChanged(index, imageRecordingData) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { imageRecordingData });
            onFormQuestionsChange(newFormQuestions);
        },
        onDateChanged(index, date) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { date });
            onFormQuestionsChange(newFormQuestions);
        },
        onTimeChanged(index, time) {
            if (!formQuestions) {
                return;
            }
            const newFormQuestions = [...formQuestions];
            newFormQuestions[index] = Object.assign(Object.assign({}, formQuestions[index]), { time });
            onFormQuestionsChange(newFormQuestions);
        },
    };
}
exports.ConsumerForm = (props) => {
    var _a, _b, _c;
    const { onFormQuestionsChange, initializeFormQuestions, formData, setValid, isBackAllowed, isForwardAllowed, feedBackResponseDTO, navigateBack, navigateForward, sessionId, isChatStyleEnabled, chatSettings, questionResponse, } = props;
    const nodeContent = (_a = questionResponse === null || questionResponse === void 0 ? void 0 : questionResponse.nodeContent) !== null && _a !== void 0 ? _a : props.nodeContent;
    const updateKeyMap = common_1.useSelector((store) => {
        return store.consumerStore.updateKeyMap;
    });
    const [validQuestionsMap, setValidQuestionsMap] = react_1.useState(new Map());
    function setFormItemValid(formItemId, isValid) {
        setValidQuestionsMap((map) => {
            const newMap = new Map(map);
            newMap.set(formItemId, isValid);
            return newMap;
        });
    }
    react_1.useEffect(() => {
        const isValid = nodeContent.formItems
            .filter((it) => it.isMandatory)
            .reduce((acc, current) => {
            var _a, _b;
            return acc && ((_b = validQuestionsMap.get((_a = current.id) !== null && _a !== void 0 ? _a : '')) !== null && _b !== void 0 ? _b : false);
        }, true);
        setValid(isValid);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [validQuestionsMap]);
    react_1.useEffect(() => {
        updateKeyMap({
            BACK: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isBackAllowed) {
                    navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                }
            },
            FORWARD: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isForwardAllowed) {
                    navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                }
            },
        });
    }, [
        isBackAllowed,
        isForwardAllowed,
        navigateBack,
        navigateForward,
        sessionId,
        updateKeyMap,
    ]);
    const formQuestions = mobx_react_1.useObserver(() => formData.formQuestions);
    const itemHandlers = getItemHandlers(formQuestions, onFormQuestionsChange);
    react_1.useEffect(() => {
        if (!formData ||
            !formData.formQuestions ||
            formData.formQuestions.length === 0) {
            initializeFormQuestions(nodeContent.formItems);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [nodeContent]);
    if (!formQuestions) {
        return null;
    }
    return (react_1.default.createElement("div", { className: 'flex flex-col gap-16' },
        react_1.default.createElement("h3", { style: { display: 'flex' } },
            isBackAllowed && !isChatStyleEnabled && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(icons_1.ArrowBackIos, { onClick: () => navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : '') }),
                react_1.default.createElement("span", { style: {
                        marginTop: 4,
                        marginLeft: -2,
                        fontWeight: 'normal',
                        fontSize: 10,
                    } }, "press Top \u2191"))),
            isChatStyleEnabled && (react_1.default.createElement("span", { style: { marginRight: 4 } }, (chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) ? (react_1.default.createElement("img", { src: (_b = chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) !== null && _b !== void 0 ? _b : '' })) : (react_1.default.createElement(core_1.Avatar, null)))),
            react_1.default.createElement("div", { style: {
                    backgroundColor: isChatStyleEnabled ? '#1982FC' : 'unset',
                    padding: isChatStyleEnabled ? 8 : 'unset',
                    borderRadius: 24,
                    borderBottomLeftRadius: 4,
                }, className: classes_1.StylingClasses.form.formTitle }, (_c = nodeContent.title) !== null && _c !== void 0 ? _c : ''),
            isForwardAllowed && !isChatStyleEnabled && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(icons_1.ArrowBackIos, { style: { transform: 'rotate(180deg)' }, onClick: () => navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : '') }),
                react_1.default.createElement("span", { style: {
                        marginTop: 4,
                        marginLeft: 2,
                        fontWeight: 'normal',
                        fontSize: 10,
                    } }, "press Down \u2193")))),
        nodeContent.formItems.map((item, index) => {
            const handlers = {
                onRatingChange: itemHandlers.onRatingChange.bind(undefined, index),
                onSCQOptionChanged: itemHandlers.onSCQOptionChanged.bind(undefined, index),
                onTextChange: itemHandlers.onTextChange.bind(undefined, index),
                toggleMCQOption: itemHandlers.toggleMCQOption.bind(undefined, index),
                setMCQOptions: itemHandlers.setMCQOptions.bind(undefined, index),
                onAudioRecordingChanged: itemHandlers.onAudioRecordingChanged.bind(undefined, index),
                onVideoRecordingChanged: itemHandlers.onVideoRecordingChanged.bind(undefined, index),
                onImageRecordingChanged: itemHandlers.onImageRecordingChanged.bind(undefined, index),
                onRankingOptionSwapped: itemHandlers.onRankingOptionSwapped.bind(undefined, index),
                onFileChanged: itemHandlers.onFileChanged.bind(undefined, index),
                onDateChanged: itemHandlers.onDateChanged.bind(undefined, index),
                onTimeChanged: itemHandlers.onTimeChanged.bind(undefined, index),
                setMatrixOptions: itemHandlers.setMatrixOptions.bind(undefined, index),
            };
            return (react_1.default.createElement(mobx_react_1.Observer, { key: item.id }, () => {
                var _a;
                return (react_1.default.createElement(ConsumerQuestion_1.ConsumerQuestion, { nodeContent: item.nodeContent, formData: formQuestions[index], handlers: handlers, formItemData: item, isMandatory: item.isMandatory, setValid: setFormItemValid.bind(null, (_a = item.id) !== null && _a !== void 0 ? _a : ''), isBackAllowed: false, isForwardAllowed: false, feedBackResponseDTO: feedBackResponseDTO, navigateBack: navigateBack, navigateForward: navigateForward, sessionId: sessionId }));
            }));
        })));
};
//# sourceMappingURL=ConsumerForm.js.map