"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerNode = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const react_1 = tslib_1.__importStar(require("react"));
const ConsumerForm_1 = require("./ConsumerForm");
const ConsumerQuestion_1 = require("./ConsumerQuestion");
const classes_1 = require("../../custom-classes-utils/classes");
// eslint-disable-next-line react/display-name
exports.ConsumerNode = react_1.default.memo((props) => {
    const { isChatStyleEnabled, chatSettings, questionResponse } = props;
    const [isValid, setValid] = react_1.useState(true);
    const { formData, isSkippable, isLoading, nodeContent, nextQuestion, skipQuestion, closeConsumer, isBackAllowed, feedBackResponseDTO, navigateBack, navigateForward, sessionId, isForwardAllowed, updateKeyMap, skipInvalid, } = common_1.useSelector((store) => {
        var _a;
        const { consumerStore } = store;
        const { isQuestionLoading, error, nextQuestion, skipQuestion, closeConsumer, formData, navigateBack, navigateForward, updateKeyMap, } = consumerStore;
        const question = questionResponse !== null && questionResponse !== void 0 ? questionResponse : consumerStore.question;
        return {
            nodeContent: question === null || question === void 0 ? void 0 : question.nodeContent,
            isLoading: isQuestionLoading,
            nextQuestion,
            skipQuestion,
            closeConsumer,
            error: error,
            formData: formData,
            isSkippable: (question === null || question === void 0 ? void 0 : question.isSkippable) || false,
            isBackAllowed: (question === null || question === void 0 ? void 0 : question.isBackAllowed) || false,
            isForwardAllowed: (question === null || question === void 0 ? void 0 : question.isForwardAllowed) || false,
            feedBackResponseDTO: question === null || question === void 0 ? void 0 : question.feedBackResponseDTO,
            sessionId: question === null || question === void 0 ? void 0 : question.sessionId,
            navigateBack: navigateBack,
            navigateForward: navigateForward,
            updateKeyMap,
            skipInvalid: ((_a = question === null || question === void 0 ? void 0 : question.nodeContent) === null || _a === void 0 ? void 0 : _a.nodeType) === models_1.NodeType.QUESTION &&
                question.nodeContent.questionType === models_1.QuestionType.TEXT &&
                !(question.nodeContent.qualitativeType === models_1.QualitativeType.UPLOAD),
        };
    });
    const handlers = common_1.useSelector((store) => {
        return {
            onAudioRecordingChanged: store.consumerStore.onAudioRecordingChanged,
            onDateChanged: store.consumerStore.onDateChanged,
            onImageRecordingChanged: store.consumerStore.onImageRecordingChanged,
            onRatingChange: store.consumerStore.onRatingChange,
            onSCQOptionChanged: store.consumerStore.onSCQOptionChanged,
            onTextChange: store.consumerStore.onTextChange,
            onTimeChanged: store.consumerStore.onTimeChanged,
            onVideoRecordingChanged: store.consumerStore.onVideoRecordingChanged,
            toggleMCQOption: store.consumerStore.toggleMCQOption,
            setMCQOptions: store.consumerStore.setMCQOptions,
            onFileChanged: store.consumerStore.onFileChanged,
            onRankingOptionSwapped: store.consumerStore.onRankingOptionSwapped,
            setMatrixOptions: store.consumerStore.setMatrixOptions,
        };
    });
    function onCloseConsumer() {
        closeConsumer();
    }
    const onNextQuestion = react_1.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        nextQuestion();
    }), [nextQuestion]);
    const onSkipQuestion = react_1.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        skipQuestion();
    }), [skipQuestion]);
    const formHandlers = common_1.useSelector((store) => {
        return {
            onFormQuestionsChange: store.consumerStore.onFormQuestionsChange,
            initializeFormQuestions: store.consumerStore.initializeFormQuestions,
        };
    });
    react_1.useEffect(() => {
        updateKeyMap({
            ENTER: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isValid) {
                    onNextQuestion();
                }
            },
            SKIP: (event) => {
                if ((event === null || event === void 0 ? void 0 : event.key) && isSkippable && !skipInvalid) {
                    onSkipQuestion();
                }
            },
        });
    }, [
        isSkippable,
        isValid,
        onNextQuestion,
        onSkipQuestion,
        skipInvalid,
        updateKeyMap,
    ]);
    return (react_1.default.createElement("div", { className: 'flex flex-col flex-grow items-stretch min-h-0 max-w-screen-lg transform ' +
            '-translate-x-1/2 left-1/2 bg-white relative', style: {
            pointerEvents: questionResponse ? 'none' : 'unset',
            flexShrink: 0,
        } },
        react_1.default.createElement("div", { className: 'overflow-x-hidden overflow-y-auto flex-grow min-h-0 p-4', style: { height: '-webkit-fill-available' } },
            isLoading && react_1.default.createElement("span", null, "Loading..."),
            !isLoading &&
                nodeContent &&
                nodeContent.nodeType !== models_1.NodeType.FORM && (react_1.default.createElement(ConsumerQuestion_1.ConsumerQuestion, { isMandatory: !isSkippable, nodeContent: nodeContent, formData: formData, handlers: handlers, setValid: setValid, onNextQuestion: onNextQuestion, isLoading: isLoading, isBackAllowed: isBackAllowed, isForwardAllowed: isForwardAllowed, feedBackResponseDTO: feedBackResponseDTO, navigateBack: navigateBack, navigateForward: navigateForward, sessionId: sessionId, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: questionResponse })),
            !isLoading &&
                nodeContent &&
                nodeContent.nodeType === models_1.NodeType.FORM && (react_1.default.createElement(ConsumerForm_1.ConsumerForm, { nodeContent: nodeContent, formData: formData, onFormQuestionsChange: formHandlers.onFormQuestionsChange, initializeFormQuestions: formHandlers.initializeFormQuestions, setValid: setValid, isBackAllowed: isBackAllowed, isForwardAllowed: isForwardAllowed, feedBackResponseDTO: feedBackResponseDTO, navigateBack: navigateBack, navigateForward: navigateForward, sessionId: sessionId, isChatStyleEnabled: isChatStyleEnabled, chatSettings: chatSettings, questionResponse: questionResponse }))),
        react_1.default.createElement("div", { className: 'flex justify-center gap-4 p-4' },
            isSkippable && !questionResponse && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(core_1.Button, { classes: {
                        label: 'normal-case',
                        root: [
                            classes_1.StylingClasses.general.btn,
                            classes_1.StylingClasses.general.skipBtn,
                        ].join(' '),
                    }, variant: 'contained', onClick: onSkipQuestion, disabled: isLoading }, "Skip"),
                !isLoading && !skipInvalid && (react_1.default.createElement("div", { style: { marginTop: 4, fontWeight: 'normal', fontSize: 10 } }, "press S")))),
            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== models_1.NodeType.THANKS &&
                (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== models_1.NodeType.WELCOME &&
                !questionResponse && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(core_1.Button, { classes: {
                        label: 'normal-case',
                        root: [
                            classes_1.StylingClasses.general.btn,
                            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) === models_1.NodeType.FORM
                                ? `${classes_1.StylingClasses.form.formButton} ${classes_1.StylingClasses.general.submitBtn}`
                                : classes_1.StylingClasses.general.submitBtn,
                        ].join(' '),
                    }, variant: 'contained', onClick: onNextQuestion, disabled: isLoading || !isValid }, (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) === models_1.NodeType.FORM
                    ? nodeContent.actionText
                    : 'Submit'),
                !isLoading && isValid && (react_1.default.createElement("div", { style: { marginTop: 4, fontWeight: 'normal', fontSize: 10 } }, "press Enter \u21B5")))),
            (nodeContent === null || nodeContent === void 0 ? void 0 : nodeContent.nodeType) !== models_1.NodeType.THANKS && !isChatStyleEnabled && (react_1.default.createElement(core_1.Button, { classes: {
                    label: 'normal-case',
                    root: [
                        classes_1.StylingClasses.general.btn,
                        classes_1.StylingClasses.general.exitBtn,
                    ].join(' '),
                }, variant: 'contained', onClick: onCloseConsumer, disabled: isLoading }, "Exit")))));
});
//# sourceMappingURL=ConsumerNode.js.map