/// <reference types="react" />
import { ChatDistributionSettings, FormItem, NodeContent, QuestionResponseDTO } from '@fashtag/common/dist/models';
import { UserFeedbackResponse } from '@fashtag/common/dist/models/questionnaire/UserFeedbackResponse';
import { QuestionnaireConsumerFormData } from '../../models/ConsumerModels';
import { ConsumerHandlers } from './ConsumerNode';
declare type ConsumerQuestionProps = {
    nodeContent: NodeContent;
    formData: QuestionnaireConsumerFormData;
    formItemData?: Pick<FormItem, 'isMandatory' | 'keepQuestionAsPlaceholder'>;
    handlers: ConsumerHandlers;
    setValid: (isValid: boolean) => void;
    isMandatory: boolean;
    onNextQuestion?: () => Promise<void>;
    isLoading?: boolean;
    isBackAllowed: boolean;
    isForwardAllowed: boolean;
    feedBackResponseDTO?: UserFeedbackResponse;
    navigateBack: (sessionId: string) => void;
    navigateForward: (sessionId: string) => void;
    sessionId?: string;
    isChatStyleEnabled?: boolean;
    chatSettings?: ChatDistributionSettings;
    questionResponse?: QuestionResponseDTO | null;
};
export declare function ConsumerQuestion(props: ConsumerQuestionProps): JSX.Element;
export {};
