"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerQuestion = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const constants_1 = require("@fashtag/common/dist/constants");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const mobx_1 = require("mobx");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
const consumerUtils_1 = require("../../utils/consumerUtils");
const ConsumerRatingQuestion_1 = require("./ConsumerRatingQuestion");
const ConsumerSignatureQuestion_1 = require("./ConsumerSignatureQuestion");
const ConsumerTextQuestion_1 = require("./ConsumerTextQuestion");
const ConsumerUXQuestion_1 = require("./ConsumerUXQuestion");
const getConsumerMCQOptions_1 = require("./getConsumerMCQOptions");
const getConsumerRankingOptions_1 = require("./getConsumerRankingOptions");
const getConsumerSCQOptions_1 = require("./getConsumerSCQOptions");
const MatrixOptions_1 = require("./MatrixOptions");
const utils_1 = require("./utils");
const classNameUtils_1 = require("../../custom-classes-utils/classNameUtils");
const classes_1 = require("../../custom-classes-utils/classes");
function ConsumerQuestion(props) {
    const { nodeContent, handlers, formItemData, setValid, isMandatory, formData, onNextQuestion, isLoading, isBackAllowed, isForwardAllowed, feedBackResponseDTO, navigateBack, navigateForward, sessionId, isChatStyleEnabled, chatSettings, questionResponse, } = props;
    const { onSCQOptionChanged, onRatingChange, toggleMCQOption, setMCQOptions, onRankingOptionSwapped, setMatrixOptions, } = handlers;
    const isForm = !onNextQuestion;
    const [openRowIndex, setOpenRowIndex] = react_1.useState(nodeContent.nodeType === models_1.NodeType.QUESTION &&
        nodeContent.questionType === models_1.QuestionType.MATRIX
        ? 0
        : null);
    const contentVarValues = common_1.useSelector((store) => {
        var _a, _b;
        return (_b = (_a = store.consumerStore.question) === null || _a === void 0 ? void 0 : _a.contentVarValues) !== null && _b !== void 0 ? _b : {};
    });
    const updateKeyMap = common_1.useSelector((store) => {
        return store.consumerStore.updateKeyMap;
    });
    const variables = common_1.useSelector((store) => {
        var _a, _b;
        return mobx_1.toJS((_b = (_a = store.consumerStore.questionnaireResponse.data) === null || _a === void 0 ? void 0 : _a.questionnare.variables) !== null && _b !== void 0 ? _b : []);
    });
    const isValid = mobx_react_1.useObserver(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
        if (nodeContent.nodeType === models_1.NodeType.QUESTION) {
            if (nodeContent.questionType === models_1.QuestionType.OPTIONS) {
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    return nodeContent.options
                        .map((it) => parseInt(it.index))
                        .includes(formData.scqOption);
                }
                else if (nodeContent.optionType === models_1.OptionType.MULTIPLE) {
                    let isValid = true;
                    if (nodeContent.minSelectionsAllowed) {
                        isValid =
                            formData.mcqOptions.length >= nodeContent.minSelectionsAllowed;
                    }
                    if (nodeContent.maxSelectionsAllowed) {
                        isValid =
                            isValid &&
                                formData.mcqOptions.length <= nodeContent.maxSelectionsAllowed;
                    }
                    return formData.mcqOptions.length > 0 && isValid;
                }
                else {
                    return true;
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.MATRIX) {
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    return (nodeContent.rows.length ===
                        Object.keys(formData.matrixOptions).length &&
                        Object.values(formData.matrixOptions).every((item) => !!item));
                }
                else if (nodeContent.optionType === models_1.OptionType.MULTIPLE) {
                    return (nodeContent.rows.length ===
                        Object.keys(formData.matrixOptions).length &&
                        Object.values(formData.matrixOptions).every((item) => !!item && item.length > 0));
                }
                else {
                    return true;
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.SIGNATURE) {
                if (((_a = formData.imageRecordingData) === null || _a === void 0 ? void 0 : _a.imageDataURL) ||
                    formData.fileUpload ||
                    formData.text) {
                    return true;
                }
                else {
                    return false;
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.UX) {
                if (((_b = formData.imageRecordingData) === null || _b === void 0 ? void 0 : _b.imageDataURL) || ((_c = formData.videoRecordingData) === null || _c === void 0 ? void 0 : _c.videoUrl)) {
                    return true;
                }
                else {
                    return false;
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.TEXT) {
                if (nodeContent.qualitativeType === models_1.QualitativeType.UPLOAD) {
                    if (formData.fileUpload) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
                if (nodeContent.qualitativeType === models_1.QualitativeType.NUMERIC &&
                    ((_d = nodeContent.noOfDigits) !== null && _d !== void 0 ? _d : 0) > 0) {
                    return nodeContent.noOfDigits === formData.text.length;
                }
                let isValid = false;
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.TEXT_RESPONSE)) {
                    if (formData.text) {
                        isValid = true;
                    }
                    switch (nodeContent.qualitativeType) {
                        case models_1.QualitativeType.EMAIL:
                            isValid = constants_1.VALID_EMAIL_REGEX.test(formData.text.toLowerCase());
                            break;
                        case models_1.QualitativeType.PHONE:
                            isValid = constants_1.VALID_PHONE_REGEX.test(formData.text.toLowerCase());
                            break;
                        case models_1.QualitativeType.URL:
                            isValid = constants_1.VALID_URL_REGEX.test(formData.text.toLowerCase());
                            break;
                        default:
                            break;
                    }
                }
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.AUDIO_RESPONSE)) {
                    if (((_e = formData.audioRecordingData) === null || _e === void 0 ? void 0 : _e.audioBlob) || ((_f = formData.audioRecordingData) === null || _f === void 0 ? void 0 : _f.audioUrl)) {
                        isValid = true;
                    }
                }
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.VIDEO_RESPONSE)) {
                    if (((_g = formData.videoRecordingData) === null || _g === void 0 ? void 0 : _g.videoBlob) || ((_h = formData.videoRecordingData) === null || _h === void 0 ? void 0 : _h.videoUrl)) {
                        isValid = true;
                    }
                }
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.IMAGE_RESPONSE)) {
                    if (((_j = formData.imageRecordingData) === null || _j === void 0 ? void 0 : _j.imageBlob) || ((_k = formData.imageRecordingData) === null || _k === void 0 ? void 0 : _k.imageUrl)) {
                        isValid = true;
                    }
                }
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.DATE_RESPONSE)) {
                    if (formData.date) {
                        isValid = true;
                    }
                }
                if (consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.TIME_RESPONSE)) {
                    if (formData.time) {
                        isValid = true;
                    }
                }
                return isValid;
            }
            if (nodeContent.questionType === models_1.QuestionType.RATING) {
                return (formData.rating >= nodeContent.minRating &&
                    formData.rating <= nodeContent.maxRating);
            }
        }
        return true;
        // eslint-disable-next-line react-hooks/exhaustive-deps
    });
    react_1.useEffect(() => {
        if (!isForm) {
            updateKeyMap({
                BACK: (event) => {
                    if ((event === null || event === void 0 ? void 0 : event.key) && isBackAllowed) {
                        navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                    }
                },
                FORWARD: (event) => {
                    if ((event === null || event === void 0 ? void 0 : event.key) && isForwardAllowed) {
                        navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : '');
                    }
                },
            });
        }
    }, [
        isBackAllowed,
        isForm,
        isForwardAllowed,
        navigateBack,
        navigateForward,
        onNextQuestion,
        sessionId,
        updateKeyMap,
    ]);
    react_1.useEffect(() => {
        setValid(isValid);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [isValid]);
    const { text: substitutedText, imageUrl, videoUrl, } = utils_1.getSubstitutedTextAndImage(nodeContent, contentVarValues, variables);
    return (react_1.default.createElement(mobx_react_1.Observer, null, () => {
        var _a, _b;
        return (react_1.default.createElement("div", { className: `flex flex-col items-stretch gap-4 ${formItemData ? classes_1.StylingClasses.form.formItem : ''}`, style: { maxWidth: '80%' } },
            nodeContent.nodeType !== models_1.NodeType.QUESTIONNARE &&
                nodeContent.nodeType !== models_1.NodeType.ACTION &&
                nodeContent.nodeType !== models_1.NodeType.FORM &&
                (nodeContent.nodeType !== models_1.NodeType.QUESTION ||
                    nodeContent.questionType !== models_1.QuestionType.TEXT ||
                    !consumerUtils_1.isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.TEXT_RESPONSE) ||
                    !(formItemData === null || formItemData === void 0 ? void 0 : formItemData.keepQuestionAsPlaceholder)) && (react_1.default.createElement("div", { className: 'font-bold', style: { display: 'flex' } },
                !isForm && isBackAllowed && !isChatStyleEnabled && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(icons_1.ArrowBackIos, { onClick: () => navigateBack(sessionId !== null && sessionId !== void 0 ? sessionId : ''), className: classes_1.StylingClasses.general.back }),
                    react_1.default.createElement("span", { style: {
                            marginTop: 4,
                            marginLeft: -2,
                            fontWeight: 'normal',
                            fontSize: 10,
                        } }, "press Top \u2191"))),
                ' ',
                isChatStyleEnabled && (react_1.default.createElement("span", { style: { marginRight: 4 } }, (chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) ? (react_1.default.createElement("img", { src: (_a = chatSettings === null || chatSettings === void 0 ? void 0 : chatSettings.avatarURL) !== null && _a !== void 0 ? _a : '' })) : (react_1.default.createElement(core_1.Avatar, null)))),
                react_1.default.createElement("div", { style: {
                        backgroundColor: isChatStyleEnabled ? '#1982FC' : 'unset',
                        padding: isChatStyleEnabled ? 8 : 'unset',
                        borderRadius: 24,
                        borderBottomLeftRadius: 4,
                    }, className: classNameUtils_1.getClassnamesForContent(nodeContent) },
                    substitutedText,
                    ' ',
                    isMandatory &&
                        nodeContent.nodeType !== models_1.NodeType.STATEMENT &&
                        nodeContent.nodeType !== models_1.NodeType.WELCOME &&
                        nodeContent.nodeType !== models_1.NodeType.THANKS &&
                        '*'),
                !isForm && isForwardAllowed && !isChatStyleEnabled && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(icons_1.ArrowBackIos, { onClick: () => navigateForward(sessionId !== null && sessionId !== void 0 ? sessionId : ''), style: { transform: 'rotate(180deg)' }, className: classes_1.StylingClasses.general.forward }),
                    react_1.default.createElement("span", { style: {
                            marginTop: 4,
                            marginLeft: 2,
                            fontWeight: 'normal',
                            fontSize: 10,
                        } }, "press Down \u2193"))),
                ' ')),
            (nodeContent.nodeType === models_1.NodeType.WELCOME ||
                nodeContent.nodeType === models_1.NodeType.THANKS ||
                (nodeContent.nodeType === models_1.NodeType.QUESTION &&
                    (nodeContent.questionType === models_1.QuestionType.SIGNATURE ||
                        nodeContent.questionType === models_1.QuestionType.UX))) &&
                nodeContent.description && (react_1.default.createElement("div", { style: { fontSize: 14, color: '#777' }, className: classNameUtils_1.getClassnamesForDescription(nodeContent) }, nodeContent.description)),
            imageUrl && react_1.default.createElement("img", { src: imageUrl, alt: 'question' }),
            videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true },
                react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")),
            (nodeContent.nodeType === models_1.NodeType.WELCOME ||
                nodeContent.nodeType === models_1.NodeType.THANKS) &&
                !questionResponse && (react_1.default.createElement("div", { style: {
                    display: 'flex',
                    alignSelf: isChatStyleEnabled ? 'flex-start' : 'center',
                } },
                react_1.default.createElement(core_1.Button, { classes: {
                        label: 'normal-case',
                        root: classNameUtils_1.getClassnamesForWelThxBtn(nodeContent),
                    }, variant: 'contained', onClick: onNextQuestion, disabled: isLoading }, (_b = nodeContent.buttonLabel) !== null && _b !== void 0 ? _b : 'OK'),
                !isLoading && isValid && (react_1.default.createElement("div", { style: {
                        marginTop: 4,
                        marginLeft: 8,
                        fontWeight: 'normal',
                        fontSize: 10,
                    } }, "press Enter \u21B5")))),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.OPTIONS &&
                nodeContent.optionType === models_1.OptionType.SINGLE &&
                getConsumerSCQOptions_1.getConsumerSCQOptions(nodeContent, formData, onSCQOptionChanged, contentVarValues, variables, isForm, updateKeyMap),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.OPTIONS &&
                nodeContent.optionType === models_1.OptionType.MULTIPLE &&
                getConsumerMCQOptions_1.getConsumerMCQOptions(nodeContent, formData, toggleMCQOption, setMCQOptions, contentVarValues, variables, isForm, updateKeyMap),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.OPTIONS &&
                nodeContent.optionType === models_1.OptionType.RANKING &&
                getConsumerRankingOptions_1.getConsumerRankingOptions(nodeContent, formData, onRankingOptionSwapped, contentVarValues, variables, isForm),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.MATRIX &&
                MatrixOptions_1.MatrixOptions(nodeContent, formData, setMatrixOptions, contentVarValues, variables, openRowIndex, setOpenRowIndex),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.TEXT &&
                !questionResponse && (react_1.default.createElement(ConsumerTextQuestion_1.ConsumerTextQuestion, { formData: formData, formItemData: formItemData, nodeContent: nodeContent, isMandatory: isMandatory, handlers: handlers })),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.RATING && (react_1.default.createElement(ConsumerRatingQuestion_1.ConsumerRatingQuestion, { formData: formData, nodeContent: nodeContent, onRatingChange: onRatingChange, isForm: isForm, updateKeyMap: updateKeyMap })),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.SIGNATURE && (react_1.default.createElement(ConsumerSignatureQuestion_1.ConsumerSignatureQuestion, { formData: formData, nodeContent: nodeContent, handlers: handlers })),
            nodeContent.nodeType === models_1.NodeType.QUESTION &&
                nodeContent.questionType === models_1.QuestionType.UX && (react_1.default.createElement(ConsumerUXQuestion_1.ConsumerUXQuestion, { formData: formData, nodeContent: nodeContent, handlers: handlers }))));
    }));
}
exports.ConsumerQuestion = ConsumerQuestion;
//# sourceMappingURL=ConsumerQuestion.js.map