"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerRatingQuestion = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const icons_1 = require("@material-ui/icons");
const react_1 = tslib_1.__importStar(require("react"));
const classNameUtils_1 = require("../../custom-classes-utils/classNameUtils");
function ConsumerRatingQuestion(props) {
    const { formData, nodeContent, onRatingChange, isForm, updateKeyMap } = props;
    const steps = react_1.useMemo(() => {
        let rating = nodeContent.minRating;
        const steps = [];
        while (rating <= nodeContent.maxRating) {
            steps.push(rating);
            rating += nodeContent.stepSize;
        }
        return steps;
    }, [nodeContent]);
    const indexKeyboardShortcutBiMap = {};
    steps.forEach((option, index) => {
        const shortCut = index <= 26 && !isForm ? String.fromCharCode(65 + index) : '';
        indexKeyboardShortcutBiMap[option] = shortCut;
        indexKeyboardShortcutBiMap[shortCut] = option.toString();
        indexKeyboardShortcutBiMap[shortCut.toLowerCase()] = option.toString();
    });
    updateKeyMap({
        SELECT_OPTION: (event) => {
            if ((event === null || event === void 0 ? void 0 : event.key) && indexKeyboardShortcutBiMap[event.key]) {
                onRatingChange(parseInt(indexKeyboardShortcutBiMap[event.key]));
            }
        },
    });
    const optionClassName = classNameUtils_1.getClassnamesForOption(nodeContent);
    const getRatingJSX = react_1.useCallback((step) => {
        switch (nodeContent.ratingDisplayType) {
            case models_1.RatingDisplayType.NUMERIC:
                return (react_1.default.createElement("span", { className: `${formData.rating === step
                        ? 'text-white bg-gray-600'
                        : 'text-black'} flex flex-col items-center justify-center border border-gray-600 rounded-md cursor-pointer ${optionClassName}`, style: {
                        width: 40,
                        height: 40,
                    }, onClick: () => onRatingChange(step) }, step));
            case models_1.RatingDisplayType.STARS:
                return formData.rating > -1 && formData.rating >= step ? (react_1.default.createElement(icons_1.StarOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (react_1.default.createElement(icons_1.StarBorder, { fontSize: "large", onClick: () => onRatingChange(step) }));
            case models_1.RatingDisplayType.LIGHTNING:
                return formData.rating > -1 && formData.rating >= step ? (react_1.default.createElement(icons_1.OfflineBoltTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (react_1.default.createElement(icons_1.OfflineBoltOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
            case models_1.RatingDisplayType.THUMBS_UP:
                return formData.rating > -1 && formData.rating >= step ? (react_1.default.createElement(icons_1.ThumbUpTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) })) : (react_1.default.createElement(icons_1.ThumbUpOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
            case models_1.RatingDisplayType.PEOPLE:
                if (formData.rating > -1 && formData.rating === step) {
                    switch (step) {
                        case 1:
                            return (react_1.default.createElement(icons_1.SentimentVeryDissatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 2:
                            return (react_1.default.createElement(icons_1.SentimentDissatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 3:
                            return (react_1.default.createElement(icons_1.SentimentSatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 4:
                            return (react_1.default.createElement(icons_1.SentimentSatisfiedAltTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 5:
                            return (react_1.default.createElement(icons_1.SentimentVerySatisfiedTwoTone, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        default:
                            return (react_1.default.createElement(icons_1.SentimentVerySatisfiedOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                    }
                }
                else {
                    switch (step) {
                        case 1:
                            return (react_1.default.createElement(icons_1.SentimentVeryDissatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 2:
                            return (react_1.default.createElement(icons_1.SentimentDissatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 3:
                            return (react_1.default.createElement(icons_1.SentimentSatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 4:
                            return (react_1.default.createElement(icons_1.SentimentSatisfiedAlt, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        case 5:
                            return (react_1.default.createElement(icons_1.SentimentVerySatisfied, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                        default:
                            return (react_1.default.createElement(icons_1.SentimentVerySatisfiedOutlined, { fontSize: "large", className: optionClassName, onClick: () => onRatingChange(step) }));
                    }
                }
            default:
                return react_1.default.createElement(react_1.default.Fragment, null);
        }
    }, [
        formData.rating,
        nodeContent.ratingDisplayType,
        onRatingChange,
        optionClassName,
    ]);
    return (react_1.default.createElement("div", { className: "flex gap-4 flex-wrap", style: { alignItems: 'flex-end' } }, steps.map((step, index) => (react_1.default.createElement("div", { key: step },
        nodeContent.leftLabel && index === 0 && (react_1.default.createElement("div", null, nodeContent.leftLabel)),
        nodeContent.rightLabel && index === steps.length - 1 && (react_1.default.createElement("div", { style: { textAlign: 'end' } }, nodeContent.rightLabel)),
        getRatingJSX(step),
        indexKeyboardShortcutBiMap[step] && (react_1.default.createElement("div", { style: {
                paddingLeft: 4,
                paddingRight: 4,
                margin: 4,
                border: 'solid 2px black',
                borderRadius: 2,
                backgroundColor: 'rgb(119, 150, 254)',
                fontWeight: 500,
                height: 22,
            } }, indexKeyboardShortcutBiMap[step])))))));
}
exports.ConsumerRatingQuestion = ConsumerRatingQuestion;
//# sourceMappingURL=ConsumerRatingQuestion.js.map