"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerSignatureQuestion = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
// eslint-disable-next-line
// @ts-ignore
const react_sketch_1 = require("@mayrestinpeace/react-sketch");
require("./signature.css");
const classes_1 = require("../../custom-classes-utils/classes");
var FontFamily;
(function (FontFamily) {
    FontFamily["GREAT_VIBES"] = "Great Vibes";
    FontFamily["PARISIENNE"] = "Parisienne";
    FontFamily["SATISFY"] = "Satisfy";
    FontFamily["YELLOWTAIL"] = "Yellowtail";
})(FontFamily || (FontFamily = {}));
const useClasses = core_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
function ConsumerSignatureQuestion(props) {
    const classes = useClasses();
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let sketchRef = null;
    const [selectedFontFamily, setSelectedFontFamily] = react_1.useState(FontFamily.SATISFY);
    const { formData, nodeContent, handlers } = props;
    const [selectedResponseType, setSelectedResponseType] = react_1.useState(nodeContent.signatureAllowedResponseTypes[0]);
    const { fileUpload, imageRecordingData, text } = mobx_react_1.useObserver(() => {
        return Object.assign({}, formData);
    });
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    function onFileChanged(file) {
        handlers.onFileChanged(file);
    }
    return (react_1.default.createElement("div", { className: "flex gap-4 flex-wrap", style: { alignItems: 'flex-end' } },
        react_1.default.createElement("div", { style: {
                borderRadius: 12,
                width: 504,
                height: 240,
                maxWidth: '100%',
                backgroundColor: '#00000050',
            } },
            react_1.default.createElement("div", { style: { display: 'flex', justifyContent: 'center' } }, nodeContent.signatureAllowedResponseTypes.map((item) => (react_1.default.createElement("div", { key: item, onClick: () => {
                    onImageRecordingChanged({});
                    handlers.onTextChange('');
                    onFileChanged(null);
                    setSelectedResponseType(item);
                }, style: {
                    padding: 4,
                    cursor: 'pointer',
                    fontWeight: item === selectedResponseType ? 500 : 'inherit',
                    textDecoration: item === selectedResponseType ? 'underline' : 'none',
                } }, item)))),
            selectedResponseType === models_1.SignatureAllowedResponseType.DRAW && (react_1.default.createElement("div", { className: classes_1.StylingClasses.signature.signatureDraw },
                react_1.default.createElement(react_sketch_1.SketchField, { tool: react_sketch_1.Tools.Pencil, lineColor: "black", lineWidth: 3, 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    ref: (c) => (sketchRef = c), 
                    // backgroundColor="#00000050"
                    height: 240, forceValue: true, onChange: () => onImageRecordingChanged({ imageDataURL: sketchRef.toDataURL() }) }),
                react_1.default.createElement(core_1.Button, { variant: "contained", className: classes_1.StylingClasses.signature.signatureClearBtn, onClick: () => {
                        sketchRef.clear();
                        onImageRecordingChanged({});
                    } }, "Clear"))),
            selectedResponseType === models_1.SignatureAllowedResponseType.TYPE && (react_1.default.createElement("div", { className: classes_1.StylingClasses.signature.signatureType },
                react_1.default.createElement(core_1.Select, { value: selectedFontFamily, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => setSelectedFontFamily(event.target.value) },
                    react_1.default.createElement(core_1.MenuItem, { value: FontFamily.SATISFY }, FontFamily.SATISFY),
                    react_1.default.createElement(core_1.MenuItem, { value: FontFamily.PARISIENNE }, FontFamily.PARISIENNE),
                    react_1.default.createElement(core_1.MenuItem, { value: FontFamily.GREAT_VIBES }, FontFamily.GREAT_VIBES),
                    react_1.default.createElement(core_1.MenuItem, { value: FontFamily.YELLOWTAIL }, FontFamily.YELLOWTAIL)),
                react_1.default.createElement("input", { type: "text", placeholder: "Type Here", value: text, style: {
                        outline: 'none',
                        width: '100%',
                        background: 'transparent',
                        border: 'none',
                        borderBottom: '1px solid black',
                        padding: 16,
                        textAlign: 'center',
                        fontSize: 32,
                        fontWeight: 400,
                        fontFamily: `'${selectedFontFamily}', cursive`,
                    }, onChange: (event) => handlers.onTextChange(event.target.value) }))),
            selectedResponseType === models_1.SignatureAllowedResponseType.UPLOAD && (react_1.default.createElement("div", { className: classes_1.StylingClasses.signature.signatureUpload }, fileUpload ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(icons_1.Cancel, { onClick: () => onFileChanged(null) }),
                fileUpload.name)) : (react_1.default.createElement("input", { type: "file", autoComplete: "off", onChange: (event) => {
                    if (event.target &&
                        event.target.files &&
                        event.target.files.length > 0) {
                        onFileChanged(event.target.files[0]);
                    }
                } })))))));
}
exports.ConsumerSignatureQuestion = ConsumerSignatureQuestion;
//# sourceMappingURL=ConsumerSignatureQuestion.js.map