"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerTextQuestion = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const pickers_1 = require("@material-ui/pickers");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
// eslint-disable-next-line
// @ts-ignore
const react_intl_tel_input_1 = tslib_1.__importDefault(require("react-intl-tel-input"));
require("react-intl-tel-input/dist/main.css");
const consumerUtils_1 = require("../../utils/consumerUtils");
require("./main.css");
const classes_1 = require("../../custom-classes-utils/classes");
const useClasses = core_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
function ConsumerTextQuestion(props) {
    var _a;
    const classes = useClasses();
    const { formData, formItemData, nodeContent, handlers, isMandatory } = props;
    const { audioRecordingData, videoRecordingData, imageRecordingData, date, time, } = mobx_react_1.useObserver(() => {
        return Object.assign({}, formData);
    });
    function onAudioRecordingChanged(data) {
        handlers.onAudioRecordingChanged(data);
    }
    function onVideoRecordingChanged(data) {
        handlers.onVideoRecordingChanged(data);
    }
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    function onDateChanged(date) {
        handlers.onDateChanged(date);
    }
    function onTimeChanged(time) {
        handlers.onTimeChanged(time);
    }
    function onFileChanged(file) {
        handlers.onFileChanged(file);
    }
    const getInputType = react_1.useCallback(() => {
        switch (nodeContent.qualitativeType) {
            case models_1.QualitativeType.EMAIL:
                return 'email';
            case models_1.QualitativeType.NUMERIC:
                return 'number';
            default:
                return 'text';
        }
    }, [nodeContent.qualitativeType]);
    if (nodeContent.qualitativeType === models_1.QualitativeType.UPLOAD) {
        return (react_1.default.createElement("div", { className: 'flex flex-col gap-4' },
            react_1.default.createElement("div", { style: {
                    border: '#EDEDED solid 1px',
                    padding: 8,
                    width: 320,
                    height: 120,
                    display: 'flex',
                    alignItems: 'center',
                } }, formData.fileUpload ? (react_1.default.createElement("div", { className: classes_1.StylingClasses.upload.uploadedFile },
                react_1.default.createElement(icons_1.Cancel, { onClick: () => onFileChanged(null) }),
                formData.fileUpload.name)) : (react_1.default.createElement("input", { type: "file", autoComplete: "off", className: classes_1.StylingClasses.upload.uploadFile, onChange: (event) => {
                    if (event.target &&
                        event.target.files &&
                        event.target.files.length > 0) {
                        onFileChanged(event.target.files[0]);
                    }
                } })))));
    }
    else
        return (react_1.default.createElement("div", { className: 'flex flex-col gap-4' },
            nodeContent.qualitativeType === models_1.QualitativeType.NUMERIC &&
                ((_a = nodeContent.noOfDigits) !== null && _a !== void 0 ? _a : 0) > 0 && (react_1.default.createElement("div", { style: { fontSize: 14, color: '#777' } }, `Please enter your ${nodeContent.noOfDigits} digit response`)),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.TEXT_RESPONSE) &&
                nodeContent.qualitativeType !== models_1.QualitativeType.PHONE && (react_1.default.createElement(core_1.TextField, { autoFocus: true, type: getInputType(), multiline: nodeContent.qualitativeType === models_1.QualitativeType.NORMAL &&
                    nodeContent.textResponseType === models_1.TextResponseType.MULTI_LINE, className: `${classes_1.StylingClasses.qualitative.textResponse} ${classes_1.StylingClasses.question.response}`, variant: 'outlined', value: formData.text, placeholder: (formItemData === null || formItemData === void 0 ? void 0 : formItemData.keepQuestionAsPlaceholder) ? consumerUtils_1.getContent(nodeContent) + (isMandatory ? ' *' : '')
                    : undefined, onChange: (event) => handlers.onTextChange(event.target.value) })),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.TEXT_RESPONSE) &&
                nodeContent.qualitativeType === models_1.QualitativeType.PHONE && (react_1.default.createElement(react_intl_tel_input_1.default, { autoFocus: true, preferredCountries: ['in'], className: `${classes_1.StylingClasses.qualitative.textResponse} ${classes_1.StylingClasses.question.response}`, customPlaceholder: () => 'Enter your number', containerClassName: "intl-tel-input", inputClassName: "form-control", separateDialCode: true, onPhoneNumberChange: (isValid, newNumber) => {
                    handlers.onTextChange(newNumber);
                }, formatOnInit: false, value: formData.text, style: {
                    width: 320,
                    color: '#000',
                    borderRadius: 4,
                    border: 'thin solid #ededed',
                    padding: '0 12px',
                } })),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.AUDIO_RESPONSE) && (react_1.default.createElement("div", { className: `self-start ${classes_1.StylingClasses.qualitative.audioResponse}` },
                react_1.default.createElement(common_1.AudioRecorderComponent, { data: audioRecordingData, onChange: onAudioRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.VIDEO_RESPONSE) && (react_1.default.createElement("div", { className: `self-start ${classes_1.StylingClasses.qualitative.videoResponse}` },
                react_1.default.createElement(common_1.VideoRecorderComponent, { data: videoRecordingData, onChange: onVideoRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.IMAGE_RESPONSE) && (react_1.default.createElement("div", { className: `self-start ${classes_1.StylingClasses.qualitative.imageResponse}` },
                react_1.default.createElement(common_1.ImageRecorderComponent, { data: imageRecordingData, onChange: onImageRecordingChanged }))),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.DATE_RESPONSE) && (react_1.default.createElement("div", { className: classes_1.StylingClasses.qualitative.dateResponse },
                react_1.default.createElement("span", null, "Date"),
                react_1.default.createElement("div", { className: 'flex flex-row gap-1' },
                    react_1.default.createElement(pickers_1.DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                            classes: { input: classes.selectInput },
                        }, format: 'dd/MM/yyyy', value: date, onChange: onDateChanged }),
                    react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onDateChanged(null) },
                        react_1.default.createElement(icons_1.Close, null))))),
            nodeContent.allowedResponseTypes.includes(models_1.AllowedResponseType.DATE_RESPONSE) && (react_1.default.createElement("div", { className: classes_1.StylingClasses.qualitative.timeResponse },
                react_1.default.createElement("span", null, "Time"),
                react_1.default.createElement("div", { className: 'flex flex-row gap-1' },
                    react_1.default.createElement(pickers_1.TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                            classes: { input: classes.selectInput },
                        }, format: 'HH:mm', value: time, onChange: onTimeChanged }),
                    react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onTimeChanged(null) },
                        react_1.default.createElement(icons_1.Close, null)))))));
}
exports.ConsumerTextQuestion = ConsumerTextQuestion;
//# sourceMappingURL=ConsumerTextQuestion.js.map