"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerUXQuestion = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const pico_1 = require("@gripeless/pico");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
require("./signature.css");
const UXAudioRecorder_1 = require("./UXAudioRecorder");
const UXFeedbackWithContext_1 = require("./UXFeedbackWithContext");
const UXVideoDrawingBoard_1 = require("./UXVideoDrawingBoard");
const UXVideoRecorder_1 = require("./UXVideoRecorder");
const classes_1 = require("../../custom-classes-utils/classes");
function ConsumerUXQuestion(props) {
    const { formData, nodeContent, handlers } = props;
    const previewRef = react_1.useRef(null);
    const [isPreviewVisible, setPreviewVisible] = react_1.useState(false);
    const [hasUserRecordingStarted, setHasUserRecordingStarted] = react_1.useState(false);
    const [isVideoAnnotateActive, setIsVideoAnnotateActive] = react_1.useState(false);
    const [isFeedbackWithContextEnabled, setFeedbackWithContextEnabled] = react_1.useState(false);
    const { onUXPathResponseChanged, onUXTextResponseChanged, onUXUserVideoResponseChanged, onUXUserImageResponseChanged, onAudioRecordingChanged, } = common_1.useSelector((store) => {
        return {
            onUXPathResponseChanged: store.consumerStore.onUXPathResponseChanged,
            onUXTextResponseChanged: store.consumerStore.onUXTextResponseChanged,
            onUXUserVideoResponseChanged: store.consumerStore.onUXUserVideoResponseChanged,
            onUXUserImageResponseChanged: store.consumerStore.onUXUserImageResponseChanged,
            onAudioRecordingChanged: store.consumerStore.onAudioRecordingChanged,
        };
    });
    const { imageRecordingData, videoRecordingData, uxTextResponse, uxUserVideoResponse, uxXPathResponse, uxUserImageResponse, audioRecordingData, } = mobx_react_1.useObserver(() => {
        return Object.assign({}, formData);
    });
    const startCapture = react_1.useCallback(() => {
        var _a;
        window['screenRecordingFinished'] = (data) => {
            handlers.onVideoRecordingChanged({
                videoExternalUrl: data,
                videoUrl: data,
            });
            setPreviewVisible(false);
        };
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const webkit = window['webkit'];
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const NativeBridge = window['NativeBridge'];
        if (NativeBridge && NativeBridge.startRecording) {
            NativeBridge.startRecording('');
            setPreviewVisible(true);
        }
        else if (webkit &&
            webkit.messageHandlers &&
            webkit.messageHandlers.NativeBridge &&
            webkit.messageHandlers.NativeBridge.postMessage) {
            webkit.messageHandlers.NativeBridge.postMessage({
                callback: 'startRecording',
            });
        }
        else {
            (_a = navigator.mediaDevices) === null || _a === void 0 ? void 0 : _a.getDisplayMedia({
                video: {
                    cursor: 'always',
                },
                audio: false,
            }).then((captureStream) => {
                try {
                    setPreviewVisible(true);
                    if (!previewRef.current)
                        return;
                    previewRef.current.srcObject = captureStream;
                    const mediaRecorder = new MediaRecorder(captureStream);
                    mediaRecorder.start();
                    const videoChunks = [];
                    mediaRecorder.addEventListener('dataavailable', (event) => {
                        videoChunks.push(event.data);
                    });
                    mediaRecorder.addEventListener('stop', (event) => {
                        const videoBlob = new Blob(videoChunks, {
                            type: 'video/webm',
                        });
                        const videoUrl = URL.createObjectURL(videoBlob);
                        handlers.onVideoRecordingChanged({ videoBlob, videoUrl });
                        setPreviewVisible(false);
                        setIsVideoAnnotateActive(false);
                    });
                    // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                    // @ts-ignore
                    captureStream.oninactive = () => {
                        var _a, _b;
                        if (mediaRecorder.state === 'recording') {
                            mediaRecorder.stop();
                        }
                        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                        // @ts-ignore
                        const tracks = (_b = (_a = previewRef.current) === null || _a === void 0 ? void 0 : _a.srcObject) === null || _b === void 0 ? void 0 : _b.getTracks();
                        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
                        // @ts-ignore
                        tracks.forEach((track) => track.stop());
                        if (previewRef.current) {
                            previewRef.current.srcObject = null;
                        }
                        console.log('stopped');
                    };
                }
                catch (e) {
                    console.log('error');
                }
            }).catch((err) => console.error('Error: ' + err));
        }
    }, [handlers]);
    function onImageRecordingChanged(data) {
        handlers.onImageRecordingChanged(data);
    }
    if (nodeContent.uxQuestionType === models_1.UXQuestionType.FEEDBACK_WITH_CONTEXT) {
        return (react_1.default.createElement("div", { className: classes_1.StylingClasses.ux.uxFeedbackContext },
            (imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL) && (react_1.default.createElement("div", { style: { width: '50%', position: 'relative' } },
                react_1.default.createElement(icons_1.Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => {
                        onImageRecordingChanged({});
                        onUXTextResponseChanged(null);
                    } }),
                react_1.default.createElement("img", { src: imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL }))),
            react_1.default.createElement(core_1.Button, { className: `${classes_1.StylingClasses.general.btn} ${classes_1.StylingClasses.ux.uxFeedbackContextBtn}`, variant: "contained", onClick: () => {
                    setFeedbackWithContextEnabled(true);
                } }, "Feedback with context"),
            isFeedbackWithContextEnabled && (react_1.default.createElement(UXFeedbackWithContext_1.UXFeedbackWithContext, { formData: formData, nodeContent: nodeContent, handlers: handlers, setFeedbackWithContextEnabled: setFeedbackWithContextEnabled, onUXPathResponseChanged: onUXPathResponseChanged, takeScreenShot: (ignore) => {
                    if (ignore) {
                        pico_1.dataURL(window, { ignore: [ignore] }).then((dataURL) => {
                            onImageRecordingChanged({ imageDataURL: dataURL.value });
                            setFeedbackWithContextEnabled(false);
                        });
                    }
                    else {
                        pico_1.dataURL(window).then((dataURL) => {
                            onImageRecordingChanged({ imageDataURL: dataURL.value });
                            setFeedbackWithContextEnabled(false);
                        });
                    }
                } })),
            react_1.default.createElement("textarea", { value: uxTextResponse, className: `${classes_1.StylingClasses.question.response} ${classes_1.StylingClasses.ux.uxFeedbackTextResponse}`, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                } })));
    }
    else if (nodeContent.uxQuestionType === models_1.UXQuestionType.SCREEN_SHOT) {
        return (react_1.default.createElement("div", { className: classes_1.StylingClasses.ux.uxScreenshot },
            (imageRecordingData === null || imageRecordingData === void 0 ? void 0 : imageRecordingData.imageDataURL) && (react_1.default.createElement("div", { style: { width: '50%', position: 'relative' } },
                react_1.default.createElement(icons_1.Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => {
                        onImageRecordingChanged({});
                        onUXTextResponseChanged(null);
                    } }),
                react_1.default.createElement(common_1.DrawingBoard, { backgroundImage: imageRecordingData.imageDataURL, onImageRecordingChanged: onUXUserImageResponseChanged }))),
            react_1.default.createElement(core_1.Button, { variant: "contained", className: `${classes_1.StylingClasses.general.btn} ${classes_1.StylingClasses.ux.uxFeedbackContextBtn}`, onClick: () => {
                    pico_1.dataURL(window).then((dataURL) => {
                        onImageRecordingChanged({ imageDataURL: dataURL.value });
                        setFeedbackWithContextEnabled(false);
                    });
                }, style: { marginTop: 8 } }, "Take Screenshot"),
            react_1.default.createElement("textarea", { value: uxTextResponse, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                }, className: `${classes_1.StylingClasses.question.response} ${classes_1.StylingClasses.ux.uxFeedbackTextResponse}` })));
    }
    else {
        return (react_1.default.createElement("div", { className: classes_1.StylingClasses.ux.uxScreenRecord },
            (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl) && (react_1.default.createElement("div", { style: { width: '50%', position: 'relative' } },
                react_1.default.createElement(icons_1.Cancel, { style: {
                        position: 'absolute',
                        top: 0,
                        right: 0,
                        margin: -8,
                        cursor: 'pointer',
                    }, onClick: () => handlers.onVideoRecordingChanged(null) }),
                react_1.default.createElement("video", { src: videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl, controls: true, preload: "auto" }))),
            isPreviewVisible && (react_1.default.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, preload: 'auto', autoPlay: true, muted: true })),
            react_1.default.createElement(core_1.Button, { variant: "contained", onClick: () => {
                    startCapture();
                }, className: `${classes_1.StylingClasses.general.btn} ${classes_1.StylingClasses.ux.uxFeedbackContextBtn}` }, "Record Screen"),
            nodeContent.userMediaRecordingType ===
                models_1.UserMediaRecordingType.AUDIO_VIDEO &&
                (isPreviewVisible || (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl)) && (react_1.default.createElement("div", { className: 'self-start' },
                react_1.default.createElement(UXVideoRecorder_1.UXVideoRecorderComponent, { data: uxUserVideoResponse, onChange: onUXUserVideoResponseChanged, setHasUserRecordingStarted: setHasUserRecordingStarted, screenRecordingData: videoRecordingData }))),
            nodeContent.userMediaRecordingType === models_1.UserMediaRecordingType.AUDIO &&
                (isPreviewVisible || (videoRecordingData === null || videoRecordingData === void 0 ? void 0 : videoRecordingData.videoUrl)) && (react_1.default.createElement("div", { className: 'self-start' },
                react_1.default.createElement(UXAudioRecorder_1.UXAudioRecorderComponent, { data: audioRecordingData, onChange: onAudioRecordingChanged, setHasUserRecordingStarted: setHasUserRecordingStarted, screenRecordingData: videoRecordingData }))),
            isVideoAnnotateActive && (react_1.default.createElement(UXVideoDrawingBoard_1.UXVideoDrawingBoard, { onStopAnnotate: () => setIsVideoAnnotateActive(false) })),
            isPreviewVisible && !isVideoAnnotateActive && !window['NativeBridge'] && (react_1.default.createElement("div", { style: { position: 'fixed', top: 0, left: 0 } },
                react_1.default.createElement("div", { style: {
                        display: 'flex',
                        flexDirection: 'column',
                        alignItems: 'center',
                        background: '#333',
                        borderRadius: 4,
                        padding: 8,
                        color: '#CCC',
                    }, onClick: () => setIsVideoAnnotateActive(true) },
                    react_1.default.createElement(icons_1.BrushOutlined, { htmlColor: "#CCC" }),
                    "Start Annotation"))),
            react_1.default.createElement("textarea", { value: uxTextResponse, onChange: (event) => {
                    onUXTextResponseChanged(event.target.value);
                }, className: `${classes_1.StylingClasses.question.response} ${classes_1.StylingClasses.ux.uxFeedbackTextResponse}`, placeholder: 'Please type your feedback', style: {
                    width: '100%',
                    height: 'auto',
                    minHeight: 80,
                    overflowY: 'auto',
                    color: '#000',
                    borderRadius: 4,
                    fontWeight: 400,
                    border: 'thin solid #ededed',
                    padding: '8px 16px 8px 8px',
                    overflow: 'hidden',
                    resize: 'none',
                    marginTop: 16,
                } })));
    }
}
exports.ConsumerUXQuestion = ConsumerUXQuestion;
//# sourceMappingURL=ConsumerUXQuestion.js.map