"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatrixOptions = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const react_1 = tslib_1.__importStar(require("react"));
const core_1 = require("@material-ui/core");
const utils_1 = require("./utils");
const KeyboardArrowDown_1 = tslib_1.__importDefault(require("@material-ui/icons/KeyboardArrowDown"));
const KeyboardArrowUp_1 = tslib_1.__importDefault(require("@material-ui/icons/KeyboardArrowUp"));
const DarkTooltip_1 = require("./DarkTooltip");
const classes_1 = require("../../custom-classes-utils/classes");
function MatrixOptions(nodeContent, formData, setMatrixOptions, contentVarValues, variables, openRowIndex, setOpenRowIndex) {
    const containerRef = react_1.useRef(null);
    const [containerWidth, setContainerWidth] = react_1.useState(null);
    react_1.useLayoutEffect(() => {
        if (!containerRef.current) {
            return;
        }
        const resizeListener = () => {
            var _a, _b;
            setContainerWidth((_b = (_a = containerRef.current) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : null);
        };
        resizeListener();
        window.addEventListener('resize', resizeListener);
        return () => {
            window.removeEventListener('resize', resizeListener);
        };
    }, []);
    return (react_1.default.createElement("div", { ref: containerRef }, (containerWidth !== null && containerWidth !== void 0 ? containerWidth : 0) < 768 ? (react_1.default.createElement(core_1.List, { dense: true, component: "div", role: "list", style: {
            display: 'flex',
            flexDirection: 'column',
            padding: 0,
        } }, nodeContent.rows.map((row, index) => {
        const value = parseInt(row.index);
        const key = `dry-run-option-${value}`;
        const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(row, contentVarValues, variables);
        return (react_1.default.createElement("div", { key: key },
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    background: '#AAA',
                    padding: 8,
                }, onClick: () => setOpenRowIndex(openRowIndex === index ? null : index) },
                react_1.default.createElement("span", { className: classes_1.StylingClasses.matrix.matrixRowLabel }, text),
                openRowIndex === index ? (react_1.default.createElement(KeyboardArrowUp_1.default, null)) : (react_1.default.createElement(KeyboardArrowDown_1.default, null))),
            imageUrl && (react_1.default.createElement("div", null,
                react_1.default.createElement("img", { src: imageUrl, style: { width: 160 } }))),
            videoUrl && (react_1.default.createElement("video", { width: "160", height: "120", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")),
            openRowIndex === index &&
                (nodeContent.optionType === models_1.OptionType.MULTIPLE ? (nodeContent.cols.map((col) => {
                    const value = parseInt(col.index);
                    const key = `dry-run-option-${row}-${col}`;
                    const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(col, contentVarValues, variables);
                    const isChecked = formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index].includes(parseInt(col.index));
                    return (react_1.default.createElement("div", { key: key, style: { margin: 8 } },
                        react_1.default.createElement(core_1.FormControlLabel, { control: react_1.default.createElement(core_1.Checkbox, { className: classes_1.StylingClasses.matrix.matrixCheckbox, checked: isChecked, tabIndex: -1, disableRipple: true, onChange: () => setMatrixOptions(row.index, value, models_1.OptionType.MULTIPLE) }), label: react_1.default.createElement("span", { className: classes_1.StylingClasses.matrix.matrixColLabel }, text) }),
                        imageUrl && (react_1.default.createElement("div", null,
                            react_1.default.createElement("img", { src: imageUrl, style: { width: 160 } }))),
                        videoUrl && (react_1.default.createElement("video", { width: "160", height: "120", controls: true, style: {
                                margin: 'auto',
                                border: '1px solid white',
                            } },
                            react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                            "Your browser does not support the video tag."))));
                })) : (react_1.default.createElement("div", { style: {
                        display: 'flex',
                        flexDirection: 'column',
                        gap: 8,
                    } }, nodeContent.cols.map((option) => {
                    const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(option, contentVarValues, variables);
                    const isChecked = formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index][0] ===
                            parseInt(option.index);
                    return (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement("div", { style: {
                                display: 'flex',
                                margin: 8,
                                alignItems: 'center',
                            }, key: option.index },
                            react_1.default.createElement("input", { className: classes_1.StylingClasses.matrix.matrixCheckbox, type: "radio", value: "consumer_type_individuals", style: { marginRight: 4 }, checked: isChecked, onChange: () => {
                                    if (index < nodeContent.rows.length - 1) {
                                        setOpenRowIndex(index + 1);
                                    }
                                    setMatrixOptions(row.index, parseInt(option.index), models_1.OptionType.SINGLE);
                                } }),
                            react_1.default.createElement("label", { htmlFor: "consumer_type_individuals", className: classes_1.StylingClasses.matrix.matrixColLabel }, text)),
                        imageUrl && (react_1.default.createElement("div", null,
                            react_1.default.createElement("img", { src: imageUrl, style: { width: 160 } }))),
                        videoUrl && (react_1.default.createElement("video", { width: "160", height: "120", controls: true, style: {
                                margin: 'auto',
                                border: '1px solid white',
                            } },
                            react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                            "Your browser does not support the video tag."))));
                })))),
            formData.matrixOptions[row.index] &&
                formData.matrixOptions[row.index].length > 0 &&
                openRowIndex !== index && (react_1.default.createElement("div", { style: { margin: 8 } },
                react_1.default.createElement("b", null, "Selected Answer:"),
                ' ',
                formData.matrixOptions[row.index]
                    .map((index) => {
                    const element = nodeContent.cols.find((item) => item.index === index.toString());
                    return element === null || element === void 0 ? void 0 : element.content;
                })
                    .join(', '))),
            react_1.default.createElement("div", { style: { height: 2, background: '#AAA', margin: 8 } })));
    }))) : (react_1.default.createElement("div", { style: {
            display: 'flex',
            flexDirection: 'column',
            gap: 16,
            fontSize: 16,
        } },
        react_1.default.createElement("div", { key: '-1', style: { display: 'flex', gap: 8 } },
            react_1.default.createElement("div", { style: { flexBasis: 0, flexGrow: 1, fontWeight: 500 } }),
            nodeContent.cols.map((col, colIndex) => {
                var _a;
                const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(col, contentVarValues, variables);
                return (react_1.default.createElement("div", { key: col.index, style: {
                        flexBasis: 0,
                        flexGrow: 1,
                        fontWeight: 500,
                        wordBreak: 'break-all',
                        maxWidth: `${parseInt((100 / (nodeContent.cols.length + 1)).toString())}%`,
                        textAlign: 'center',
                    } },
                    react_1.default.createElement(DarkTooltip_1.DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                            ? (_a = col.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "bottom", arrow: true },
                        react_1.default.createElement("div", { className: classes_1.StylingClasses.matrix.matrixColLabel }, text)),
                    imageUrl && (react_1.default.createElement("div", null,
                        react_1.default.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                    videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                        react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                        "Your browser does not support the video tag."))));
            })),
        nodeContent.rows.map((row, rIndex) => {
            var _a;
            const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(row, contentVarValues, variables);
            return (react_1.default.createElement("div", { key: row.index, style: {
                    display: 'flex',
                    alignItems: 'center',
                } },
                react_1.default.createElement("div", { style: {
                        flexBasis: 0,
                        flexGrow: 1,
                        fontWeight: 500,
                        wordBreak: 'break-all',
                        maxWidth: `${parseInt((100 / (nodeContent.cols.length + 1)).toString())}%`,
                    } },
                    react_1.default.createElement(DarkTooltip_1.DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                            ? (_a = row.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                        react_1.default.createElement("div", { className: classes_1.StylingClasses.matrix.matrixRowLabel }, text)),
                    imageUrl && (react_1.default.createElement("div", null,
                        react_1.default.createElement("img", { src: imageUrl, style: { width: 320 } }))),
                    videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                        react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                        "Your browser does not support the video tag."))),
                nodeContent.cols.map((col, colIndex) => (react_1.default.createElement("div", { key: col.index, style: { flexBasis: 0, flexGrow: 1 } }, nodeContent.optionType === models_1.OptionType.SINGLE ? (react_1.default.createElement("input", { className: classes_1.StylingClasses.matrix.matrixCheckbox, type: "radio", value: "consumer_type_individuals", style: {
                        alignSelf: 'center',
                        width: '100%',
                    }, checked: formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index][0] ===
                            parseInt(col.index), onChange: () => {
                        setMatrixOptions(row.index, parseInt(col.index), models_1.OptionType.SINGLE);
                    } })) : (react_1.default.createElement(core_1.Checkbox, { className: classes_1.StylingClasses.matrix.matrixCheckbox, checked: formData.matrixOptions[row.index] &&
                        formData.matrixOptions[row.index].length > 0 &&
                        formData.matrixOptions[row.index].includes(parseInt(col.index)), style: {
                        alignSelf: 'center',
                        width: '100%',
                    }, tabIndex: -1, disableRipple: true, onChange: () => setMatrixOptions(row.index, parseInt(col.index), models_1.OptionType.MULTIPLE) })))))));
        })))));
}
exports.MatrixOptions = MatrixOptions;
//# sourceMappingURL=MatrixOptions.js.map