"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RankingOptionElementSelector = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const icons_1 = require("@material-ui/icons");
const react_1 = tslib_1.__importStar(require("react"));
const DarkTooltip_1 = require("./DarkTooltip");
exports.RankingOptionElementSelector = (props) => {
    var _a;
    const optionRef = react_1.useRef(null);
    const handleRef = react_1.useRef(null);
    const { option, index, move, imageUrl, videoUrl, isOptionHoveringEnabled } = props;
    const isDraggingOver = common_1.useDragSortableItem(index, move, optionRef, handleRef, 'new-edit-node-option-sort');
    return (react_1.default.createElement("div", { className: `flex items-start ${isDraggingOver ? 'invisible' : 'visible'}`, ref: optionRef, style: { display: 'flex', alignItems: 'center' } },
        react_1.default.createElement("div", { style: { padding: '11px 7px', cursor: 'move' }, ref: handleRef },
            react_1.default.createElement(icons_1.DragIndicator, null)),
        react_1.default.createElement("div", { className: 'min-w-0' },
            react_1.default.createElement(DarkTooltip_1.DarkTooltip, { title: isOptionHoveringEnabled ? (_a = option.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                react_1.default.createElement("div", null, option.content)),
            imageUrl && (react_1.default.createElement("div", null,
                react_1.default.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag.")))));
};
//# sourceMappingURL=RankingOptionElement.js.map