"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UXAudioRecorderComponent = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const common_1 = require("@fashtag/common");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const audio_1 = require("@fashtag/common/dist/web-media-recorder/audio");
const NotificationStore_1 = require("@fashtag/common/dist/stores/NotificationStore");
const react_2 = require("react");
exports.UXAudioRecorderComponent = (props) => {
    var _a;
    const recorderRef = react_1.useRef();
    const [recorder, setRecorderState] = react_1.useState();
    const [isWaiting, setWaiting] = react_1.useState(false);
    const [error, setError] = react_1.useState();
    const [isRecording, setIsRecording] = react_1.useState(false);
    const [isPlaying, setPlaying] = react_1.useState(false);
    const audioElemRef = react_1.useRef(null);
    const [audioRecordingData, setAudioRecordingData] = react_1.useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    function stop() {
        if (audioElemRef.current) {
            audioElemRef.current.pause();
            audioElemRef.current.currentTime = 0;
            audioElemRef.current.onended = null;
            setPlaying(false);
        }
    }
    function play() {
        if (audioElemRef.current) {
            audioElemRef.current.play();
            audioElemRef.current.onended = stop;
            setPlaying(true);
        }
    }
    react_1.useEffect(() => {
        var _a;
        stop();
        if (props.data !== (audioRecordingData !== null && audioRecordingData !== void 0 ? audioRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, audioRecordingData !== null && audioRecordingData !== void 0 ? audioRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [audioRecordingData]);
    react_1.useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            audioRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setAudioRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useAudioErrors(setError);
    react_1.useEffect(() => {
        if (error) {
            if (isRecording) {
                recorder === null || recorder === void 0 ? void 0 : recorder.stop();
            }
            setRecorder(undefined);
            setIsRecording(false);
            setAudioRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    react_1.useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.stop();
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    function onRetryClicked() {
        setError(undefined);
    }
    const onRecordClicked = react_2.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        setWaiting(true);
        try {
            const recorder = yield audio_1.getAudioRecorder();
            setRecorder(recorder);
            recorder.start();
            setIsRecording(true);
            setAudioRecordingData(undefined);
            props.setHasUserRecordingStarted(true);
        }
        catch (e) {
            if (e.message.toLowerCase().includes('permission')) {
                setError(common_1.AudioRecorderError.PERMISSION_DENIED);
            }
            else if (e.message.toLowerCase().includes('device not found')) {
                setError(common_1.AudioRecorderError.NOT_SUPPORTED);
            }
            else {
                setError(common_1.AudioRecorderError.UNKNOWN);
            }
        }
        setWaiting(false);
    }), [props]);
    function onDeleteClicked() {
        setAudioRecordingData(undefined);
    }
    const onStopClicked = react_2.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        setWaiting(true);
        if (!recorder) {
            return;
        }
        const recordingData = yield recorder.stop();
        setIsRecording(false);
        setRecorder(undefined);
        setAudioRecordingData(recordingData);
        setWaiting(false);
    }), [recorder]);
    react_1.useEffect(() => {
        var _a;
        if (!((_a = props.screenRecordingData) === null || _a === void 0 ? void 0 : _a.videoUrl) && !audioRecordingData) {
            onRecordClicked();
        }
    }, [onRecordClicked, props.screenRecordingData, audioRecordingData]);
    react_1.useEffect(() => {
        var _a;
        if (((_a = props.screenRecordingData) === null || _a === void 0 ? void 0 : _a.videoUrl) && isRecording) {
            setIsRecording(false);
            onStopClicked();
        }
    }, [isRecording, onStopClicked, props.screenRecordingData]);
    const pushNotification = common_1.useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    react_1.useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case common_1.AudioRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case common_1.AudioRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case common_1.AudioRecorderError.PERMISSION_DENIED:
                    message =
                        'Please provide permission for audio and video recording.';
                    break;
                case common_1.AudioRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationStore_1.NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    return (react_1.default.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        react_1.default.createElement("span", { className: 'self-start' }, "Audio"),
        react_1.default.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" }, audioRecordingData && (react_1.default.createElement("div", { className: "flex gap-4 p-4" },
            react_1.default.createElement("audio", { className: "hidden", controls: true, ref: audioElemRef, src: audioRecordingData.audioUrl }),
            react_1.default.createElement(core_1.Button, { variant: "contained", onClick: isPlaying ? stop : play }, isPlaying ? react_1.default.createElement(icons_1.Stop, null) : react_1.default.createElement(icons_1.PlayArrow, null)))))));
};
//# sourceMappingURL=UXAudioRecorder.js.map