"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UXVideoDrawingBoard = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const icons_1 = require("@material-ui/icons");
const react_1 = tslib_1.__importDefault(require("react"));
const react_dom_1 = tslib_1.__importDefault(require("react-dom"));
require("./signature.css");
function UXVideoDrawingBoard(props) {
    const { onStopAnnotate } = props;
    return react_dom_1.default.createPortal(react_1.default.createElement("div", { style: { position: 'fixed', zIndex: 999999, top: 0, left: 0 } },
        react_1.default.createElement(common_1.DrawingBoard, null),
        onStopAnnotate && (react_1.default.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                right: 24,
                display: 'flex',
                flexDirection: 'column',
                alignItems: 'center',
                background: '#333',
                borderRadius: 4,
                padding: 8,
                color: '#CCC',
            }, onClick: () => onStopAnnotate === null || onStopAnnotate === void 0 ? void 0 : onStopAnnotate() },
            react_1.default.createElement(icons_1.BrushOutlined, { htmlColor: "#CCC" }),
            react_1.default.createElement("div", null, "Stop Annotation")))), document.body);
}
exports.UXVideoDrawingBoard = UXVideoDrawingBoard;
//# sourceMappingURL=UXVideoDrawingBoard.js.map