"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UXVideoRecorderComponent = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const NotificationStore_1 = require("@fashtag/common/dist/stores/NotificationStore");
const video_1 = require("@fashtag/common/dist/web-media-recorder/video");
const react_1 = tslib_1.__importStar(require("react"));
exports.UXVideoRecorderComponent = (props) => {
    var _a;
    const recorderRef = react_1.useRef();
    const [recorder, setRecorderState] = react_1.useState();
    const [isWaiting, setWaiting] = react_1.useState(false);
    const [error, setError] = react_1.useState();
    const [isRecording, setIsRecording] = react_1.useState(false);
    const videoElemRef = react_1.useRef(null);
    const previewRef = react_1.useRef(null);
    const [videoRecordingData, setVideoRecordingData] = react_1.useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    function stop() {
        if (videoElemRef.current) {
            videoElemRef.current.pause();
            videoElemRef.current.currentTime = 0;
            videoElemRef.current.onended = null;
        }
    }
    react_1.useEffect(() => {
        var _a;
        stop();
        if (props.data !== (videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [videoRecordingData]);
    react_1.useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            videoRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setVideoRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useVideoPermissions(setError);
    react_1.useEffect(() => {
        if (error) {
            if (isRecording) {
                recorder === null || recorder === void 0 ? void 0 : recorder.stop();
            }
            setRecorder(undefined);
            setIsRecording(false);
            setVideoRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    react_1.useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.stop();
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    function onRetryClicked() {
        setError(undefined);
    }
    const onRecordClicked = react_1.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        setWaiting(true);
        try {
            if (!previewRef.current)
                return;
            const recorder = yield video_1.getVideoRecorder(previewRef.current);
            setRecorder(recorder);
            recorder.start();
            setIsRecording(true);
            setVideoRecordingData(undefined);
            props.setHasUserRecordingStarted(true);
        }
        catch (e) {
            console.log(e.message);
            if (e.message.toLowerCase().includes('permission')) {
                setError(common_1.VideoRecorderError.PERMISSION_DENIED);
            }
            else if (e.message.toLowerCase().includes('device not found')) {
                setError(common_1.VideoRecorderError.NOT_SUPPORTED);
            }
            else {
                setError(common_1.VideoRecorderError.UNKNOWN);
            }
        }
        setWaiting(false);
    }), [props]);
    const onStopClicked = react_1.useCallback(() => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        setWaiting(true);
        if (!recorder) {
            return;
        }
        const recordingData = yield recorder.stop();
        setIsRecording(false);
        setRecorder(undefined);
        setVideoRecordingData(recordingData);
        setWaiting(false);
    }), [recorder]);
    react_1.useEffect(() => {
        var _a;
        if (!((_a = props.screenRecordingData) === null || _a === void 0 ? void 0 : _a.videoUrl) && !videoRecordingData) {
            onRecordClicked();
        }
    }, [onRecordClicked, props.screenRecordingData, videoRecordingData]);
    react_1.useEffect(() => {
        var _a;
        if (((_a = props.screenRecordingData) === null || _a === void 0 ? void 0 : _a.videoUrl) && isRecording) {
            setIsRecording(false);
            onStopClicked();
        }
    }, [isRecording, onStopClicked, props.screenRecordingData]);
    function onDeleteClicked() {
        setVideoRecordingData(undefined);
    }
    const pushNotification = common_1.useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    react_1.useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case common_1.VideoRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case common_1.VideoRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case common_1.VideoRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case common_1.VideoRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationStore_1.NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    return (react_1.default.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        react_1.default.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            react_1.default.createElement("div", { className: `flex items-stretch relative`, style: {
                    height: isRecording ? 220 : 0,
                    width: isRecording ? 400 : 0,
                } },
                react_1.default.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, preload: 'auto', autoPlay: true, muted: true })),
            videoRecordingData && (react_1.default.createElement("div", { className: "flex items-stretch relative", style: {
                    width: 400,
                    height: 220,
                } },
                react_1.default.createElement("video", { className: "flex-grow min-w-0", controls: true, preload: "auto", ref: videoElemRef, src: videoRecordingData.videoUrl }))))));
};
//# sourceMappingURL=UXVideoRecorder.js.map