"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableSelector = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const common_1 = require("@fashtag/common");
const mobx_1 = require("mobx");
const styles_1 = require("@material-ui/core/styles");
const getVariablesUI_1 = require("./getVariablesUI");
const useClasses = styles_1.makeStyles(() => {
    return {
        rowInput: {
            padding: '13.2px 14px',
        },
    };
});
exports.VariableSelector = () => {
    var _a;
    const classes = useClasses();
    const { formContextVariables, formContentVariables, startConsumer, isLoading, questionnaireResponseDTO, } = common_1.useSelector((store) => {
        return {
            isLoading: store.consumerStore.questionnaireResponse.isLoading,
            questionnaireResponseDTO: store.consumerStore.questionnaireResponse.data,
            formContextVariables: mobx_1.toJS(store.consumerStore.contextVars),
            formContentVariables: mobx_1.toJS(store.consumerStore.contentVars),
            startConsumer: store.consumerStore.getFirstQuestion,
        };
    });
    const questionnaireVariables = (_a = questionnaireResponseDTO === null || questionnaireResponseDTO === void 0 ? void 0 : questionnaireResponseDTO.questionnare.variables) !== null && _a !== void 0 ? _a : [];
    const handlers = common_1.useSelector((store) => {
        return {
            changeContextVarValue: store.consumerStore.changeContextVarValue,
            changeContentVarValue: store.consumerStore.changeContentVarValue,
        };
    });
    react_1.useEffect(() => {
        if (!isLoading &&
            formContentVariables.length === 0 &&
            formContextVariables.length === 0) {
            startConsumer();
        }
    }, [
        formContentVariables.length,
        formContextVariables.length,
        isLoading,
        startConsumer,
    ]);
    return (react_1.default.createElement("div", { className: 'flex flex-col items-stretch self-stretch gap-4 flex-grow min-h-0 ' +
            'overflow-y-auto p-4' }, formContextVariables.length + formContentVariables.length > 0 && (react_1.default.createElement("div", { className: 'flex flex-col items-stretch gap-4' },
        react_1.default.createElement("span", { style: { fontSize: 16, fontWeight: 400 } }, "Variables"),
        getVariablesUI_1.getVariablesUI(formContextVariables, handlers.changeContextVarValue, classes, questionnaireVariables),
        getVariablesUI_1.getVariablesUI(formContentVariables, handlers.changeContentVarValue, classes, questionnaireVariables)))));
};
//# sourceMappingURL=VariableSelector.js.map